/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.security.lang.PortalSecurityManager;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.ActivePACLPolicy;
import com.liferay.portal.security.pacl.BasePACLPolicy;
import com.liferay.portal.security.pacl.InactivePACLPolicy;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.spring.aop.ServiceBeanAopProxy;
import com.liferay.portal.util.PropsValues;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PACLPolicyManager {
    private static Log _log = LogFactoryUtil.getLog(PACLPolicyManager.class);
    private static int _activeCount;
    private static PACLPolicy _defaultPACLPolicy;
    private static SecurityManager _originalSecurityManager;
    private static Map<ClassLoader, PACLPolicy> _paclPolicies;

    static {
        _defaultPACLPolicy = new InactivePACLPolicy("", PACLPolicyManager.class.getClassLoader(), new Properties());
        _paclPolicies = new HashMap<ClassLoader, PACLPolicy>();
    }

    public static PACLPolicy buildPACLPolicy(String servletContextName, ClassLoader classLoader, Properties properties) {
        boolean active = GetterUtil.getBoolean((Object)properties.get("security-manager-enabled"));
        BasePACLPolicy paclPolicy = null;
        paclPolicy = active ? new ActivePACLPolicy(servletContextName, classLoader, properties) : new InactivePACLPolicy(servletContextName, classLoader, properties);
        return paclPolicy;
    }

    public static int getActiveCount() {
        return _activeCount;
    }

    public static PACLPolicy getDefaultPACLPolicy() {
        return _defaultPACLPolicy;
    }

    public static PACLPolicy getPACLPolicy(ClassLoader classLoader) {
        return _paclPolicies.get(classLoader);
    }

    public static boolean isActive() {
        return _activeCount > 0;
    }

    public static void register(ClassLoader classLoader, PACLPolicy paclPolicy) {
        _paclPolicies.put(classLoader, paclPolicy);
        if (!paclPolicy.isActive()) {
            return;
        }
        if (++_activeCount == 1) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Activating PACL policy manager");
            }
            PACLPolicyManager._overridePortalSecurityManager();
            ServiceBeanAopProxy.clearMethodInterceptorCache();
        }
    }

    public static void unregister(ClassLoader classLoader) {
        PACLPolicy paclPolicy = _paclPolicies.remove(classLoader);
        if (paclPolicy == null || !paclPolicy.isActive()) {
            return;
        }
        if (--_activeCount == 0) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Disabling PACL policy manager");
            }
            PACLPolicyManager._resetPortalSecurityManager();
            ServiceBeanAopProxy.clearMethodInterceptorCache();
        }
    }

    private static void _overridePortalSecurityManager() {
        _originalSecurityManager = System.getSecurityManager();
        if (_originalSecurityManager instanceof PortalSecurityManager) {
            return;
        }
        String portalSecurityManagerStrategy = PropsValues.PORTAL_SECURITY_MANAGER_STRATEGY;
        if (!portalSecurityManagerStrategy.equals("smart")) {
            if (_log.isInfoEnabled()) {
                StringBundler sb = new StringBundler(4);
                sb.append("Plugin security management is not enabled. To ");
                sb.append("enable plugin security management, set the ");
                sb.append("property \"portal.security.manager.strategy\" in ");
                sb.append("portal.properties to \"liferay\" or \"smart\".");
                _log.info((Object)sb.toString());
            }
            return;
        }
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Overriding the current security manager to enable plugin security management");
            }
            System.setSecurityManager(new PortalSecurityManager());
        }
        catch (SecurityException se) {
            _log.error((Object)"Unable to override the current security manager. Plugin security management is not enabled.");
            throw se;
        }
    }

    private static void _resetPortalSecurityManager() {
        if (_originalSecurityManager instanceof PortalSecurityManager) {
            return;
        }
        String portalSecurityManagerStrategy = PropsValues.PORTAL_SECURITY_MANAGER_STRATEGY;
        if (!portalSecurityManagerStrategy.equals("smart")) {
            return;
        }
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Resetting to the original security manager");
            }
            boolean enabled = PortalSecurityManagerThreadLocal.isEnabled();
            try {
                PortalSecurityManagerThreadLocal.setEnabled(false);
                System.setSecurityManager(_originalSecurityManager);
            }
            finally {
                PortalSecurityManagerThreadLocal.setEnabled(enabled);
            }
        }
        catch (SecurityException se) {
            _log.error((Object)"Unable to reset to the original security manager");
            throw se;
        }
    }
}

