/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.PACLConstants;
import com.liferay.portal.kernel.util.PathUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.security.pacl.PACLClassUtil;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.checker.Checker;
import java.util.Properties;
import java.util.Set;
import sun.reflect.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseChecker
implements Checker,
PACLConstants {
    private static final String _ClASS_NAME_COMPILER = "org.apache.jasper.compiler.Compiler";
    private static final String _ClASS_NAME_DEFAULT_ANNOTATION_PROCESSOR = "org.apache.catalina.util.DefaultAnnotationProcessor";
    private static final String _ClASS_NAME_DEFAULT_INSTANCE_MANAGER = "org.apache.catalina.core.DefaultInstanceManager";
    private static final String _ClASS_NAME_JASPER_LOADER = "org.apache.jasper.servlet.JasperLoader";
    private static final String _CLASS_NAME_JASPER_SERVLET_CONTEXT_CUSTOMIZER = "org.apache.geronimo.jasper.JasperServletContextCustomizer$";
    private static final String _CLASS_NAME_JSP_CLASS_LOADER = "weblogic.servlet.jsp.JspClassLoader";
    private static final String _ClASS_NAME_JSP_COMPILATION_CONTEXT = "org.apache.jasper.JspCompilationContext";
    private static final String _CLASS_NAME_JSP_EXTENSION_CLASS_LOADER = "com.ibm.ws.jsp.webcontainerext.JSPExtensionClassLoader";
    private static final String _ClASS_NAME_JSP_MANAGER = "com.caucho.jsp.JspManager";
    private static final String _CLASS_NAME_JSP_STUB = "weblogic.servlet.jsp.JspStub";
    private static final String _ClASS_NAME_JSP_TRANSLATOR_UTIL = "com.ibm.ws.jsp.translator.utils.JspTranslatorUtil";
    private static final String _ClASS_NAME_PAGE_MANAGER = "com.caucho.jsp.PageManager";
    private static final String _ClASS_NAME_TAG_HANDLER_POOL = "org.apache.jasper.runtime.TagHandlerPool";
    private static final String _MODULE_NAME_ORG_JBOSS_AS_WEB_MAIN = "org.jboss.as.web:main";
    private static Log _log = LogFactoryUtil.getLog(BaseChecker.class);
    private ClassLoader _commonClassLoader;
    private PACLPolicy _paclPolicy;
    private ClassLoader _portalClassLoader;
    private ClassLoader _systemClassLoader;

    public BaseChecker() {
        ClassLoader portalClassLoader;
        this._portalClassLoader = portalClassLoader = BaseChecker.class.getClassLoader();
        this._commonClassLoader = portalClassLoader.getParent();
        this._systemClassLoader = ClassLoader.getSystemClassLoader();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._paclPolicy.getClassLoader();
    }

    public ClassLoader getCommonClassLoader() {
        return this._commonClassLoader;
    }

    @Override
    public PACLPolicy getPACLPolicy() {
        return this._paclPolicy;
    }

    public ClassLoader getPortalClassLoader() {
        return this._portalClassLoader;
    }

    @Override
    public String getServletContextName() {
        return this._paclPolicy.getServletContextName();
    }

    public ClassLoader getSystemClassLoader() {
        return this._systemClassLoader;
    }

    @Override
    public void setPACLPolicy(PACLPolicy paclPolicy) {
        this._paclPolicy = paclPolicy;
    }

    protected Properties getProperties() {
        return this._paclPolicy.getProperties();
    }

    protected String getProperty(String key) {
        return this._paclPolicy.getProperty(key);
    }

    protected String[] getPropertyArray(String key) {
        return this._paclPolicy.getPropertyArray(key);
    }

    protected boolean getPropertyBoolean(String key) {
        return this._paclPolicy.getPropertyBoolean(key);
    }

    protected Set<String> getPropertySet(String key) {
        return this._paclPolicy.getPropertySet(key);
    }

    protected boolean isJSPCompiler(String subject, String actions) {
        int i2 = 7;
        Class callerClass;
        while ((callerClass = Reflection.getCallerClass((int)i2)) != null) {
            ClassLoader callerClassLoader;
            String classLocation;
            String expectedClassLocation;
            String actualClassLocation;
            Boolean allowed = null;
            String callerClassName = callerClass.getName();
            if (ServerDetector.isGeronimo()) {
                if (callerClassName.equals(_ClASS_NAME_COMPILER) || callerClassName.startsWith(_CLASS_NAME_JASPER_SERVLET_CONTEXT_CUSTOMIZER) || callerClassName.equals(_ClASS_NAME_TAG_HANDLER_POOL)) {
                    actualClassLocation = PACLClassUtil.getClassLocation(callerClass);
                    expectedClassLocation = PathUtil.toUnixPath((String)(String.valueOf(System.getProperty("org.apache.geronimo.home.dir")) + "/repository/org/apache/geronimo/"));
                    allowed = actualClassLocation.contains(expectedClassLocation);
                }
            } else if (ServerDetector.isGlassfish()) {
                if (callerClassName.equals(_ClASS_NAME_COMPILER) || callerClassName.equals(_ClASS_NAME_JSP_COMPILATION_CONTEXT)) {
                    classLocation = PACLClassUtil.getClassLocation(callerClass);
                    allowed = classLocation.startsWith("bundle://");
                }
            } else if (ServerDetector.isJBoss()) {
                if (callerClassName.equals(_ClASS_NAME_COMPILER)) {
                    callerClassLoader = PACLClassLoaderUtil.getClassLoader(callerClass);
                    String callerClassLoaderString = callerClassLoader.toString();
                    allowed = callerClassLoaderString.contains(_MODULE_NAME_ORG_JBOSS_AS_WEB_MAIN);
                }
            } else if (ServerDetector.isJetty()) {
                if (callerClassName.equals(_ClASS_NAME_COMPILER) || callerClassName.equals(_ClASS_NAME_JASPER_LOADER)) {
                    callerClassLoader = PACLClassLoaderUtil.getClassLoader(callerClass);
                    allowed = callerClassLoader == this._commonClassLoader;
                }
            } else if (ServerDetector.isJOnAS()) {
                if (callerClassName.equals(_ClASS_NAME_DEFAULT_ANNOTATION_PROCESSOR) || callerClassName.equals(_ClASS_NAME_JASPER_LOADER) || callerClassName.equals(_ClASS_NAME_JSP_COMPILATION_CONTEXT)) {
                    classLocation = PACLClassUtil.getClassLocation(callerClass);
                    allowed = classLocation.startsWith("bundle://");
                }
            } else if (ServerDetector.isResin()) {
                if (callerClassName.equals(_ClASS_NAME_JSP_MANAGER) || callerClassName.equals(_ClASS_NAME_PAGE_MANAGER)) {
                    actualClassLocation = PACLClassUtil.getClassLocation(callerClass);
                    expectedClassLocation = PathUtil.toUnixPath((String)(String.valueOf(System.getProperty("resin.home")) + "/lib/resin.jar!/"));
                    allowed = actualClassLocation.contains(expectedClassLocation);
                }
            } else if (ServerDetector.isTomcat()) {
                if (callerClassName.equals(_ClASS_NAME_DEFAULT_INSTANCE_MANAGER) || callerClassName.equals(_ClASS_NAME_COMPILER) || callerClassName.equals(_ClASS_NAME_TAG_HANDLER_POOL)) {
                    callerClassLoader = PACLClassLoaderUtil.getClassLoader(callerClass);
                    allowed = callerClassLoader == this._commonClassLoader;
                }
            } else if (ServerDetector.isWebLogic()) {
                if (callerClassName.equals(_CLASS_NAME_JSP_CLASS_LOADER) || callerClassName.equals(_CLASS_NAME_JSP_STUB)) {
                    classLocation = PACLClassUtil.getClassLocation(callerClass);
                    allowed = classLocation.contains("/wlserver/server/lib/weblogic.jar!/");
                }
            } else if (ServerDetector.isWebSphere() && (callerClassName.equals(_CLASS_NAME_JSP_EXTENSION_CLASS_LOADER) || callerClassName.equals(_ClASS_NAME_JSP_TRANSLATOR_UTIL))) {
                classLocation = PACLClassUtil.getClassLocation(callerClass);
                return classLocation.startsWith("bundleresource://");
            }
            if (allowed != null) {
                if (allowed.booleanValue()) {
                    if (_log.isDebugEnabled()) {
                        if (Validator.isNotNull((String)actions)) {
                            _log.debug((Object)("Allowing the JSP compiler via " + callerClassName + " to " + actions + " " + subject));
                        } else {
                            _log.debug((Object)("Allowing the JSP compiler via " + callerClassName + " to " + subject));
                        }
                    }
                    return true;
                }
                if (Validator.isNotNull((String)actions)) {
                    _log.error((Object)("A plugin is hijacking the JSP compiler via " + callerClassName + " to " + actions + " " + subject));
                } else {
                    _log.error((Object)("A plugin is hijacking the JSP compiler via " + callerClassName + " to " + subject));
                }
                return false;
            }
            ++i2;
        }
        return false;
    }

    protected void throwSecurityException(Log log, String message) {
        if (log.isWarnEnabled()) {
            log.warn((Object)message);
        }
        throw new SecurityException(message);
    }
}

