/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.config.AbstractMessagingConfigurator;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.kernel.util.PathUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.security.pacl.PACLClassUtil;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import com.liferay.portal.security.pacl.checker.CheckerUtil;
import java.beans.Introspector;
import org.hibernate.property.BasicPropertyAccessor;
import org.hibernate.tuple.entity.EntityTuplizerFactory;
import org.hibernate.util.ReflectHelper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.support.SimpleInstantiationStrategy;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.util.ReflectionUtils;
import sun.reflect.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseReflectChecker
extends BaseChecker {
    private static final String _CLASS_NAME_ABSTRACT_BEAN_DEFINITION_DELEGATOR = "weblogic.spring.monitoring.utils.AbstractBeanDefinitionDelegator";
    private static final String _CLASS_NAME_ABSTRACT_APPLICATION_CONTEXT_DELEGATOR = "weblogic.spring.monitoring.utils.AbstractApplicationContextDelegator";
    private static final String _CLASS_NAME_JAVA_SESSION_SERIALIZER = "com.caucho.server.session.JavaSessionSerializer";
    private static final String _CLASS_NAME_REFLECTION_ANNOTATED_TYPE = "com.caucho.config.reflect.ReflectionAnnotatedType";
    private static final String _CLASS_NAME_SECURE_ACTION = "org.apache.felix.framework.util.SecureAction";
    private static Log _log = LogFactoryUtil.getLog(BaseReflectChecker.class);

    protected boolean hasReflect(String name, String actions) {
        if (this.isJSPCompiler(name, actions)) {
            return true;
        }
        Class callerClass9 = Reflection.getCallerClass((int)9);
        if (this.isResinReflectionAnnotatedType(callerClass9)) {
            this.logReflect(callerClass9, 9);
            return true;
        }
        if (this.isResinJavaSessionSerializer()) {
            return true;
        }
        if (callerClass9 == AbstractMessagingConfigurator.class) {
            this.logReflect(callerClass9, 9);
            return true;
        }
        if (callerClass9.getEnclosingClass() == Introspector.class && CheckerUtil.isAccessControllerDoPrivileged(10)) {
            this.logReflect(callerClass9, 9);
            return true;
        }
        Class callerClass7 = Reflection.getCallerClass((int)7);
        if (JavaDetector.isIBM() || JavaDetector.isJDK7()) {
            Class callerClass8 = Reflection.getCallerClass((int)8);
            if (callerClass8.getEnclosingClass() == Class.class && CheckerUtil.isAccessControllerDoPrivileged(9)) {
                this.logReflect(callerClass8, 8);
                return true;
            }
        } else if (callerClass7.getEnclosingClass() == Class.class && CheckerUtil.isAccessControllerDoPrivileged(8)) {
            this.logReflect(callerClass7, 7);
            return true;
        }
        if (JavaDetector.isJDK7() || JavaDetector.isOpenJDK()) {
            Class callerClass10 = Reflection.getCallerClass((int)10);
            if (callerClass10.getEnclosingClass() == Thread.class && CheckerUtil.isAccessControllerDoPrivileged(11)) {
                this.logReflect(callerClass10, 10);
                return true;
            }
        } else if (callerClass9.getEnclosingClass() == Thread.class && CheckerUtil.isAccessControllerDoPrivileged(10)) {
            this.logReflect(callerClass9, 9);
            return true;
        }
        if (this.isGlassfishSecureAction(callerClass7.getEnclosingClass()) && CheckerUtil.isAccessControllerDoPrivileged(8)) {
            this.logReflect(callerClass7, 7);
            return true;
        }
        if (callerClass9 == BasicPropertyAccessor.class) {
            this.logReflect(callerClass9, 9);
            return true;
        }
        if (callerClass7 == EntityTuplizerFactory.class) {
            this.logReflect(callerClass7, 7);
            return true;
        }
        if (callerClass9 == ReflectHelper.class) {
            this.logReflect(callerClass9, 9);
            return true;
        }
        if (callerClass9 == BeanUtils.class) {
            this.logReflect(callerClass9, 9);
            return true;
        }
        if (callerClass9.getEnclosingClass() == SimpleInstantiationStrategy.class) {
            this.logReflect(callerClass9, 9);
            return true;
        }
        if (callerClass9.getEnclosingClass() == LocalVariableTableParameterNameDiscoverer.class) {
            this.logReflect(callerClass9, 9);
            return true;
        }
        if (callerClass7 == ReflectionUtils.class) {
            this.logReflect(callerClass7, 7);
            return true;
        }
        if (callerClass9 == ReflectionUtils.class) {
            this.logReflect(callerClass9, 9);
            return true;
        }
        if (this.isWebLogicAbstractApplicationContextDelegator(callerClass9)) {
            this.logReflect(callerClass9, 9);
            return true;
        }
        if (this.isWebLogicAbstractBeanDefinitionDelegator(callerClass9)) {
            this.logReflect(callerClass9, 9);
            return true;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Rejecting call stack:");
            int i2 = 6;
            while (i2 < 11) {
                _log.debug((Object)("Frame " + i2 + " " + Reflection.getCallerClass((int)i2)));
                ++i2;
            }
        }
        return false;
    }

    protected boolean isGlassfishSecureAction(Class<?> clazz) {
        if (!ServerDetector.isGlassfish()) {
            return false;
        }
        if (clazz == null) {
            return false;
        }
        String className = clazz.getName();
        if (!className.equals(_CLASS_NAME_SECURE_ACTION)) {
            return false;
        }
        String classLocation = PACLClassUtil.getClassLocation(clazz);
        return classLocation.contains("/osgi/felix/bin/felix.jar!");
    }

    protected boolean isResinJavaSessionSerializer() {
        if (!ServerDetector.isResin()) {
            return false;
        }
        int i2 = 7;
        Class callerClass;
        while ((callerClass = Reflection.getCallerClass((int)i2)) != null) {
            String callerClassName = callerClass.getName();
            if (callerClassName.equals(_CLASS_NAME_JAVA_SESSION_SERIALIZER)) {
                String expectedClassLocation;
                String actualClassLocation = PACLClassUtil.getClassLocation(callerClass);
                if (actualClassLocation.contains(expectedClassLocation = PathUtil.toUnixPath((String)(String.valueOf(System.getProperty("resin.home")) + "/lib/resin.jar!/")))) {
                    this.logReflect(callerClass, i2);
                    return true;
                }
                return false;
            }
            ++i2;
        }
        return false;
    }

    protected boolean isResinReflectionAnnotatedType(Class<?> clazz) {
        if (!ServerDetector.isResin()) {
            return false;
        }
        String className = clazz.getName();
        if (!className.equals(_CLASS_NAME_REFLECTION_ANNOTATED_TYPE)) {
            return false;
        }
        String actualClassLocation = PACLClassUtil.getClassLocation(clazz);
        String expectedClassLocation = PathUtil.toUnixPath((String)(String.valueOf(System.getProperty("resin.home")) + "/lib/resin.jar!/"));
        return actualClassLocation.contains(expectedClassLocation);
    }

    protected boolean isWebLogicAbstractApplicationContextDelegator(Class<?> clazz) {
        if (!ServerDetector.isWebLogic()) {
            return false;
        }
        String className = clazz.getName();
        if (!className.equals(_CLASS_NAME_ABSTRACT_APPLICATION_CONTEXT_DELEGATOR)) {
            return false;
        }
        String classLocation = PACLClassUtil.getClassLocation(clazz);
        return classLocation.contains("/modules/com.bea.core.weblogic.spring.instrument_") || classLocation.contains("/patch_jars/BUG");
    }

    protected boolean isWebLogicAbstractBeanDefinitionDelegator(Class<?> clazz) {
        if (!ServerDetector.isWebLogic()) {
            return false;
        }
        String className = clazz.getName();
        if (!className.equals(_CLASS_NAME_ABSTRACT_BEAN_DEFINITION_DELEGATOR)) {
            return false;
        }
        String classLocation = PACLClassUtil.getClassLocation(clazz);
        return classLocation.contains("/modules/com.bea.core.weblogic.spring.instrument_") || classLocation.contains("/patch_jars/BUG");
    }

    protected void logReflect(Class<?> callerClass, int frame) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Allowing frame " + frame + " with caller " + callerClass + " to reflect"));
        }
    }
}

