/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.util.JavaDetector;
import java.security.AccessController;
import sun.reflect.Reflection;

public class CheckerUtil {
    private static final String _METHOD_NAME_DO_PRIVILEGED = "doPrivileged";

    public static boolean isAccessControllerDoPrivileged(int frame) {
        Class callerClass;
        if ((callerClass = Reflection.getCallerClass((int)(++frame))) != AccessController.class) {
            return false;
        }
        Thread currentThread = Thread.currentThread();
        StackTraceElement[] stackTraceElements = currentThread.getStackTrace();
        if (JavaDetector.isIBM()) {
            ++frame;
        }
        StackTraceElement stackTraceElement = stackTraceElements[frame];
        String methodName = stackTraceElement.getMethodName();
        return methodName.equals(_METHOD_NAME_DO_PRIVILEGED);
    }
}

