/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.deploy.DeployManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.servlet.WebDirDetector;
import com.liferay.portal.kernel.servlet.taglib.FileAvailabilityUtil;
import com.liferay.portal.kernel.util.ContextPathUtil;
import com.liferay.portal.kernel.util.PathUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.PACLClassUtil;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import com.liferay.portal.security.pacl.checker.CheckerUtil;
import com.liferay.portal.servlet.DirectServletRegistryImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URLClassLoader;
import java.security.Permission;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletContext;
import sun.reflect.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileChecker
extends BaseChecker {
    private static final String _CLASS_NAME_FILE_PATH = "com.caucho.vfs.FilePath";
    private static final String _CLASS_NAME_METHOD_UTIL = "sun.reflect.misc.MethodUtil";
    private static Log _log = LogFactoryUtil.getLog(FileChecker.class);
    private String[] _defaultReadPathsFromArray;
    private String[] _defaultReadPathsToArray;
    private List<Permission> _deletePermissions;
    private List<Permission> _executePermissions;
    private String _globalSharedLibDir = PropsValues.LIFERAY_LIB_GLOBAL_SHARED_DIR;
    private String _portalDir = PropsValues.LIFERAY_WEB_PORTAL_DIR;
    private List<Permission> _readPermissions;
    private String _rootDir;
    private String _workDir;
    private List<Permission> _writePermissions;

    @Override
    public void afterPropertiesSet() {
        ServletContext servletContext;
        try {
            this._rootDir = WebDirDetector.getRootDir((ClassLoader)this.getClassLoader());
        }
        catch (Exception exception) {}
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Root directory " + this._rootDir));
        }
        if ((servletContext = ServletContextPool.get((String)this.getServletContextName())) != null) {
            File tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            this._workDir = tempDir.getAbsolutePath();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Work directory " + this._workDir));
            }
        }
        this._defaultReadPathsFromArray = new String[]{"${auto.deploy.installed.dir}", "${catalina.base}", "${com.sun.aas.instanceRoot}", "${com.sun.aas.installRoot}", "${file.separator}", "${java.io.tmpdir}", "${jboss.home.dir}", "${jetty.home}", "${jonas.base}", "${liferay.web.portal.dir}", "${line.separator}", "${org.apache.geronimo.home.dir}", "${path.separator}", "${plugin.servlet.context.name}", "${release.info.version}", "${resin.home}", "${user.dir}", "${user.home}", "${user.name}", "${weblogic.domain.dir}", "${websphere.profile.dir}", "//"};
        String installedDir = "";
        try {
            if (DeployManagerUtil.getDeployManager() != null) {
                installedDir = DeployManagerUtil.getInstalledDir();
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        this._defaultReadPathsToArray = new String[]{installedDir, System.getProperty("catalina.base"), System.getProperty("com.sun.aas.instanceRoot"), System.getProperty("com.sun.aas.installRoot"), System.getProperty("file.separator"), System.getProperty("java.io.tmpdir"), System.getProperty("jboss.home.dir"), System.getProperty("jetty.home"), System.getProperty("jonas.base"), this._portalDir, System.getProperty("line.separator"), System.getProperty("org.apache.geronimo.home.dir"), System.getProperty("path.separator"), this.getServletContextName(), ReleaseInfo.getVersion(), System.getProperty("resin.home"), System.getProperty("user.dir"), System.getProperty("user.home"), System.getProperty("user.name"), System.getenv("DOMAIN_HOME"), System.getenv("USER_INSTALL_ROOT"), "/"};
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Default read paths replace with " + StringUtil.merge((Object[])this._defaultReadPathsToArray)));
        }
        this.initPermissions();
    }

    @Override
    public void checkPermission(Permission permission) {
        String name = permission.getName();
        String actions = permission.getActions();
        if (actions.equals("delete")) {
            if (!this.hasDelete(permission)) {
                this.throwSecurityException(_log, "Attempted to delete file " + name);
            }
        } else if (actions.equals("execute")) {
            if (!this.hasExecute(permission)) {
                this.throwSecurityException(_log, "Attempted to execute file " + name);
            }
        } else if (actions.equals("read")) {
            if (PortalSecurityManagerThreadLocal.isCheckReadFile() && !this.hasRead(permission)) {
                this.throwSecurityException(_log, "Attempted to read file " + name);
            }
        } else if (actions.equals("write") && !this.hasWrite(permission)) {
            this.throwSecurityException(_log, "Attempted to write file " + name);
        }
    }

    protected void addCanonicalPath(List<String> paths, String path) {
        Iterator<String> itr = paths.iterator();
        while (itr.hasNext()) {
            String curPath = itr.next();
            if (curPath.startsWith(path) && curPath.length() > path.length()) {
                itr.remove();
                continue;
            }
            if (!path.startsWith(curPath)) continue;
            return;
        }
        if ((path = StringUtil.replace((String)path, (String)"\\", (String)"/")).endsWith("/")) {
            path = String.valueOf(path) + "-";
        }
        paths.add(path);
    }

    protected void addCanonicalPaths(List<String> paths, File directory) throws IOException {
        this.addCanonicalPath(paths, String.valueOf(directory.getCanonicalPath()) + "/");
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.addCanonicalPaths(paths, file);
            } else {
                File canonicalFile = new File(file.getCanonicalPath());
                File parentFile = canonicalFile.getParentFile();
                this.addCanonicalPath(paths, String.valueOf(parentFile.getPath()) + "/");
            }
            ++n2;
        }
    }

    protected void addDefaultReadPaths(List<String> paths, String selector) {
        String[] pathsArray;
        String[] stringArray = pathsArray = PropsUtil.getArray("portal.security.manager.file.checker.default.read.paths", new Filter(selector));
        int n = pathsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            path = StringUtil.replace((String)path, (String[])this._defaultReadPathsFromArray, (String[])this._defaultReadPathsToArray);
            paths.add(path);
            ++n2;
        }
    }

    protected void addPermission(List<Permission> permissions, String path, String actions) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Allowing " + actions + " on " + path));
        }
        String unixPath = PathUtil.toUnixPath((String)path);
        FilePermission unixPermission = new FilePermission(unixPath, actions);
        permissions.add(unixPermission);
        String windowsPath = PathUtil.toWindowsPath((String)path);
        FilePermission windowsPermission = new FilePermission(windowsPath, actions);
        permissions.add(windowsPermission);
    }

    protected List<Permission> getPermissions(String key, String actions) {
        CopyOnWriteArrayList<Permission> permissions = new CopyOnWriteArrayList<Permission>();
        String value = this.getProperty(key);
        if (value != null) {
            value = StringUtil.replace((String)value, (String[])this._defaultReadPathsFromArray, (String[])this._defaultReadPathsToArray);
            String[] paths = StringUtil.split((String)value);
            if (value.contains("${comma}")) {
                int i2 = 0;
                while (i2 < paths.length) {
                    paths[i2] = StringUtil.replace((String)paths[i2], (String)"${comma}", (String)",");
                    ++i2;
                }
            }
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                this.addPermission(permissions, path, actions);
                ++n2;
            }
        }
        String pathContext = ContextPathUtil.getContextPath((String)PropsValues.PORTAL_CTX);
        ServletContext servletContext = ServletContextPool.get((String)pathContext);
        if (!actions.equals("execute") && this._workDir != null) {
            this.addPermission(permissions, this._workDir, actions);
            this.addPermission(permissions, String.valueOf(this._workDir) + "/-", actions);
            if (servletContext != null) {
                File tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
                String tempDirAbsolutePath = tempDir.getAbsolutePath();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Temp directory " + tempDirAbsolutePath));
                }
                if (actions.equals("read")) {
                    this.addPermission(permissions, tempDirAbsolutePath, actions);
                }
                this.addPermission(permissions, String.valueOf(tempDirAbsolutePath) + "/-", actions);
            }
        }
        if (!actions.equals("read")) {
            return permissions;
        }
        UniqueList paths = new UniqueList();
        try {
            File file = new File(String.valueOf(System.getProperty("java.home")) + "/lib");
            this.addCanonicalPaths((List<String>)paths, file);
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
        }
        if (Validator.isNotNull((String)this._globalSharedLibDir)) {
            paths.add(String.valueOf(this._globalSharedLibDir) + "-");
        }
        if (this._rootDir != null) {
            paths.add(String.valueOf(this._rootDir) + "-");
        }
        this.addDefaultReadPaths((List<String>)paths, ServerDetector.getServerId());
        for (String path : paths) {
            this.addPermission(permissions, path, actions);
        }
        return permissions;
    }

    protected boolean hasDelete(Permission permission) {
        for (Permission deleteFilePermission : this._deletePermissions) {
            if (!deleteFilePermission.implies(permission)) continue;
            return true;
        }
        if (ServerDetector.isResin()) {
            int i2 = 7;
            while (true) {
                Class callerClass;
                if ((callerClass = Reflection.getCallerClass((int)i2)) == null) {
                    return false;
                }
                String callerClassName = callerClass.getName();
                if (callerClassName.equals(_CLASS_NAME_FILE_PATH)) {
                    String actualClassLocation = PACLClassUtil.getClassLocation(callerClass);
                    String expectedClassLocation = PathUtil.toUnixPath((String)(String.valueOf(System.getProperty("resin.home")) + "/lib/resin.jar!/"));
                    return actualClassLocation.contains(expectedClassLocation);
                }
                ++i2;
            }
        }
        return false;
    }

    protected boolean hasExecute(Permission permission) {
        for (Permission executeFilePermission : this._executePermissions) {
            if (!executeFilePermission.implies(permission)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasRead(Permission permission) {
        for (Permission readFilePermission : this._readPermissions) {
            if (!readFilePermission.implies(permission)) continue;
            return true;
        }
        if (this.isJSPCompiler(permission.getName(), "read")) {
            return true;
        }
        int i2 = 7;
        Class callerClass;
        while ((callerClass = Reflection.getCallerClass((int)i2)) != null) {
            String callerClassName;
            if (callerClass == DirectServletRegistryImpl.class || callerClass == FileAvailabilityUtil.class) {
                return true;
            }
            if (ClassLoader.class.isAssignableFrom(callerClass) && !(callerClassName = callerClass.getName()).equals(_CLASS_NAME_METHOD_UTIL)) {
                return true;
            }
            if (ServerDetector.isGlassfish()) {
                Class<?> enclosingClass = callerClass.getEnclosingClass();
                if (enclosingClass != null && enclosingClass.getEnclosingClass() == URLClassLoader.class && CheckerUtil.isAccessControllerDoPrivileged(i2 + 1)) {
                    return true;
                }
            } else if (ServerDetector.isResin() && (callerClassName = callerClass.getName()).equals(_CLASS_NAME_FILE_PATH)) {
                String actualClassLocation = PACLClassUtil.getClassLocation(callerClass);
                String expectedClassLocation = PathUtil.toUnixPath((String)(String.valueOf(System.getProperty("resin.home")) + "/lib/resin.jar!/"));
                return actualClassLocation.contains(expectedClassLocation);
            }
            ++i2;
        }
        return false;
    }

    protected boolean hasWrite(Permission permission) {
        for (Permission writeFilePermission : this._writePermissions) {
            if (!writeFilePermission.implies(permission)) continue;
            return true;
        }
        if (ServerDetector.isResin()) {
            int i2 = 7;
            while (true) {
                Class callerClass;
                if ((callerClass = Reflection.getCallerClass((int)i2)) == null) {
                    return false;
                }
                String callerClassName = callerClass.getName();
                if (callerClassName.equals(_CLASS_NAME_FILE_PATH)) {
                    String actualClassLocation = PACLClassUtil.getClassLocation(callerClass);
                    String expectedClassLocation = PathUtil.toUnixPath((String)(String.valueOf(System.getProperty("resin.home")) + "/lib/resin.jar!/"));
                    return actualClassLocation.contains(expectedClassLocation);
                }
                ++i2;
            }
        }
        return ServerDetector.isWebSphere() && this.isJSPCompiler(permission.getName(), "write");
    }

    protected void initPermissions() {
        this._deletePermissions = this.getPermissions("security-manager-files-delete", "delete");
        this._executePermissions = this.getPermissions("security-manager-files-execute", "execute");
        this._readPermissions = this.getPermissions("security-manager-files-read", "read");
        this._writePermissions = this.getPermissions("security-manager-files-write", "write");
    }
}

