/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import com.liferay.portal.security.pacl.checker.CheckerUtil;
import java.security.Permission;
import sun.reflect.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetChecker
extends BaseChecker {
    private static final String _CLASS_NAME_SOCKS_SOCKET_IMPL = "java.net.SocksSocketImpl$";
    private static Log _log = LogFactoryUtil.getLog(NetChecker.class);

    @Override
    public void afterPropertiesSet() {
    }

    @Override
    public void checkPermission(Permission permission) {
        String name = permission.getName();
        if (name.equals("getProxySelector")) {
            if (!this.hasGetProxySelector()) {
                this.throwSecurityException(_log, "Attempted to get proxy selector");
            }
        } else {
            name.equals("specifyStreamHandler");
        }
    }

    protected boolean hasGetProxySelector() {
        if (JavaDetector.isJDK7()) {
            Class callerClass8 = Reflection.getCallerClass((int)8);
            String className8 = callerClass8.getName();
            if (className8.startsWith(_CLASS_NAME_SOCKS_SOCKET_IMPL) && CheckerUtil.isAccessControllerDoPrivileged(9)) {
                this.logGetProxySelector(callerClass8, 8);
                return true;
            }
        } else {
            Class callerClass7 = Reflection.getCallerClass((int)7);
            String className7 = callerClass7.getName();
            if (className7.startsWith(_CLASS_NAME_SOCKS_SOCKET_IMPL) && CheckerUtil.isAccessControllerDoPrivileged(8)) {
                this.logGetProxySelector(callerClass7, 7);
                return true;
            }
        }
        return false;
    }

    protected void logGetProxySelector(Class<?> callerClass, int frame) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Allowing frame " + frame + " with caller " + callerClass + " to get the proxy selector"));
        }
    }
}

