/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalHookPermission;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.security.Permission;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

public class PortalHookChecker
extends BaseChecker {
    private static Log _log = LogFactoryUtil.getLog(PortalHookChecker.class);
    private boolean _customJspDir;
    private Set<String> _indexers;
    private Set<String> _languagePropertiesLanguageIds;
    private Set<String> _portalPropertiesKeys;
    private Set<String> _services;
    private boolean _servletFilters;
    private Set<String> _strutsActionPaths;

    public void afterPropertiesSet() {
        this.initCustomJspDir();
        this.initIndexers();
        this.initLanguagePropertiesLocales();
        this.initPortalPropertiesKeys();
        this.initServletFilters();
        this.initServices();
        this.initStrutsActionPaths();
    }

    public void checkPermission(Permission permission) {
        String strutsActionPath;
        PortalHookPermission portalHookPermission = (PortalHookPermission)permission;
        String name = portalHookPermission.getName();
        Object subject = portalHookPermission.getSubject();
        if (name.equals("customJspDir")) {
            if (!this._customJspDir) {
                this.throwSecurityException(_log, "Attempted to set custom jsp dir");
            }
        } else if (name.equals("hasIndexer")) {
            String indexerClassName = (String)subject;
            if (!this._indexers.contains(indexerClassName)) {
                this.throwSecurityException(_log, "Attempted to add indexer " + indexerClassName);
            }
        } else if (name.equals("languagePropertiesLocale")) {
            Locale locale = (Locale)subject;
            if (!this._languagePropertiesLanguageIds.contains(locale.getLanguage()) && !this._languagePropertiesLanguageIds.contains(String.valueOf(locale.getLanguage()) + "_" + locale.getCountry())) {
                this.throwSecurityException(_log, "Attempted to override locale " + locale);
            }
        } else if (name.equals("hasPortalPropertiesKey")) {
            String key = (String)subject;
            if (!this._portalPropertiesKeys.contains(key)) {
                this.throwSecurityException(_log, "Attempted to set portal property " + key);
            }
        } else if (name.equals("service")) {
            String serviceType = (String)subject;
            if (!this._services.contains(serviceType)) {
                this.throwSecurityException(_log, "Attempted to override service " + serviceType);
            }
        } else if (name.equals("servletFilters")) {
            if (!this._servletFilters) {
                this.throwSecurityException(_log, "Attempted to override serlvet filters");
            }
        } else if (name.equals("strutsActionPath") && !this._strutsActionPaths.contains(strutsActionPath = (String)subject)) {
            this.throwSecurityException(_log, "Attempted to use struts action path " + strutsActionPath);
        }
    }

    protected void initCustomJspDir() {
        this._customJspDir = this.getPropertyBoolean("security-manager-hook-custom-jsp-dir-enabled");
        if (_log.isDebugEnabled() && this._customJspDir) {
            _log.debug((Object)"Allowing custom JSP dir");
        }
    }

    protected void initIndexers() {
        this._indexers = this.getPropertySet("security-manager-hook-indexers");
        if (_log.isDebugEnabled()) {
            TreeSet<String> indexers = new TreeSet<String>(this._indexers);
            for (String indexer : indexers) {
                _log.debug((Object)("Allowing indexer " + indexer));
            }
        }
    }

    protected void initLanguagePropertiesLocales() {
        this._languagePropertiesLanguageIds = this.getPropertySet("security-manager-hook-language-properties-locales");
        if (_log.isDebugEnabled()) {
            TreeSet<String> languageIds = new TreeSet<String>(this._languagePropertiesLanguageIds);
            for (String languageId : languageIds) {
                _log.debug((Object)("Allowing locale " + languageId));
            }
        }
    }

    protected void initPortalPropertiesKeys() {
        this._portalPropertiesKeys = this.getPropertySet("security-manager-hook-portal-properties-keys");
        if (_log.isDebugEnabled()) {
            TreeSet<String> keys = new TreeSet<String>(this._portalPropertiesKeys);
            for (String key : keys) {
                _log.debug((Object)("Allowing portal.properties key " + key));
            }
        }
    }

    protected void initServices() {
        this._services = this.getPropertySet("security-manager-hook-services");
        if (_log.isDebugEnabled()) {
            TreeSet<String> services = new TreeSet<String>(this._services);
            for (String service : services) {
                _log.debug((Object)("Allowing service " + service));
            }
        }
    }

    protected void initServletFilters() {
        this._servletFilters = this.getPropertyBoolean("security-manager-hook-servlet-filters-enabled");
        if (_log.isDebugEnabled() && this._servletFilters) {
            _log.debug((Object)"Allowing servlet filters");
        }
    }

    protected void initStrutsActionPaths() {
        this._strutsActionPaths = this.getPropertySet("security-manager-hook-struts-action-paths");
        if (_log.isDebugEnabled()) {
            TreeSet<String> strutsActionPaths = new TreeSet<String>(this._strutsActionPaths);
            for (String strutsActionPath : strutsActionPaths) {
                _log.debug((Object)("Allowing Struts action path " + strutsActionPath));
            }
        }
    }
}

