/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.executor.PortalExecutorManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseAsyncDestination;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.security.Permission;
import java.util.Set;
import java.util.TreeSet;
import sun.reflect.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalRuntimeChecker
extends BaseChecker {
    private static Log _log = LogFactoryUtil.getLog(PortalRuntimeChecker.class);
    private Set<String> _expandoBridgeClassNames;
    private Set<String> _getBeanPropertyClassNames;
    private Set<String> _searchEngineIds;
    private Set<String> _setBeanPropertyClassNames;
    private Set<String> _threadPoolExecutorNames;

    @Override
    public void afterPropertiesSet() {
        this.initExpandoBridgeClassNames();
        this.initGetBeanPropertyClassNames();
        this.initSearchEngineIds();
        this.initSetBeanPropertyClassNames();
        this.initThreadPoolExecutorNames();
    }

    @Override
    public void checkPermission(Permission permission) {
        String threadPoolExecutorName;
        PortalRuntimePermission portalRuntimePermission = (PortalRuntimePermission)permission;
        String name = portalRuntimePermission.getName();
        Object subject = portalRuntimePermission.getSubject();
        String property = GetterUtil.getString((String)portalRuntimePermission.getProperty());
        if (name.equals("expandoBridge")) {
            String className = (String)subject;
            if (!this._expandoBridgeClassNames.contains(className)) {
                this.throwSecurityException(_log, "Attempted to get Expando bridge on " + className);
            }
        } else if (name.equals("getBeanProperty")) {
            Class clazz = (Class)subject;
            if (!this.hasGetBeanProperty(clazz, property)) {
                if (Validator.isNotNull((String)property)) {
                    this.throwSecurityException(_log, "Attempted to get bean property " + property + " on " + clazz);
                } else {
                    this.throwSecurityException(_log, "Attempted to get bean property on " + clazz);
                }
            }
        } else if (name.equals("searchEngine")) {
            String searchEngineId = (String)subject;
            if (!this._searchEngineIds.contains(searchEngineId)) {
                this.throwSecurityException(_log, "Attempted to get search engine " + searchEngineId);
            }
        } else if (name.equals("setBeanProperty")) {
            Class clazz = (Class)subject;
            if (!this.hasSetBeanProperty(clazz, property)) {
                if (Validator.isNotNull((String)property)) {
                    this.throwSecurityException(_log, "Attempted to set bean property " + property + " on " + clazz);
                } else {
                    this.throwSecurityException(_log, "Attempted to set bean property on " + clazz);
                }
            }
        } else if (name.equals("threadPoolExecutor") && !this._threadPoolExecutorNames.contains(threadPoolExecutorName = (String)subject)) {
            this.throwSecurityException(_log, "Attempted to modify thread pool executor " + threadPoolExecutorName);
        }
    }

    protected boolean hasGetBeanProperty(Class<?> clazz, String property) {
        Class callerClass10;
        String className = clazz.getName();
        if (this._getBeanPropertyClassNames.contains(className)) {
            return true;
        }
        if (Validator.isNotNull((String)property) && this._getBeanPropertyClassNames.contains(className.concat("#").concat(property))) {
            return true;
        }
        return clazz == PortalExecutorManagerUtil.class && (callerClass10 = Reflection.getCallerClass((int)10)) == BaseAsyncDestination.class;
    }

    protected boolean hasSetBeanProperty(Class<?> clazz, String property) {
        String className = clazz.getName();
        if (this._setBeanPropertyClassNames.contains(className)) {
            return true;
        }
        return Validator.isNotNull((String)property) && this._setBeanPropertyClassNames.contains(className.concat("#").concat(property));
    }

    protected void initExpandoBridgeClassNames() {
        this._expandoBridgeClassNames = this.getPropertySet("security-manager-expando-bridge");
        if (_log.isDebugEnabled()) {
            TreeSet<String> classNames = new TreeSet<String>(this._expandoBridgeClassNames);
            for (String className : classNames) {
                _log.debug((Object)("Allowing Expando bridge on class " + className));
            }
        }
    }

    protected void initGetBeanPropertyClassNames() {
        this._getBeanPropertyClassNames = this.getPropertySet("security-manager-get-bean-property");
        if (_log.isDebugEnabled()) {
            TreeSet<String> classNames = new TreeSet<String>(this._getBeanPropertyClassNames);
            for (String className : classNames) {
                _log.debug((Object)("Allowing get bean property on class " + className));
            }
        }
    }

    protected void initSearchEngineIds() {
        this._searchEngineIds = this.getPropertySet("security-manager-search-engine-ids");
        if (_log.isDebugEnabled()) {
            TreeSet<String> searchEngineIds = new TreeSet<String>(this._searchEngineIds);
            for (String searchEngineId : searchEngineIds) {
                _log.debug((Object)("Allowing search engine " + searchEngineId));
            }
        }
    }

    protected void initSetBeanPropertyClassNames() {
        this._setBeanPropertyClassNames = this.getPropertySet("security-manager-set-bean-property");
        if (_log.isDebugEnabled()) {
            TreeSet<String> classNames = new TreeSet<String>(this._setBeanPropertyClassNames);
            for (String className : classNames) {
                _log.debug((Object)("Allowing set bean property on class " + className));
            }
        }
    }

    protected void initThreadPoolExecutorNames() {
        this._threadPoolExecutorNames = this.getPropertySet("security-manager-thread-pool-executor-names");
        if (_log.isDebugEnabled()) {
            TreeSet<String> threadPoolExecutorNames = new TreeSet<String>(this._threadPoolExecutorNames);
            for (String threadPoolExecutorName : threadPoolExecutorNames) {
                _log.debug((Object)("Allowing thread pool executor " + threadPoolExecutorName));
            }
        }
    }
}

