/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalServicePermission;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.PACLPolicyManager;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalServiceChecker
extends BaseChecker {
    private static final String _PORTAL_SERVLET_CONTEXT_NAME = "portal";
    private static Log _log = LogFactoryUtil.getLog(PortalServiceChecker.class);
    private Map<String, Set<String>> _pluginServices = new HashMap<String, Set<String>>();
    private Set<String> _portalServices = Collections.emptySet();

    @Override
    public void afterPropertiesSet() {
        this.initServices();
    }

    @Override
    public void checkPermission(Permission permission) {
        Class implClass;
        PortalServicePermission portalServicePermission = (PortalServicePermission)permission;
        String name = portalServicePermission.getName();
        Object object = portalServicePermission.getObject();
        if (name.equals("dynamicQuery") && !this.hasDynamicQuery(implClass = (Class)object)) {
            this.throwSecurityException(_log, "Attempted to create a dynamic query for " + implClass);
        }
    }

    public boolean hasService(Object object, Method method, Object[] arguments) {
        String className;
        ClassLoader classLoader;
        PACLPolicy paclPolicy;
        Class<?> clazz = object.getClass();
        if (ProxyUtil.isProxyClass(clazz)) {
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces.length == 0) {
                return false;
            }
            clazz = interfaces[0];
        }
        if ((paclPolicy = PACLPolicyManager.getPACLPolicy(classLoader = PACLClassLoaderUtil.getClassLoader(clazz))) == this.getPACLPolicy()) {
            return true;
        }
        Set<String> services = this.getServices(paclPolicy);
        if (services.contains(className = this.getInterfaceName(clazz.getName()))) {
            return true;
        }
        String methodName = method.getName();
        if (methodName.equals("invokeMethod")) {
            methodName = (String)arguments[0];
        }
        return services.contains(className.concat("#").concat(methodName));
    }

    protected String getInterfaceName(String className) {
        int pos = className.indexOf(".impl.");
        if (pos != -1) {
            className = String.valueOf(className.substring(0, pos + 1)) + className.substring(pos + 6);
        }
        if (className.endsWith("Impl")) {
            className = className.substring(0, className.length() - 4);
        }
        return className;
    }

    protected Set<String> getServices(PACLPolicy paclPolicy) {
        Set<String> services = null;
        services = paclPolicy == null ? this._portalServices : this._pluginServices.get(paclPolicy.getServletContextName());
        return services;
    }

    protected boolean hasDynamicQuery(Class<?> clazz) {
        ClassLoader classLoader = PACLClassLoaderUtil.getClassLoader(clazz);
        PACLPolicy paclPolicy = PACLPolicyManager.getPACLPolicy(classLoader);
        return paclPolicy == this.getPACLPolicy();
    }

    protected void initServices() {
        Properties properties = this.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith("security-manager-services[")) continue;
            int x = key.indexOf("[");
            int y = key.indexOf("]", x);
            String servicesServletContextName = key.substring(x + 1, y);
            Set services = SetUtil.fromArray((Object[])StringUtil.split((String)value));
            if (servicesServletContextName.equals(_PORTAL_SERVLET_CONTEXT_NAME)) {
                this._portalServices = services;
                this.touchServices(this._portalServices);
                continue;
            }
            this._pluginServices.put(servicesServletContextName, services);
        }
    }

    protected void touchService(String service) {
        String className = service;
        if (!className.contains(".service.")) {
            return;
        }
        String methodName = null;
        if (className.contains(".service.persistence.") && (className.endsWith("Persistence") || className.contains("Persistence#"))) {
            methodName = "getPersistence";
        } else if (className.endsWith("Service") || className.contains("Service#")) {
            methodName = "getService";
        } else {
            _log.error((Object)("Invalid service " + service));
            return;
        }
        int pos = className.indexOf("#");
        if (pos != -1) {
            className = className.substring(0, pos);
        }
        if (className.endsWith("Persistence")) {
            className = className.substring(0, className.length() - 11);
        }
        className = String.valueOf(className) + "Util";
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking " + className + "#" + methodName));
        }
        ClassLoader classLoader = this.getCommonClassLoader();
        if (ServerDetector.isGeronimo() || ServerDetector.isJBoss()) {
            classLoader = this.getPortalClassLoader();
        }
        try {
            Class<?> clazz = classLoader.loadClass(className);
            Method method = clazz.getMethod(methodName, new Class[0]);
            method.invoke(clazz, new Object[0]);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    protected void touchServices(Set<String> services) {
        for (String service : services) {
            this.touchService(service);
        }
    }
}

