/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseAsyncDestination;
import com.liferay.portal.kernel.servlet.PortalClassLoaderFilter;
import com.liferay.portal.kernel.servlet.PortalClassLoaderServlet;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.kernel.util.PathUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.security.pacl.PACLClassUtil;
import com.liferay.portal.security.pacl.checker.BaseReflectChecker;
import com.liferay.portal.security.pacl.checker.CheckerUtil;
import java.security.Permission;
import java.util.Set;
import java.util.TreeSet;
import org.apache.xerces.impl.dv.DatatypeException;
import org.apache.xerces.parsers.AbstractDOMParser;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.util.ClassUtils;
import sun.reflect.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeChecker
extends BaseReflectChecker {
    private static final String _CLASS_NAME_API_CLASS_LOADER_SERVICE_IMPL = "com.sun.enterprise.v3.server.APIClassLoaderServiceImpl";
    private static final String _CLASS_NAME_CLASS_DEFINER = "sun.reflect.ClassDefiner$";
    private static final String _CLASS_NAME_DEFAULT_MBEAN_SERVER_INTERCEPTOR = "com.sun.jmx.interceptor.DefaultMBeanServerInterceptor";
    private static final String _CLASS_NAME_ENVIRONMENT_LOCAL = "com.caucho.loader.EnvironmentLocal";
    private static final String _CLASS_NAME_GENERIC_CLASS_LOADER = "weblogic.utils.classloaders.GenericClassLoader";
    private static final String _CLASS_NAME_JDBC_LEAK_PREVENTION = "org.apache.catalina.loader.JdbcLeakPrevention";
    private static final String _CLASS_NAME_MESSAGES = "org.jboss.logging.Messages";
    private static final String _CLASS_NAME_MODULE_IMPL = "org.apache.felix.framework.ModuleImpl";
    private static final String _CLASS_NAME_PROCESS_IMPL = "java.lang.ProcessImpl$";
    private static final String _CLASS_NAME_PROTECTION_CLASS_LOADER = "com.ibm.ws.classloader.ProtectionClassLoader";
    private static final String _CLASS_NAME_SERVICE_CONTROLLER_IMPL = "org.jboss.msc.service.ServiceControllerImpl";
    private static final String _METHOD_NAME_GET_SYSTEM_CLASS_LOADER = "getSystemClassLoader";
    private static Log _log = LogFactoryUtil.getLog(RuntimeChecker.class);
    private Set<String> _classLoaderReferenceIds;

    @Override
    public void afterPropertiesSet() {
        this.initClassLoaderReferenceIds();
    }

    @Override
    public void checkPermission(Permission permission) {
        String name = permission.getName();
        if (name.startsWith("accessClassInPackage")) {
            int pos = name.indexOf(".");
            String pkg = name.substring(pos + 1);
            if (!this.hasAccessClassInPackage(pkg)) {
                this.throwSecurityException(_log, "Attempted to access package " + pkg);
            }
        } else if (name.equals("accessDeclaredMembers")) {
            if (!this.hasReflect(permission.getName(), permission.getActions())) {
                this.throwSecurityException(_log, "Attempted to access declared members");
            }
        } else if (name.equals("createClassLoader")) {
            if (PortalSecurityManagerThreadLocal.isCheckCreateClassLoader() && !this.isJSPCompiler(permission.getName(), permission.getActions()) && !this.hasCreateClassLoader()) {
                this.throwSecurityException(_log, "Attempted to create a class loader");
            }
        } else if (name.startsWith("getClassLoader")) {
            if (PortalSecurityManagerThreadLocal.isCheckGetClassLoader() && !this.isJSPCompiler(permission.getName(), permission.getActions()) && !this.hasGetClassLoader(name)) {
                this.throwSecurityException(_log, "Attempted to get class loader");
            }
        } else if (name.startsWith("getProtectionDomain")) {
            if (!this.hasGetProtectionDomain()) {
                this.throwSecurityException(_log, "Attempted to get protection domain");
            }
        } else if (name.startsWith("getenv")) {
            int pos = name.indexOf(".");
            String envName = name.substring(pos + 1);
            if (!this.hasGetEnv(envName)) {
                this.throwSecurityException(_log, "Attempted to get environment name " + envName);
            }
        } else if (name.equals("readFileDescriptor")) {
            if (PortalSecurityManagerThreadLocal.isCheckReadFileDescriptor() && !this.hasReadFileDescriptor()) {
                this.throwSecurityException(_log, "Attempted to read file descriptor");
            }
        } else if (!name.equals("setContextClassLoader")) {
            if (name.equals("setSecurityManager")) {
                this.throwSecurityException(_log, "Attempted to set another security manager");
            } else if (name.equals("writeFileDescriptor")) {
                if (PortalSecurityManagerThreadLocal.isCheckWriteFileDescriptor() && !this.hasWriteFileDescriptor()) {
                    this.throwSecurityException(_log, "Attempted to write file descriptor");
                }
            } else {
                if (_log.isDebugEnabled()) {
                    Thread.dumpStack();
                }
                this.throwSecurityException(_log, "Attempted to " + permission.getName() + " on " + permission.getActions());
            }
        }
    }

    protected boolean hasAccessClassInPackage(String pkg) {
        pkg.startsWith("sun.reflect");
        return true;
    }

    protected boolean hasCreateClassLoader() {
        if (JavaDetector.isIBM()) {
            Class callerClass9 = Reflection.getCallerClass((int)9);
            String callerClassName9 = callerClass9.getName();
            if (callerClassName9.startsWith(_CLASS_NAME_CLASS_DEFINER) && CheckerUtil.isAccessControllerDoPrivileged(10)) {
                this.logCreateClassLoader(callerClass9, 9);
                return true;
            }
            Class callerClass10 = Reflection.getCallerClass((int)10);
            String callerClassName10 = callerClass10.getName();
            if (callerClassName10.startsWith(_CLASS_NAME_CLASS_DEFINER) && CheckerUtil.isAccessControllerDoPrivileged(11)) {
                this.logCreateClassLoader(callerClass10, 10);
                return true;
            }
        } else if (JavaDetector.isJDK7()) {
            Class callerClass11 = Reflection.getCallerClass((int)11);
            String callerClassName11 = callerClass11.getName();
            if (callerClassName11.startsWith(_CLASS_NAME_CLASS_DEFINER) && CheckerUtil.isAccessControllerDoPrivileged(12)) {
                this.logCreateClassLoader(callerClass11, 11);
                return true;
            }
        } else {
            Class callerClass10 = Reflection.getCallerClass((int)10);
            String callerClassName10 = callerClass10.getName();
            if (callerClassName10.startsWith(_CLASS_NAME_CLASS_DEFINER) && CheckerUtil.isAccessControllerDoPrivileged(11)) {
                this.logCreateClassLoader(callerClass10, 10);
                return true;
            }
        }
        return false;
    }

    protected boolean hasGetClassLoader(String name) {
        int pos = name.indexOf(".");
        if (pos != -1) {
            Class callerClass7;
            String referenceId = name.substring(pos + 1);
            if (this._classLoaderReferenceIds.contains(referenceId)) {
                return true;
            }
            return referenceId.equals("portal") && ((callerClass7 = Reflection.getCallerClass((int)7)) == BaseAsyncDestination.class || callerClass7 == PortalClassLoaderFilter.class || callerClass7 == PortalClassLoaderServlet.class);
        }
        Class callerClass6 = Reflection.getCallerClass((int)6);
        Class callerClass7 = Reflection.getCallerClass((int)7);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(String.valueOf(callerClass7.getName()) + " is attempting to get the class loader via " + callerClass6.getName()));
        }
        if (callerClass7 == CachedIntrospectionResults.class || callerClass7 == ClassUtils.class || callerClass7.getEnclosingClass() == LocalVariableTableParameterNameDiscoverer.class) {
            this.logGetClassLoader(callerClass7, 7);
            return true;
        }
        if (callerClass6 == Class.class) {
            if (this.isJBossMessages(callerClass7) || this.isJBossServiceControllerImpl(callerClass7) || this.isJOnASModuleImpl(callerClass7) || this.isTomcatJdbcLeakPrevention(callerClass7)) {
                this.logGetClassLoader(callerClass7, 7);
                return true;
            }
            if (this.isWebSphereProtectionClassLoader(callerClass7.getEnclosingClass()) && CheckerUtil.isAccessControllerDoPrivileged(8)) {
                this.logGetClassLoader(callerClass7, 7);
                return true;
            }
        } else if (callerClass6 == ClassLoader.class) {
            Class callerClass8 = Reflection.getCallerClass((int)8);
            if (this.isGlassfishAPIClassLoaderServiceImpl(callerClass8.getEnclosingClass()) && CheckerUtil.isAccessControllerDoPrivileged(9)) {
                this.logGetClassLoader(callerClass8, 8);
                return true;
            }
            if (this.isResinEnvironmentLocal(callerClass7)) {
                this.logGetClassLoader(callerClass7, 7);
                return true;
            }
            if (this.isWebLogicGenericClassLoader(callerClass7.getEnclosingClass()) && CheckerUtil.isAccessControllerDoPrivileged(8)) {
                this.logGetClassLoader(callerClass7, 7);
                return true;
            }
            if (this.isXercesSecuritySupport(callerClass7) && CheckerUtil.isAccessControllerDoPrivileged(8)) {
                this.logGetClassLoader(callerClass8, 8);
                return true;
            }
            Thread currentThread = Thread.currentThread();
            StackTraceElement[] stackTraceElements = currentThread.getStackTrace();
            StackTraceElement stackTraceElement = null;
            stackTraceElement = JavaDetector.isIBM() ? stackTraceElements[7] : stackTraceElements[6];
            String methodName = stackTraceElement.getMethodName();
            if (methodName.equals(_METHOD_NAME_GET_SYSTEM_CLASS_LOADER)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Allowing " + callerClass7.getName() + " to get the system class loader"));
                }
                return true;
            }
        } else if (callerClass6 == Thread.class) {
            ClassLoader portalClassLoader;
            boolean allow = false;
            ClassLoader contextClassLoader = PACLClassLoaderUtil.getContextClassLoader();
            if (contextClassLoader == (portalClassLoader = this.getPortalClassLoader())) {
                if (PACLClassLoaderUtil.getClassLoader(callerClass7) != this.getClassLoader()) {
                    allow = true;
                }
            } else {
                allow = true;
            }
            if (allow) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Allowing " + callerClass7.getName() + " to access the context class loader"));
                }
                return true;
            }
        }
        return false;
    }

    protected boolean hasGetEnv(String name) {
        Class callerClass7 = Reflection.getCallerClass((int)7);
        if (callerClass7 == AbstractApplicationContext.class) {
            this.logGetEnv(callerClass7, 7, name);
            return true;
        }
        return ServerDetector.isWebSphere() && name.equals("USER_INSTALL_ROOT");
    }

    protected boolean hasGetProtectionDomain() {
        Class callerClass8 = Reflection.getCallerClass((int)8);
        if (this.isDefaultMBeanServerInterceptor(callerClass8.getEnclosingClass()) && CheckerUtil.isAccessControllerDoPrivileged(9)) {
            this.logGetProtectionDomain(callerClass8, 8);
            return true;
        }
        return false;
    }

    protected boolean hasReadFileDescriptor() {
        if (JavaDetector.isJDK7()) {
            Class callerClass9 = Reflection.getCallerClass((int)9);
            String callerClassName9 = callerClass9.getName();
            if (callerClassName9.startsWith(_CLASS_NAME_PROCESS_IMPL) && CheckerUtil.isAccessControllerDoPrivileged(10)) {
                this.logWriteFileDescriptor(callerClass9, 9);
                return true;
            }
        } else {
            Class callerClass8 = Reflection.getCallerClass((int)8);
            String callerClassName8 = callerClass8.getName();
            if (callerClassName8.startsWith(_CLASS_NAME_PROCESS_IMPL) && CheckerUtil.isAccessControllerDoPrivileged(9)) {
                this.logWriteFileDescriptor(callerClass8, 8);
                return true;
            }
        }
        return false;
    }

    protected boolean hasWriteFileDescriptor() {
        if (JavaDetector.isJDK7()) {
            Class callerClass9 = Reflection.getCallerClass((int)9);
            String callerClassName9 = callerClass9.getName();
            if (callerClassName9.startsWith(_CLASS_NAME_PROCESS_IMPL) && CheckerUtil.isAccessControllerDoPrivileged(10)) {
                this.logWriteFileDescriptor(callerClass9, 9);
                return true;
            }
        } else {
            Class callerClass8 = Reflection.getCallerClass((int)8);
            String callerClassName8 = callerClass8.getName();
            if (callerClassName8.startsWith(_CLASS_NAME_PROCESS_IMPL) && CheckerUtil.isAccessControllerDoPrivileged(9)) {
                this.logWriteFileDescriptor(callerClass8, 8);
                return true;
            }
        }
        return false;
    }

    protected void initClassLoaderReferenceIds() {
        this._classLoaderReferenceIds = this.getPropertySet("security-manager-class-loader-reference-ids");
        if (_log.isDebugEnabled()) {
            TreeSet<String> referenceIds = new TreeSet<String>(this._classLoaderReferenceIds);
            for (String referenceId : referenceIds) {
                _log.debug((Object)("Allowing access to class loader for reference " + referenceId));
            }
        }
    }

    protected boolean isDefaultMBeanServerInterceptor(Class<?> clazz) {
        String className = clazz.getName();
        if (!className.equals(_CLASS_NAME_DEFAULT_MBEAN_SERVER_INTERCEPTOR)) {
            return false;
        }
        String classLocation = PACLClassUtil.getClassLocation(clazz);
        return classLocation.length() <= 0;
    }

    protected boolean isGlassfishAPIClassLoaderServiceImpl(Class<?> clazz) {
        if (!ServerDetector.isGlassfish()) {
            return false;
        }
        if (clazz == null) {
            return false;
        }
        if ((clazz = clazz.getEnclosingClass()) == null) {
            return false;
        }
        String className = clazz.getName();
        if (!className.equals(_CLASS_NAME_API_CLASS_LOADER_SERVICE_IMPL)) {
            return false;
        }
        String classLocation = PACLClassUtil.getClassLocation(clazz);
        return classLocation.startsWith("bundle://");
    }

    protected boolean isJBossMessages(Class<?> clazz) {
        if (!ServerDetector.isJBoss()) {
            return false;
        }
        String className = clazz.getName();
        if (!className.equals(_CLASS_NAME_MESSAGES)) {
            return false;
        }
        String classLocation = PACLClassUtil.getClassLocation(clazz);
        return classLocation.contains("/modules/org/jboss/logging/main/jboss-logging-");
    }

    protected boolean isJBossServiceControllerImpl(Class<?> clazz) {
        if (!ServerDetector.isJBoss()) {
            return false;
        }
        String className = clazz.getName();
        if (!className.equals(_CLASS_NAME_SERVICE_CONTROLLER_IMPL)) {
            return false;
        }
        String classLocation = PACLClassUtil.getClassLocation(clazz);
        return classLocation.contains("/modules/org/jboss/msc/main/jboss-msc-");
    }

    protected boolean isJOnASModuleImpl(Class<?> clazz) {
        if (!ServerDetector.isJOnAS()) {
            return false;
        }
        String className = clazz.getName();
        if (!className.equals(_CLASS_NAME_MODULE_IMPL)) {
            return false;
        }
        String classLocation = PACLClassUtil.getClassLocation(clazz);
        return classLocation.contains("/lib/bootstrap/felix-launcher.jar!/");
    }

    protected boolean isResinEnvironmentLocal(Class<?> clazz) {
        if (!ServerDetector.isResin()) {
            return false;
        }
        String className = clazz.getName();
        if (!className.equals(_CLASS_NAME_ENVIRONMENT_LOCAL)) {
            return false;
        }
        String actualClassLocation = PACLClassUtil.getClassLocation(clazz);
        String expectedClassLocation = PathUtil.toUnixPath((String)(String.valueOf(System.getProperty("resin.home")) + "/lib/resin.jar!/"));
        return actualClassLocation.contains(expectedClassLocation);
    }

    protected boolean isTomcatJdbcLeakPrevention(Class<?> clazz) {
        if (!ServerDetector.isTomcat()) {
            return false;
        }
        String className = clazz.getName();
        if (!className.equals(_CLASS_NAME_JDBC_LEAK_PREVENTION)) {
            return false;
        }
        String actualClassLocation = PACLClassUtil.getClassLocation(clazz);
        String expectedClassLocation = PathUtil.toUnixPath((String)(String.valueOf(System.getProperty("catalina.base")) + "/lib/catalina.jar!/"));
        expectedClassLocation = String.valueOf(expectedClassLocation) + StringUtil.replace((String)className, (String)".", (String)"/");
        expectedClassLocation = String.valueOf(expectedClassLocation) + ".class";
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Actual class location " + actualClassLocation));
            _log.debug((Object)("Expected class location " + expectedClassLocation));
        }
        return actualClassLocation.endsWith(expectedClassLocation);
    }

    protected boolean isWebLogicGenericClassLoader(Class<?> clazz) {
        if (!ServerDetector.isWebLogic()) {
            return false;
        }
        if (clazz == null) {
            return false;
        }
        String className = clazz.getName();
        if (!className.equals(_CLASS_NAME_GENERIC_CLASS_LOADER)) {
            return false;
        }
        String classLocation = PACLClassUtil.getClassLocation(clazz);
        return classLocation.contains("/modules/com.bea.core.utils.classloaders_") || classLocation.contains("/patch_jars/BUG");
    }

    protected boolean isWebSphereProtectionClassLoader(Class<?> clazz) {
        if (!ServerDetector.isWebSphere()) {
            return false;
        }
        if (clazz == null) {
            return false;
        }
        String className = clazz.getName();
        if (!className.equals(_CLASS_NAME_PROTECTION_CLASS_LOADER)) {
            return false;
        }
        String classLocation = PACLClassUtil.getClassLocation(clazz);
        return classLocation.startsWith("bundleresource://");
    }

    protected boolean isXercesSecuritySupport(Class<?> clazz) {
        String className = clazz.getName();
        return className.contains(".SecuritySupport$") && (clazz.getPackage() == AbstractDOMParser.class.getPackage() || clazz.getPackage() == DatatypeException.class.getPackage());
    }

    protected void logCreateClassLoader(Class<?> callerClass, int frame) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Allowing frame " + frame + " with caller " + callerClass + " to create a class loader"));
        }
    }

    protected void logGetClassLoader(Class<?> callerClass, int frame) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Allowing frame " + frame + " with caller " + callerClass + " to get the class loader"));
        }
    }

    protected void logGetEnv(Class<?> callerClass, int frame, String name) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Allowing frame " + frame + " with caller " + callerClass + " to get environment " + name));
        }
    }

    protected void logGetProtectionDomain(Class<?> callerClass, int frame) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Allowing frame " + frame + " with caller " + callerClass + " to get the protection domain"));
        }
    }

    protected void logReadFileDescriptor(Class<?> callerClass, int frame) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Allowing frame " + frame + " with caller " + callerClass + " to read a file descriptor"));
        }
    }

    protected void logWriteFileDescriptor(Class<?> callerClass, int frame) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Allowing frame " + frame + " with caller " + callerClass + " to write a file descriptor"));
        }
    }
}

