/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.io.Reader;
import java.io.StringReader;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.parser.JSqlParser;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.replace.Replace;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.truncate.Truncate;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.test.tablesfinder.TablesNamesFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLChecker
extends BaseChecker {
    private static Log _log = LogFactoryUtil.getLog(SQLChecker.class);
    private Set<String> _allTableNames;
    private Set<String> _createTableNames;
    private Set<String> _deleteTableNames;
    private Set<String> _dropTableNames;
    private Set<String> _insertTableNames;
    private JSqlParser _jSqlParser = new CCJSqlParserManager();
    private Set<String> _replaceTableNames;
    private Set<String> _selectTableNames;
    private Set<String> _truncateTableNames;
    private Set<String> _updateTableNames;

    @Override
    public void afterPropertiesSet() {
        this.initTableNames();
    }

    @Override
    public void checkPermission(Permission permission) {
        throw new UnsupportedOperationException();
    }

    public boolean hasSQL(String sql) {
        Statement statement = null;
        try {
            statement = this._jSqlParser.parse((Reader)new StringReader(sql));
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to parse SQL " + sql));
            return false;
        }
        if (statement instanceof CreateTable) {
            CreateTable createTable = (CreateTable)statement;
            return this.hasSQL(createTable);
        }
        if (statement instanceof Select) {
            Select select = (Select)statement;
            return this.hasSQL(select);
        }
        if (statement instanceof Delete) {
            Delete delete = (Delete)statement;
            return this.hasSQL(delete);
        }
        if (statement instanceof Drop) {
            Drop drop = (Drop)statement;
            return this.hasSQL(drop);
        }
        if (statement instanceof Insert) {
            Insert insert = (Insert)statement;
            return this.hasSQL(insert);
        }
        if (statement instanceof Replace) {
            Replace replace = (Replace)statement;
            return this.hasSQL(replace);
        }
        if (statement instanceof Select) {
            Select select = (Select)statement;
            return this.hasSQL(select);
        }
        if (statement instanceof Truncate) {
            Truncate truncate = (Truncate)statement;
            return this.hasSQL(truncate);
        }
        if (statement instanceof Update) {
            Update update = (Update)statement;
            return this.hasSQL(update);
        }
        return false;
    }

    protected boolean hasSQL(CreateTable createTable) {
        return this.isAllowedTable(createTable.getTable(), this._createTableNames);
    }

    protected boolean hasSQL(Delete delete) {
        TableNamesFinder tableNamesFinder = new TableNamesFinder();
        List<String> tableNames = tableNamesFinder.getTableNames(delete);
        return this.isAllowedTables(tableNames, this._deleteTableNames);
    }

    protected boolean hasSQL(Drop drop) {
        return this.isAllowedTable(drop.getName(), this._dropTableNames);
    }

    protected boolean hasSQL(Insert insert) {
        TableNamesFinder tableNamesFinder = new TableNamesFinder();
        List<String> tableNames = tableNamesFinder.getTableNames(insert);
        return this.isAllowedTables(tableNames, this._insertTableNames);
    }

    protected boolean hasSQL(Replace replace) {
        TableNamesFinder tableNamesFinder = new TableNamesFinder();
        List<String> tableNames = tableNamesFinder.getTableNames(replace);
        return this.isAllowedTables(tableNames, this._replaceTableNames);
    }

    protected boolean hasSQL(Select select) {
        TableNamesFinder tableNamesFinder = new TableNamesFinder();
        List<String> tableNames = tableNamesFinder.getTableNames(select);
        return this.isAllowedTables(tableNames, this._selectTableNames);
    }

    protected boolean hasSQL(Truncate truncate) {
        return this.isAllowedTable(truncate.getTable(), this._truncateTableNames);
    }

    protected boolean hasSQL(Update update) {
        TableNamesFinder tableNamesFinder = new TableNamesFinder();
        List<String> tableNames = tableNamesFinder.getTableNames(update);
        return this.isAllowedTables(tableNames, this._updateTableNames);
    }

    protected void initTableNames() {
        this._allTableNames = this.getPropertySet("security-manager-sql-tables-all");
        this._createTableNames = this.getPropertySet("security-manager-sql-tables-create");
        this._deleteTableNames = this.getPropertySet("security-manager-sql-tables-delete");
        this._dropTableNames = this.getPropertySet("security-manager-sql-tables-drop");
        this._insertTableNames = this.getPropertySet("security-manager-sql-tables-insert");
        this._replaceTableNames = this.getPropertySet("security-manager-sql-tables-replace");
        this._selectTableNames = this.getPropertySet("security-manager-sql-tables-select");
        this._truncateTableNames = this.getPropertySet("security-manager-sql-tables-truncate");
        this._updateTableNames = this.getPropertySet("security-manager-sql-tables-update");
    }

    protected boolean isAllowedTable(String tableName, Set<String> allowedTableNames) {
        return this._allTableNames.contains(tableName) || allowedTableNames.contains(tableName);
    }

    protected boolean isAllowedTable(Table table, Set<String> allowedTableNames) {
        String tableName = table.getName();
        return this.isAllowedTable(tableName, allowedTableNames);
    }

    protected boolean isAllowedTables(List<String> tableNames, Set<String> allowedTableNames) {
        for (String tableName : tableNames) {
            if (this.isAllowedTable(tableName, allowedTableNames)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TableNamesFinder
    extends TablesNamesFinder {
        public TableNamesFinder() {
            this.tables = new ArrayList();
        }

        public List<String> getTableNames(Delete delete) {
            Table table = delete.getTable();
            this.tables.add(table.getName());
            Expression where = delete.getWhere();
            where.accept((ExpressionVisitor)this);
            return this.tables;
        }

        public List<String> getTableNames(Insert insert) {
            Table table = insert.getTable();
            this.tables.add(table.getName());
            ItemsList itemsList = insert.getItemsList();
            itemsList.accept((ItemsListVisitor)this);
            return this.tables;
        }

        public List<String> getTableNames(Replace replace) {
            Table table = replace.getTable();
            this.tables.add(table.getName());
            ItemsList itemsList = replace.getItemsList();
            itemsList.accept((ItemsListVisitor)this);
            return this.tables;
        }

        public List<String> getTableNames(Select select) {
            SelectBody selectBody = select.getSelectBody();
            selectBody.accept((SelectVisitor)this);
            return this.tables;
        }

        public List<String> getTableNames(Update update) {
            Table table = update.getTable();
            this.tables.add(table.getName());
            Expression where = update.getWhere();
            where.accept((ExpressionVisitor)this);
            return this.tables;
        }
    }
}

