/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.security.pacl.PACLClassUtil;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import com.liferay.portal.security.pacl.checker.CheckerUtil;
import java.security.Permission;
import sun.reflect.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityChecker
extends BaseChecker {
    private static final String _CLASS_NAME_DISPATCH_LISTENER = "org.apache.geronimo.tomcat.listener.DispatchListener";
    private static final String _CLASS_NAME_J2EE_INSTANCE_LISTENER = "com.sun.web.server.J2EEInstanceListener";
    private static final String _CLASS_NAME_POLICY_CONTEXT_HANDLER_IMPL = "com.sun.enterprise.security.authorize.PolicyContextHandlerImpl";
    private static final String _CLASS_NAME_WAS_JSP_EXTENSION_SERVLET_WRAPPER = "com.ibm.ws.jsp.webcontainerext.ws.WASJSPExtensionServletWrapper";
    private static Log _log = LogFactoryUtil.getLog(SecurityChecker.class);

    @Override
    public void afterPropertiesSet() {
    }

    @Override
    public void checkPermission(Permission permission) {
        String name = permission.getName();
        if (name.equals("getPolicy")) {
            if (!this.hasGetPolicy()) {
                this.throwSecurityException(_log, "Attempted to get the policy");
            }
        } else if (name.equals("setPolicy")) {
            if (!this.hasSetPolicy()) {
                this.throwSecurityException(_log, "Attempted to set the policy");
            }
        } else {
            if (_log.isDebugEnabled()) {
                Thread.dumpStack();
            }
            this.throwSecurityException(_log, "Attempted to " + permission.getName() + " on " + permission.getActions());
        }
    }

    protected boolean hasGetPolicy() {
        Class callerClass8 = Reflection.getCallerClass((int)8);
        if (this.isGlassfishJ2EEInstanceListener(callerClass8.getEnclosingClass()) && CheckerUtil.isAccessControllerDoPrivileged(9)) {
            this.logGetPolicy(callerClass8, 8);
            return true;
        }
        if (this.isWebSphereWASJSPExtensionServletWrapper(callerClass8)) {
            this.logGetPolicy(callerClass8, 8);
            return true;
        }
        return false;
    }

    protected boolean hasSetPolicy() {
        Class callerClass6 = Reflection.getCallerClass((int)6);
        if (this.isGlassfishPolicyContextHandlerImpl(callerClass6)) {
            this.logSetPolicy(callerClass6, 6);
            return true;
        }
        Class callerClass7 = Reflection.getCallerClass((int)7);
        if (this.isGeronimoDispatchListener(callerClass7)) {
            this.logSetPolicy(callerClass7, 7);
            return true;
        }
        return false;
    }

    protected boolean isGeronimoDispatchListener(Class<?> clazz) {
        if (!ServerDetector.isGeronimo()) {
            return false;
        }
        if (clazz == null) {
            return false;
        }
        String className = clazz.getName();
        if (!className.equals(_CLASS_NAME_DISPATCH_LISTENER)) {
            return false;
        }
        String classLocation = PACLClassUtil.getClassLocation(clazz);
        return classLocation.contains("/repository/org/apache/geronimo/modules/geronimo-tomcat6/");
    }

    protected boolean isGlassfishJ2EEInstanceListener(Class<?> clazz) {
        if (!ServerDetector.isGlassfish()) {
            return false;
        }
        if (clazz == null) {
            return false;
        }
        String className = clazz.getName();
        if (!className.equals(_CLASS_NAME_J2EE_INSTANCE_LISTENER)) {
            return false;
        }
        String classLocation = PACLClassUtil.getClassLocation(clazz);
        return classLocation.startsWith("bundle://");
    }

    protected boolean isGlassfishPolicyContextHandlerImpl(Class<?> clazz) {
        if (!ServerDetector.isGlassfish()) {
            return false;
        }
        if (clazz == null) {
            return false;
        }
        String className = clazz.getName();
        if (!className.equals(_CLASS_NAME_POLICY_CONTEXT_HANDLER_IMPL)) {
            return false;
        }
        String classLocation = PACLClassUtil.getClassLocation(clazz);
        return classLocation.startsWith("bundle://");
    }

    protected boolean isWebSphereWASJSPExtensionServletWrapper(Class<?> clazz) {
        if (!ServerDetector.isWebSphere()) {
            return false;
        }
        String className = clazz.getName();
        if (!className.equals(_CLASS_NAME_WAS_JSP_EXTENSION_SERVLET_WRAPPER)) {
            return false;
        }
        String classLocation = PACLClassUtil.getClassLocation(clazz);
        return classLocation.startsWith("bundleresource://");
    }

    protected void logGetPolicy(Class<?> callerClass, int frame) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Allowing frame " + frame + " with caller " + callerClass + " to get the policy"));
        }
    }

    protected void logSetPolicy(Class<?> callerClass, int frame) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Allowing frame " + frame + " with caller " + callerClass + " to set the policy"));
        }
    }
}

