/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Permission;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SocketChecker
extends BaseChecker {
    private static Log _log = LogFactoryUtil.getLog(SocketChecker.class);
    private Map<String, Set<Integer>> _acceptHostsAndPorts = new HashMap<String, Set<Integer>>();
    private Map<String, Set<Integer>> _connectHostsAndPorts = new HashMap<String, Set<Integer>>();
    private Set<Integer> _listenPorts = new HashSet<Integer>();

    public void afterPropertiesSet() {
        this.initAcceptHostsAndPorts();
        this.initConnectHostsAndPorts();
        this.initListenPorts();
    }

    public void checkPermission(Permission permission) {
        int port;
        String actions = permission.getActions();
        String name = permission.getName();
        int pos = name.indexOf(":");
        String host = "localhost";
        if (pos != -1) {
            host = name.substring(0, pos);
        }
        if ((port = GetterUtil.getInteger((String)name.substring(pos + 1))) == -1) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Always allow resolving of host " + host));
            }
            return;
        }
        if (actions.contains("accept")) {
            if (!this.hasAccept(host, port)) {
                this.throwSecurityException(_log, "Attempted to accept from host " + host + " on port " + port);
            }
        } else if (actions.contains("connect")) {
            if (!this.hasConnect(host, port)) {
                this.throwSecurityException(_log, "Attempted to connect to host " + host + " on port " + port);
            }
        } else if (actions.contains("listen") && !this.hasListen(port)) {
            this.throwSecurityException(_log, "Attempted to listen on port " + port);
        }
    }

    protected boolean hasAccept(String host, int port) {
        Set<Integer> ports = this._acceptHostsAndPorts.get(host);
        if (ports == null) {
            return false;
        }
        return ports.contains(port);
    }

    protected boolean hasConnect(String host, int port) {
        Set<Integer> ports = this._connectHostsAndPorts.get(host);
        if (ports == null) {
            return false;
        }
        return ports.contains(port);
    }

    protected boolean hasListen(int port) {
        return this._listenPorts.contains(port);
    }

    protected void initAcceptHostsAndPorts() {
        String[] networkParts;
        String[] stringArray = networkParts = this.getPropertyArray("security-manager-sockets-accept");
        int n = networkParts.length;
        int n2 = 0;
        while (n2 < n) {
            String networkPart = stringArray[n2];
            this.initHostsAndPorts(networkPart, true);
            ++n2;
        }
    }

    protected void initConnectHostsAndPorts() {
        String[] networkParts;
        String[] stringArray = networkParts = this.getPropertyArray("security-manager-sockets-connect");
        int n = networkParts.length;
        int n2 = 0;
        while (n2 < n) {
            String networkPart = stringArray[n2];
            this.initHostsAndPorts(networkPart, false);
            ++n2;
        }
    }

    protected void initHostsAndPorts(String networkPart, boolean accept) {
        int pos;
        String action = "accept";
        if (!accept) {
            action = "connect";
        }
        if ((pos = networkPart.indexOf(":")) == -1) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to determine socket " + action + " host and port from " + networkPart + " because it is missing a colon delimeter"));
            }
            return;
        }
        String host = networkPart.substring(0, pos);
        if (!Validator.isDomain((String)host)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Socket " + action + " host " + host + " is not a valid domain"));
            }
            return;
        }
        String portString = networkPart.substring(pos + 1);
        int port = GetterUtil.getInteger((String)portString);
        if (port <= 0) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Socket " + action + " port " + portString + " is less than or equal to 0"));
            }
            return;
        }
        InetAddress[] inetAddresses = null;
        try {
            inetAddresses = InetAddress.getAllByName(host);
        }
        catch (UnknownHostException unknownHostException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to resolve host " + host));
            }
            return;
        }
        Map<String, Set<Integer>> hostsAndPorts = this._acceptHostsAndPorts;
        if (!accept) {
            hostsAndPorts = this._connectHostsAndPorts;
        }
        InetAddress[] inetAddressArray = inetAddresses;
        int n = inetAddresses.length;
        int n2 = 0;
        while (n2 < n) {
            InetAddress inetAddress = inetAddressArray[n2];
            Set<Integer> ports = hostsAndPorts.get(inetAddress.getHostAddress());
            if (ports == null) {
                ports = new HashSet<Integer>();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Allowing socket " + action + " host " + host + " with IP " + inetAddress.getHostAddress() + " on port " + port));
                }
                hostsAndPorts.put(inetAddress.getHostAddress(), ports);
            }
            ports.add(port);
            ++n2;
        }
    }

    protected void initListenPorts() {
        String[] listenParts;
        String[] stringArray = listenParts = this.getPropertyArray("security-manager-sockets-listen");
        int n = listenParts.length;
        int n2 = 0;
        while (n2 < n) {
            String listenPart = stringArray[n2];
            this.initListenPorts(listenPart);
            ++n2;
        }
    }

    protected void initListenPorts(String listenPart) {
        int pos = listenPart.indexOf("-");
        if (pos == -1) {
            if (!Validator.isNumber((String)listenPart)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Socket listen port " + listenPart + " is not a number"));
                }
                return;
            }
            int port = GetterUtil.getInteger((String)listenPart);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Allowing socket listen port " + port));
            }
            this._listenPorts.add(port);
        } else {
            int port2;
            String portString1 = listenPart.substring(0, pos);
            String portString2 = listenPart.substring(pos + 1);
            if (!Validator.isNumber((String)portString1)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Socket listen port " + portString1 + " is not a number"));
                }
                return;
            }
            if (!Validator.isNumber((String)portString2)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Socket listen port " + portString2 + " is not a number"));
                }
                return;
            }
            int port1 = GetterUtil.getInteger((String)portString1);
            if (port1 >= (port2 = GetterUtil.getInteger((String)portString2))) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Socket listen port range " + listenPart + " is invalid"));
                }
                return;
            }
            int i2 = port1;
            while (i2 <= port2) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Allowing socket listen port " + i2));
                }
                this._listenPorts.add(i2);
                ++i2;
            }
        }
    }
}

