/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.PwdEncryptorException;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import jodd.util.BCrypt;
import org.vps.crypt.Crypt;

public class PwdEncryptor {
    public static final String PASSWORDS_ENCRYPTION_ALGORITHM = GetterUtil.getString((String)PropsUtil.get("passwords.encryption.algorithm")).toUpperCase();
    public static final char[] SALT_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789./".toCharArray();
    public static final String TYPE_BCRYPT = "BCRYPT";
    public static final String TYPE_CRYPT = "CRYPT";
    public static final String TYPE_MD2 = "MD2";
    public static final String TYPE_MD5 = "MD5";
    public static final String TYPE_NONE = "NONE";
    public static final String TYPE_SHA = "SHA";
    public static final String TYPE_SHA_256 = "SHA-256";
    public static final String TYPE_SHA_384 = "SHA-384";
    public static final String TYPE_SSHA = "SSHA";
    public static final String TYPE_UFC_CRYPT = "UFC-CRYPT";

    public static String encrypt(String clearTextPassword) throws PwdEncryptorException {
        return PwdEncryptor.encrypt(PASSWORDS_ENCRYPTION_ALGORITHM, clearTextPassword, null);
    }

    public static String encrypt(String clearTextPassword, String currentEncryptedPassword) throws PwdEncryptorException {
        return PwdEncryptor.encrypt(PASSWORDS_ENCRYPTION_ALGORITHM, clearTextPassword, currentEncryptedPassword);
    }

    public static String encrypt(String algorithm, String clearTextPassword, String currentEncryptedPassword) throws PwdEncryptorException {
        if (algorithm.equals(TYPE_BCRYPT)) {
            byte[] saltBytes = PwdEncryptor._getSaltFromBCrypt(currentEncryptedPassword);
            return PwdEncryptor.encodePassword(algorithm, clearTextPassword, saltBytes);
        }
        if (algorithm.equals(TYPE_CRYPT) || algorithm.equals(TYPE_UFC_CRYPT)) {
            byte[] saltBytes = PwdEncryptor._getSaltFromCrypt(currentEncryptedPassword);
            return PwdEncryptor.encodePassword(algorithm, clearTextPassword, saltBytes);
        }
        if (algorithm.equals(TYPE_NONE)) {
            return clearTextPassword;
        }
        if (algorithm.equals(TYPE_SSHA)) {
            byte[] saltBytes = PwdEncryptor._getSaltFromSSHA(currentEncryptedPassword);
            return PwdEncryptor.encodePassword(algorithm, clearTextPassword, saltBytes);
        }
        return PwdEncryptor.encodePassword(algorithm, clearTextPassword, null);
    }

    protected static String encodePassword(String algorithm, String clearTextPassword, byte[] saltBytes) throws PwdEncryptorException {
        try {
            if (algorithm.equals(TYPE_BCRYPT)) {
                String salt = new String(saltBytes);
                return BCrypt.hashpw((String)clearTextPassword, (String)salt);
            }
            if (algorithm.equals(TYPE_CRYPT) || algorithm.equals(TYPE_UFC_CRYPT)) {
                return Crypt.crypt((byte[])saltBytes, (byte[])clearTextPassword.getBytes("UTF-8"));
            }
            if (algorithm.equals(TYPE_SSHA)) {
                byte[] clearTextPasswordBytes = clearTextPassword.getBytes("UTF-8");
                byte[] pwdPlusSalt = new byte[clearTextPasswordBytes.length + saltBytes.length];
                System.arraycopy(clearTextPasswordBytes, 0, pwdPlusSalt, 0, clearTextPasswordBytes.length);
                System.arraycopy(saltBytes, 0, pwdPlusSalt, clearTextPasswordBytes.length, saltBytes.length);
                MessageDigest sha1Digest = MessageDigest.getInstance("SHA-1");
                byte[] pwdPlusSaltHash = sha1Digest.digest(pwdPlusSalt);
                byte[] digestPlusSalt = new byte[pwdPlusSaltHash.length + saltBytes.length];
                System.arraycopy(pwdPlusSaltHash, 0, digestPlusSalt, 0, pwdPlusSaltHash.length);
                System.arraycopy(saltBytes, 0, digestPlusSalt, pwdPlusSaltHash.length, saltBytes.length);
                return Base64.encode((byte[])digestPlusSalt);
            }
            return DigesterUtil.digest((String)algorithm, (String[])new String[]{clearTextPassword});
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new PwdEncryptorException(nsae.getMessage());
        }
        catch (UnsupportedEncodingException uee) {
            throw new PwdEncryptorException(uee.getMessage());
        }
    }

    private static byte[] _getSaltFromBCrypt(String bcryptString) throws PwdEncryptorException {
        byte[] saltBytes = null;
        try {
            if (Validator.isNull((String)bcryptString)) {
                String salt = BCrypt.gensalt();
                saltBytes = salt.getBytes("UTF-8");
            } else {
                String salt = bcryptString.substring(0, 29);
                saltBytes = salt.getBytes("UTF-8");
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new PwdEncryptorException("Unable to extract salt from encrypted password: " + uee.getMessage());
        }
        return saltBytes;
    }

    private static byte[] _getSaltFromCrypt(String cryptString) throws PwdEncryptorException {
        byte[] saltBytes = null;
        try {
            if (Validator.isNull((String)cryptString)) {
                Random random = new Random();
                int numSaltChars = SALT_CHARS.length;
                StringBuilder sb = new StringBuilder();
                int x = random.nextInt(Integer.MAX_VALUE) % numSaltChars;
                int y = random.nextInt(Integer.MAX_VALUE) % numSaltChars;
                sb.append(SALT_CHARS[x]);
                sb.append(SALT_CHARS[y]);
                String salt = sb.toString();
                saltBytes = salt.getBytes("UTF-8");
            } else {
                String salt = cryptString.substring(0, 2);
                saltBytes = salt.getBytes("UTF-8");
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new PwdEncryptorException("Unable to extract salt from encrypted password: " + uee.getMessage());
        }
        return saltBytes;
    }

    private static byte[] _getSaltFromSSHA(String sshaString) throws PwdEncryptorException {
        byte[] saltBytes = new byte[8];
        if (Validator.isNull((String)sshaString)) {
            SecureRandom random = new SecureRandom();
            ((Random)random).nextBytes(saltBytes);
        } else {
            try {
                byte[] digestPlusSalt = Base64.decode((String)sshaString);
                byte[] digestBytes = new byte[digestPlusSalt.length - 8];
                System.arraycopy(digestPlusSalt, 0, digestBytes, 0, digestBytes.length);
                System.arraycopy(digestPlusSalt, digestBytes.length, saltBytes, 0, saltBytes.length);
            }
            catch (Exception e2) {
                throw new PwdEncryptorException("Unable to extract salt from encrypted password: " + e2.getMessage());
            }
        }
        return saltBytes;
    }
}

