/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.server.capabilities;

import com.liferay.portal.server.capabilities.ServerCapabilities;
import java.lang.reflect.Field;
import java.util.List;
import javax.servlet.ServletContext;

public class JettyServerCapabilities
implements ServerCapabilities {
    private boolean _supportsHotDeploy;

    public void determine(ServletContext servletContext) throws Exception {
        this.determineSupportsHotDeploy(servletContext);
    }

    public boolean isSupportsHotDeploy() {
        return this._supportsHotDeploy;
    }

    protected void determineSupportsHotDeploy(ServletContext servletContext) throws Exception {
        Class<?> servletContextClass = servletContext.getClass();
        Field outerClassField = servletContextClass.getDeclaredField("this$0");
        outerClassField.setAccessible(true);
        Object webAppContext = outerClassField.get(servletContext);
        Class<?> abstractHandlerClass = webAppContext.getClass();
        int i2 = 0;
        while (i2 < 6) {
            abstractHandlerClass = abstractHandlerClass.getSuperclass();
            ++i2;
        }
        Field serverField = abstractHandlerClass.getDeclaredField("_server");
        serverField.setAccessible(true);
        Object server = serverField.get(webAppContext);
        Class<?> aggregateLifeCycleClass = server.getClass();
        int i3 = 0;
        while (i3 < 4) {
            aggregateLifeCycleClass = aggregateLifeCycleClass.getSuperclass();
            ++i3;
        }
        Field beansField = aggregateLifeCycleClass.getDeclaredField("_beans");
        beansField.setAccessible(true);
        Object deploymentManager = null;
        List aggregateLifeCycleBeans = (List)beansField.get(server);
        for (Object aggregateLifeCycleBean : aggregateLifeCycleBeans) {
            Class<?> aggregateLifeCycleBeanClass = aggregateLifeCycleBean.getClass();
            Field beanField = aggregateLifeCycleBeanClass.getDeclaredField("_bean");
            beanField.setAccessible(true);
            Object bean = beanField.get(aggregateLifeCycleBean);
            Class<?> beanClass = bean.getClass();
            String beanClassName = beanClass.getName();
            if (!beanClassName.equals("org.eclipse.jetty.deploy.DeploymentManager")) continue;
            deploymentManager = bean;
            break;
        }
        if (deploymentManager == null) {
            throw new Exception("DeploymentManager not found");
        }
        Class<?> deploymentManagerClass = deploymentManager.getClass();
        Field providersField = deploymentManagerClass.getDeclaredField("_providers");
        providersField.setAccessible(true);
        List providers = (List)providersField.get(deploymentManager);
        boolean hotDeploySupported = false;
        for (Object provider : providers) {
            Class<?> providerClass = provider.getClass();
            String providerClassName = providerClass.getName();
            if (!providerClassName.equals("org.eclipse.jetty.deploy.providers.ContextProvider")) continue;
            Class<?> scanningAppProviderClass = providerClass.getSuperclass();
            Field scanIntervalField = scanningAppProviderClass.getDeclaredField("_scanInterval");
            scanIntervalField.setAccessible(true);
            Integer scanInterval = (Integer)scanIntervalField.get(provider);
            if (scanInterval == null || scanInterval <= 0) continue;
            hotDeploySupported = true;
            break;
        }
        this._supportsHotDeploy = hotDeploySupported;
    }
}

