/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.GroupServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(GroupServiceHttp.class);
    private static final Class<?>[] _addGroupParameterTypes0 = new Class[]{Long.TYPE, String.class, String.class, Integer.TYPE, String.class, Boolean.TYPE, Boolean.TYPE, ServiceContext.class};
    private static final Class<?>[] _addGroupParameterTypes1 = new Class[]{String.class, String.class, Integer.TYPE, String.class, Boolean.TYPE, Boolean.TYPE, ServiceContext.class};
    private static final Class<?>[] _addRoleGroupsParameterTypes2 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _deleteGroupParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getGroupParameterTypes4 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getGroupParameterTypes5 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getManageableSitesParameterTypes6 = new Class[]{Collection.class, Integer.TYPE};
    private static final Class<?>[] _getOrganizationsGroupsParameterTypes7 = new Class[]{List.class};
    private static final Class<?>[] _getUserGroupParameterTypes8 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getUserGroupsGroupsParameterTypes9 = new Class[]{List.class};
    private static final Class<?>[] _getUserOrganizationsGroupsParameterTypes10 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getUserPlacesParameterTypes11 = new Class[]{Long.TYPE, String[].class, Boolean.TYPE, Integer.TYPE};
    private static final Class<?>[] _getUserPlacesParameterTypes12 = new Class[]{Long.TYPE, String[].class, Integer.TYPE};
    private static final Class<?>[] _getUserPlacesParameterTypes13 = new Class[]{String[].class, Integer.TYPE};
    private static final Class<?>[] _getUserSitesParameterTypes14 = new Class[0];
    private static final Class<?>[] _hasUserGroupParameterTypes15 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _searchParameterTypes16 = new Class[]{Long.TYPE, String.class, String.class, String[].class, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _searchCountParameterTypes17 = new Class[]{Long.TYPE, String.class, String.class, String[].class};
    private static final Class<?>[] _setRoleGroupsParameterTypes18 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _unsetRoleGroupsParameterTypes19 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _updateFriendlyURLParameterTypes20 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _updateGroupParameterTypes21 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _updateGroupParameterTypes22 = new Class[]{Long.TYPE, String.class, String.class, Integer.TYPE, String.class, Boolean.TYPE, ServiceContext.class};

    public static Group addGroup(HttpPrincipal httpPrincipal, long liveGroupId, String name, String description, int type, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "addGroup", (Class[])_addGroupParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{liveGroupId, name, description, type, friendlyURL, site, active, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group addGroup(HttpPrincipal httpPrincipal, String name, String description, int type, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "addGroup", (Class[])_addGroupParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{name, description, type, friendlyURL, site, active, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void addRoleGroups(HttpPrincipal httpPrincipal, long roleId, long[] groupIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "addRoleGroups", (Class[])_addRoleGroupsParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, groupIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteGroup(HttpPrincipal httpPrincipal, long groupId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "deleteGroup", (Class[])_deleteGroupParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group getGroup(HttpPrincipal httpPrincipal, long groupId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "getGroup", (Class[])_getGroupParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group getGroup(HttpPrincipal httpPrincipal, long companyId, String name) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "getGroup", (Class[])_getGroupParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> getManageableSites(HttpPrincipal httpPrincipal, Collection<Portlet> portlets, int max) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "getManageableSites", (Class[])_getManageableSitesParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{portlets, max});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> getOrganizationsGroups(HttpPrincipal httpPrincipal, List<Organization> organizations) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "getOrganizationsGroups", (Class[])_getOrganizationsGroupsParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{organizations});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group getUserGroup(HttpPrincipal httpPrincipal, long companyId, long userId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "getUserGroup", (Class[])_getUserGroupParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> getUserGroupsGroups(HttpPrincipal httpPrincipal, List<UserGroup> userGroups) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "getUserGroupsGroups", (Class[])_getUserGroupsGroupsParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userGroups});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> getUserOrganizationsGroups(HttpPrincipal httpPrincipal, long userId, int start, int end) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "getUserOrganizationsGroups", (Class[])_getUserOrganizationsGroupsParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> getUserPlaces(HttpPrincipal httpPrincipal, long userId, String[] classNames, boolean includeControlPanel, int max) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "getUserPlaces", (Class[])_getUserPlacesParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, classNames, includeControlPanel, max});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> getUserPlaces(HttpPrincipal httpPrincipal, long userId, String[] classNames, int max) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "getUserPlaces", (Class[])_getUserPlacesParameterTypes12);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, classNames, max});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> getUserPlaces(HttpPrincipal httpPrincipal, String[] classNames, int max) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "getUserPlaces", (Class[])_getUserPlacesParameterTypes13);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{classNames, max});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> getUserSites(HttpPrincipal httpPrincipal) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "getUserSites", (Class[])_getUserSitesParameterTypes14);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[0]);
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasUserGroup(HttpPrincipal httpPrincipal, long userId, long groupId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "hasUserGroup", (Class[])_hasUserGroupParameterTypes15);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> search(HttpPrincipal httpPrincipal, long companyId, String name, String description, String[] params, int start, int end) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "search", (Class[])_searchParameterTypes16);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, name, description, params, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int searchCount(HttpPrincipal httpPrincipal, long companyId, String name, String description, String[] params) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "searchCount", (Class[])_searchCountParameterTypes17);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, name, description, params});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setRoleGroups(HttpPrincipal httpPrincipal, long roleId, long[] groupIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "setRoleGroups", (Class[])_setRoleGroupsParameterTypes18);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, groupIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetRoleGroups(HttpPrincipal httpPrincipal, long roleId, long[] groupIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "unsetRoleGroups", (Class[])_unsetRoleGroupsParameterTypes19);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, groupIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group updateFriendlyURL(HttpPrincipal httpPrincipal, long groupId, String friendlyURL) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "updateFriendlyURL", (Class[])_updateFriendlyURLParameterTypes20);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, friendlyURL});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group updateGroup(HttpPrincipal httpPrincipal, long groupId, String typeSettings) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "updateGroup", (Class[])_updateGroupParameterTypes21);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, typeSettings});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group updateGroup(HttpPrincipal httpPrincipal, long groupId, String name, String description, int type, String friendlyURL, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "updateGroup", (Class[])_updateGroupParameterTypes22);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name, description, type, friendlyURL, active, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

