/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutReference;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(LayoutServiceHttp.class);
    private static final Class<?>[] _addLayoutParameterTypes0 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Map.class, Map.class, Map.class, Map.class, Map.class, String.class, Boolean.TYPE, String.class, ServiceContext.class};
    private static final Class<?>[] _addLayoutParameterTypes1 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, String.class, String.class, String.class, String.class, Boolean.TYPE, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteLayoutParameterTypes2 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, ServiceContext.class};
    private static final Class<?>[] _deleteLayoutParameterTypes3 = new Class[]{Long.TYPE, ServiceContext.class};
    private static final Class<?>[] _exportLayoutsParameterTypes4 = new Class[]{Long.TYPE, Boolean.TYPE, long[].class, Map.class, Date.class, Date.class};
    private static final Class<?>[] _exportLayoutsParameterTypes5 = new Class[]{Long.TYPE, Boolean.TYPE, Map.class, Date.class, Date.class};
    private static final Class<?>[] _exportLayoutsAsFileParameterTypes6 = new Class[]{Long.TYPE, Boolean.TYPE, long[].class, Map.class, Date.class, Date.class};
    private static final Class<?>[] _exportPortletInfoParameterTypes7 = new Class[]{Long.TYPE, Long.TYPE, String.class, Map.class, Date.class, Date.class};
    private static final Class<?>[] _exportPortletInfoAsFileParameterTypes8 = new Class[]{Long.TYPE, Long.TYPE, String.class, Map.class, Date.class, Date.class};
    private static final Class<?>[] _getDefaultPlidParameterTypes9 = new Class[]{Long.TYPE, Long.TYPE, Boolean.TYPE, String.class};
    private static final Class<?>[] _getLayoutNameParameterTypes10 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, String.class};
    private static final Class<?>[] _getLayoutReferencesParameterTypes11 = new Class[]{Long.TYPE, String.class, String.class, String.class};
    private static final Class<?>[] _getLayoutsParameterTypes12 = new Class[]{Long.TYPE, Boolean.TYPE};
    private static final Class<?>[] _getLayoutsParameterTypes13 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE};
    private static final Class<?>[] _importLayoutsParameterTypes14 = new Class[]{Long.TYPE, Boolean.TYPE, Map.class, byte[].class};
    private static final Class<?>[] _importLayoutsParameterTypes15 = new Class[]{Long.TYPE, Boolean.TYPE, Map.class, File.class};
    private static final Class<?>[] _importLayoutsParameterTypes16 = new Class[]{Long.TYPE, Boolean.TYPE, Map.class, InputStream.class};
    private static final Class<?>[] _importPortletInfoParameterTypes17 = new Class[]{Long.TYPE, Long.TYPE, String.class, Map.class, File.class};
    private static final Class<?>[] _importPortletInfoParameterTypes18 = new Class[]{Long.TYPE, Long.TYPE, String.class, Map.class, InputStream.class};
    private static final Class<?>[] _schedulePublishToLiveParameterTypes19 = new Class[]{Long.TYPE, Long.TYPE, Boolean.TYPE, Map.class, Map.class, String.class, Date.class, Date.class, String.class, String.class, Date.class, Date.class, String.class};
    private static final Class<?>[] _schedulePublishToRemoteParameterTypes20 = new Class[]{Long.TYPE, Boolean.TYPE, Map.class, Map.class, String.class, Integer.TYPE, String.class, Boolean.TYPE, Long.TYPE, Boolean.TYPE, Date.class, Date.class, String.class, String.class, Date.class, Date.class, String.class};
    private static final Class<?>[] _setLayoutsParameterTypes21 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, long[].class, ServiceContext.class};
    private static final Class<?>[] _unschedulePublishToLiveParameterTypes22 = new Class[]{Long.TYPE, String.class, String.class};
    private static final Class<?>[] _unschedulePublishToRemoteParameterTypes23 = new Class[]{Long.TYPE, String.class, String.class};
    private static final Class<?>[] _updateLayoutParameterTypes24 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Map.class, Map.class, Map.class, Map.class, Map.class, String.class, Boolean.TYPE, String.class, Boolean.class, byte[].class, ServiceContext.class};
    private static final Class<?>[] _updateLayoutParameterTypes25 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, String.class};
    private static final Class<?>[] _updateLookAndFeelParameterTypes26 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, String.class, String.class, String.class, Boolean.TYPE};
    private static final Class<?>[] _updateNameParameterTypes27 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, String.class, String.class};
    private static final Class<?>[] _updateNameParameterTypes28 = new Class[]{Long.TYPE, String.class, String.class};
    private static final Class<?>[] _updateParentLayoutIdParameterTypes29 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE};
    private static final Class<?>[] _updateParentLayoutIdParameterTypes30 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _updatePriorityParameterTypes31 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Integer.TYPE};
    private static final Class<?>[] _updatePriorityParameterTypes32 = new Class[]{Long.TYPE, Integer.TYPE};

    public static Layout addLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "addLayout", (Class[])_addLayoutParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parentLayoutId, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURL, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout addLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "addLayout", (Class[])_addLayoutParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parentLayoutId, name, title, description, type, hidden, friendlyURL, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "deleteLayout", (Class[])_deleteLayoutParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, serviceContext});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteLayout(HttpPrincipal httpPrincipal, long plid, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "deleteLayout", (Class[])_deleteLayoutParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, serviceContext});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static byte[] exportLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "exportLayouts", (Class[])_exportLayoutsParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutIds, parameterMap, startDate, endDate});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (byte[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static byte[] exportLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "exportLayouts", (Class[])_exportLayoutsParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parameterMap, startDate, endDate});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (byte[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static File exportLayoutsAsFile(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "exportLayoutsAsFile", (Class[])_exportLayoutsAsFileParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutIds, parameterMap, startDate, endDate});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (File)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static byte[] exportPortletInfo(HttpPrincipal httpPrincipal, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "exportPortletInfo", (Class[])_exportPortletInfoParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, groupId, portletId, parameterMap, startDate, endDate});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (byte[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static File exportPortletInfoAsFile(HttpPrincipal httpPrincipal, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "exportPortletInfoAsFile", (Class[])_exportPortletInfoAsFileParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, groupId, portletId, parameterMap, startDate, endDate});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (File)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static long getDefaultPlid(HttpPrincipal httpPrincipal, long groupId, long scopeGroupId, boolean privateLayout, String portletId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "getDefaultPlid", (Class[])_getDefaultPlidParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, scopeGroupId, privateLayout, portletId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Long)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static String getLayoutName(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, String languageId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "getLayoutName", (Class[])_getLayoutNameParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, languageId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (String)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static LayoutReference[] getLayoutReferences(HttpPrincipal httpPrincipal, long companyId, String portletId, String preferencesKey, String preferencesValue) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "getLayoutReferences", (Class[])_getLayoutReferencesParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, portletId, preferencesKey, preferencesValue});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (LayoutReference[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Layout> getLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "getLayouts", (Class[])_getLayoutsParameterTypes12);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Layout> getLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long parentLayoutId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "getLayouts", (Class[])_getLayoutsParameterTypes13);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parentLayoutId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, byte[] bytes) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "importLayouts", (Class[])_importLayoutsParameterTypes14);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parameterMap, bytes});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "importLayouts", (Class[])_importLayoutsParameterTypes15);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parameterMap, file});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "importLayouts", (Class[])_importLayoutsParameterTypes16);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parameterMap, is});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importPortletInfo(HttpPrincipal httpPrincipal, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "importPortletInfo", (Class[])_importPortletInfoParameterTypes17);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, groupId, portletId, parameterMap, file});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importPortletInfo(HttpPrincipal httpPrincipal, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "importPortletInfo", (Class[])_importPortletInfoParameterTypes18);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, groupId, portletId, parameterMap, is});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void schedulePublishToLive(HttpPrincipal httpPrincipal, long sourceGroupId, long targetGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String scope, Date startDate, Date endDate, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "schedulePublishToLive", (Class[])_schedulePublishToLiveParameterTypes19);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{sourceGroupId, targetGroupId, privateLayout, layoutIdMap, parameterMap, scope, startDate, endDate, groupName, cronText, schedulerStartDate, schedulerEndDate, description});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void schedulePublishToRemote(HttpPrincipal httpPrincipal, long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout, Date startDate, Date endDate, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "schedulePublishToRemote", (Class[])_schedulePublishToRemoteParameterTypes20);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{sourceGroupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, remotePrivateLayout, startDate, endDate, groupName, cronText, schedulerStartDate, schedulerEndDate, description});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long parentLayoutId, long[] layoutIds, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "setLayouts", (Class[])_setLayoutsParameterTypes21);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parentLayoutId, layoutIds, serviceContext});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unschedulePublishToLive(HttpPrincipal httpPrincipal, long groupId, String jobName, String groupName) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "unschedulePublishToLive", (Class[])_unschedulePublishToLiveParameterTypes22);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, jobName, groupName});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unschedulePublishToRemote(HttpPrincipal httpPrincipal, long groupId, String jobName, String groupName) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "unschedulePublishToRemote", (Class[])_unschedulePublishToRemoteParameterTypes23);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, jobName, groupName});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, String friendlyURL, Boolean iconImage, byte[] iconBytes, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updateLayout", (Class[])_updateLayoutParameterTypes24);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, parentLayoutId, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURL, iconImage, iconBytes, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updateLayout", (Class[])_updateLayoutParameterTypes25);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, typeSettings});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateLookAndFeel(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css, boolean wapTheme) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updateLookAndFeel", (Class[])_updateLookAndFeelParameterTypes26);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, themeId, colorSchemeId, css, wapTheme});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateName(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updateName", (Class[])_updateNameParameterTypes27);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, name, languageId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateName(HttpPrincipal httpPrincipal, long plid, String name, String languageId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updateName", (Class[])_updateNameParameterTypes28);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, name, languageId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateParentLayoutId(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updateParentLayoutId", (Class[])_updateParentLayoutIdParameterTypes29);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, parentLayoutId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateParentLayoutId(HttpPrincipal httpPrincipal, long plid, long parentPlid) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updateParentLayoutId", (Class[])_updateParentLayoutIdParameterTypes30);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, parentPlid});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updatePriority(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, int priority) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updatePriority", (Class[])_updatePriorityParameterTypes31);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, priority});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updatePriority(HttpPrincipal httpPrincipal, long plid, int priority) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class.getName(), "updatePriority", (Class[])_updatePriorityParameterTypes32);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, priority});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

