/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.ResourceSoap;
import com.liferay.portal.model.impl.ResourceModelImpl;
import com.liferay.portal.security.permission.PermissionCheckerBag;
import com.liferay.portal.service.PermissionServiceUtil;
import java.rmi.RemoteException;

public class PermissionServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(PermissionServiceSoap.class);

    public static void checkPermission(long groupId, long resourceId) throws RemoteException {
        try {
            PermissionServiceUtil.checkPermission((long)groupId, (long)resourceId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void checkPermission(long groupId, String name, long primKey) throws RemoteException {
        try {
            PermissionServiceUtil.checkPermission((long)groupId, (String)name, (long)primKey);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void checkPermission(long groupId, String name, String primKey) throws RemoteException {
        try {
            PermissionServiceUtil.checkPermission((long)groupId, (String)name, (String)primKey);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static boolean hasGroupPermission(long groupId, String actionId, long resourceId) throws RemoteException {
        try {
            boolean returnValue = PermissionServiceUtil.hasGroupPermission((long)groupId, (String)actionId, (long)resourceId);
            return returnValue;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static boolean hasUserPermission(long userId, String actionId, long resourceId) throws RemoteException {
        try {
            boolean returnValue = PermissionServiceUtil.hasUserPermission((long)userId, (String)actionId, (long)resourceId);
            return returnValue;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static boolean hasUserPermissions(long userId, long groupId, ResourceSoap[] resources, String actionId, PermissionCheckerBag permissionCheckerBag) throws RemoteException {
        try {
            boolean returnValue = PermissionServiceUtil.hasUserPermissions((long)userId, (long)groupId, ResourceModelImpl.toModels(resources), (String)actionId, (PermissionCheckerBag)permissionCheckerBag);
            return returnValue;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void setGroupPermissions(long groupId, String[] actionIds, long resourceId) throws RemoteException {
        try {
            PermissionServiceUtil.setGroupPermissions((long)groupId, (String[])actionIds, (long)resourceId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void setGroupPermissions(String className, String classPK, long groupId, String[] actionIds, long resourceId) throws RemoteException {
        try {
            PermissionServiceUtil.setGroupPermissions((String)className, (String)classPK, (long)groupId, (String[])actionIds, (long)resourceId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void setOrgGroupPermissions(long organizationId, long groupId, String[] actionIds, long resourceId) throws RemoteException {
        try {
            PermissionServiceUtil.setOrgGroupPermissions((long)organizationId, (long)groupId, (String[])actionIds, (long)resourceId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void setRolePermission(long roleId, long groupId, String name, int scope, String primKey, String actionId) throws RemoteException {
        try {
            PermissionServiceUtil.setRolePermission((long)roleId, (long)groupId, (String)name, (int)scope, (String)primKey, (String)actionId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void setRolePermissions(long roleId, long groupId, String[] actionIds, long resourceId) throws RemoteException {
        try {
            PermissionServiceUtil.setRolePermissions((long)roleId, (long)groupId, (String[])actionIds, (long)resourceId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void setUserPermissions(long userId, long groupId, String[] actionIds, long resourceId) throws RemoteException {
        try {
            PermissionServiceUtil.setUserPermissions((long)userId, (long)groupId, (String[])actionIds, (long)resourceId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void unsetRolePermission(long roleId, long groupId, long permissionId) throws RemoteException {
        try {
            PermissionServiceUtil.unsetRolePermission((long)roleId, (long)groupId, (long)permissionId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void unsetRolePermission(long roleId, long groupId, String name, int scope, String primKey, String actionId) throws RemoteException {
        try {
            PermissionServiceUtil.unsetRolePermission((long)roleId, (long)groupId, (String)name, (int)scope, (String)primKey, (String)actionId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void unsetRolePermissions(long roleId, long groupId, String name, int scope, String actionId) throws RemoteException {
        try {
            PermissionServiceUtil.unsetRolePermissions((long)roleId, (long)groupId, (String)name, (int)scope, (String)actionId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void unsetUserPermissions(long userId, long groupId, String[] actionIds, long resourceId) throws RemoteException {
        try {
            PermissionServiceUtil.unsetUserPermissions((long)userId, (long)groupId, (String[])actionIds, (long)resourceId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }
}

