/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ResourcePermissionServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcePermissionServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(ResourcePermissionServiceHttp.class);
    private static final Class<?>[] _addResourcePermissionParameterTypes0 = new Class[]{Long.TYPE, Long.TYPE, String.class, Integer.TYPE, String.class, Long.TYPE, String.class};
    private static final Class<?>[] _removeResourcePermissionParameterTypes1 = new Class[]{Long.TYPE, Long.TYPE, String.class, Integer.TYPE, String.class, Long.TYPE, String.class};
    private static final Class<?>[] _removeResourcePermissionsParameterTypes2 = new Class[]{Long.TYPE, Long.TYPE, String.class, Integer.TYPE, Long.TYPE, String.class};
    private static final Class<?>[] _setIndividualResourcePermissionsParameterTypes3 = new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, Long.TYPE, String[].class};
    private static final Class<?>[] _setIndividualResourcePermissionsParameterTypes4 = new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, Map.class};

    public static void addResourcePermission(HttpPrincipal httpPrincipal, long groupId, long companyId, String name, int scope, String primKey, long roleId, String actionId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ResourcePermissionServiceUtil.class.getName(), "addResourcePermission", (Class[])_addResourcePermissionParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, companyId, name, scope, primKey, roleId, actionId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void removeResourcePermission(HttpPrincipal httpPrincipal, long groupId, long companyId, String name, int scope, String primKey, long roleId, String actionId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ResourcePermissionServiceUtil.class.getName(), "removeResourcePermission", (Class[])_removeResourcePermissionParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, companyId, name, scope, primKey, roleId, actionId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void removeResourcePermissions(HttpPrincipal httpPrincipal, long groupId, long companyId, String name, int scope, long roleId, String actionId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ResourcePermissionServiceUtil.class.getName(), "removeResourcePermissions", (Class[])_removeResourcePermissionsParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, companyId, name, scope, roleId, actionId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setIndividualResourcePermissions(HttpPrincipal httpPrincipal, long groupId, long companyId, String name, String primKey, long roleId, String[] actionIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ResourcePermissionServiceUtil.class.getName(), "setIndividualResourcePermissions", (Class[])_setIndividualResourcePermissionsParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, companyId, name, primKey, roleId, actionIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setIndividualResourcePermissions(HttpPrincipal httpPrincipal, long groupId, long companyId, String name, String primKey, Map<Long, String[]> roleIdsToActionIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ResourcePermissionServiceUtil.class.getName(), "setIndividualResourcePermissions", (Class[])_setIndividualResourcePermissionsParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, companyId, name, primKey, roleIdsToActionIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

