/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ClassName;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.impl.ClassNameImpl;
import com.liferay.portal.service.base.ClassNameLocalServiceBaseImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNameLocalServiceImpl
extends ClassNameLocalServiceBaseImpl
implements CacheRegistryItem {
    private static Map<String, ClassName> _classNames = new ConcurrentHashMap<String, ClassName>();
    private static ClassName _nullClassName = new ClassNameImpl();

    public ClassName addClassName(String value) throws SystemException {
        ClassName className = this.classNamePersistence.fetchByValue(value);
        if (className == null) {
            long classNameId = this.counterLocalService.increment();
            className = this.classNamePersistence.create(classNameId);
            className.setValue(value);
            this.classNamePersistence.update((BaseModel)className, false);
        }
        return className;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        CacheRegistryUtil.register((CacheRegistryItem)this);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkClassNames() throws SystemException {
        List classNames = this.classNamePersistence.findAll();
        for (ClassName className : classNames) {
            _classNames.put(className.getValue(), className);
        }
        List models = ModelHintsUtil.getModels();
        for (String model : models) {
            this.getClassName(model);
        }
    }

    @Skip
    public ClassName fetchClassName(String value) throws SystemException {
        if (Validator.isNull((String)value)) {
            return _nullClassName;
        }
        ClassName className = _classNames.get(value);
        if (className == null) {
            className = this.classNamePersistence.fetchByValue(value);
            if (className == null) {
                return _nullClassName;
            }
            _classNames.put(value, className);
        }
        return className;
    }

    @Skip
    public long fetchClassNameId(Class<?> clazz) {
        return this.fetchClassNameId(clazz.getName());
    }

    @Skip
    public long fetchClassNameId(String value) {
        try {
            ClassName className = this.fetchClassName(value);
            return className.getClassNameId();
        }
        catch (Exception e2) {
            throw new RuntimeException("Unable to get class name from value " + value, e2);
        }
    }

    @Skip
    public ClassName getClassName(String value) throws SystemException {
        if (Validator.isNull((String)value)) {
            return _nullClassName;
        }
        ClassName className = _classNames.get(value);
        if (className == null) {
            className = this.classNameLocalService.addClassName(value);
            _classNames.put(value, className);
        }
        return className;
    }

    @Skip
    public long getClassNameId(Class<?> clazz) {
        return this.getClassNameId(clazz.getName());
    }

    @Skip
    public long getClassNameId(String value) {
        try {
            ClassName className = this.getClassName(value);
            return className.getClassNameId();
        }
        catch (Exception e2) {
            throw new RuntimeException("Unable to get class name from value " + value, e2);
        }
    }

    public String getRegistryName() {
        return ClassNameLocalServiceImpl.class.getName();
    }

    public void invalidate() {
        _classNames.clear();
    }
}

