/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.AccountNameException;
import com.liferay.portal.CompanyMxException;
import com.liferay.portal.CompanyVirtualHostException;
import com.liferay.portal.CompanyWebIdException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.NoSuchShardException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.NoSuchVirtualHostException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.FacetedSearcher;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.facet.AssetEntriesFacet;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.ScopeFacet;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.VirtualHost;
import com.liferay.portal.service.base.CompanyLocalServiceBaseImpl;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.Encryptor;
import com.liferay.util.EncryptorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyLocalServiceImpl
extends CompanyLocalServiceBaseImpl {
    private static final String _DEFAULT_VIRTUAL_HOST = "localhost";
    private static Log _log = LogFactoryUtil.getLog(CompanyLocalServiceImpl.class);

    public Company addCompany(String webId, String virtualHostname, String mx, String shardName, boolean system, int maxUsers, boolean active) throws PortalException, SystemException {
        virtualHostname = virtualHostname.trim().toLowerCase();
        if (Validator.isNull((String)webId) || webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID) || this.companyPersistence.fetchByWebId(webId) != null) {
            throw new CompanyWebIdException();
        }
        this.validate(webId, virtualHostname, mx);
        Company company = this.checkCompany(webId, mx, shardName);
        company.setMx(mx);
        company.setSystem(system);
        company.setMaxUsers(maxUsers);
        company.setActive(active);
        this.companyPersistence.update((BaseModel)company, false);
        this.updateVirtualHost(company.getCompanyId(), virtualHostname);
        return company;
    }

    public Company checkCompany(String webId) throws PortalException, SystemException {
        String mx = webId;
        return this.companyLocalService.checkCompany(webId, mx, PropsValues.SHARD_DEFAULT_NAME);
    }

    public Company checkCompany(String webId, String mx, String shardName) throws PortalException, SystemException {
        Date now = new Date();
        Company company = this.companyPersistence.fetchByWebId(webId);
        if (company == null) {
            String name = webId;
            String legalName = null;
            String legalId = null;
            String legalType = null;
            String sicCode = null;
            String tickerSymbol = null;
            String industry = null;
            String type = null;
            String size = null;
            long companyId = this.counterLocalService.increment();
            company = this.companyPersistence.create(companyId);
            try {
                company.setKey(Base64.objectToString((Object)Encryptor.generateKey()));
            }
            catch (EncryptorException ee) {
                throw new SystemException((Throwable)ee);
            }
            company.setWebId(webId);
            company.setMx(mx);
            company.setActive(true);
            this.companyPersistence.update((BaseModel)company, false);
            this.shardLocalService.addShard(Company.class.getName(), companyId, shardName);
            this.updateAccount(company, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size);
            if (webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
                this.updateVirtualHost(companyId, _DEFAULT_VIRTUAL_HOST);
            }
            if (webId.equals("liferay.net")) {
                company = this.companyPersistence.findByWebId(webId);
                this.updateVirtualHost(companyId, "demo.liferay.net");
                this.updateSecurity(companyId, "emailAddress", true, true, true, true, false, true);
                PortletPreferences preferences = PrefsPropsUtil.getPreferences(companyId);
                try {
                    preferences.setValue("admin.email.from.name", "Liferay Demo");
                    preferences.setValue("admin.email.from.address", "test@liferay.net");
                    preferences.store();
                }
                catch (IOException ioe) {
                    throw new SystemException((Throwable)ioe);
                }
                catch (PortletException pe) {
                    throw new SystemException((Throwable)pe);
                }
            }
        } else {
            try {
                this.shardLocalService.getShard(Company.class.getName(), company.getCompanyId());
            }
            catch (NoSuchShardException noSuchShardException) {
                this.shardLocalService.addShard(Company.class.getName(), company.getCompanyId(), shardName);
            }
        }
        long companyId = company.getCompanyId();
        this.checkCompanyKey(companyId);
        User defaultUser = null;
        try {
            defaultUser = this.userLocalService.getDefaultUser(companyId);
            if (!defaultUser.isAgreedToTermsOfUse()) {
                defaultUser.setAgreedToTermsOfUse(true);
                this.userPersistence.update((BaseModel)defaultUser, false);
            }
        }
        catch (NoSuchUserException noSuchUserException) {
            long userId = this.counterLocalService.increment();
            defaultUser = this.userPersistence.create(userId);
            defaultUser.setCompanyId(companyId);
            defaultUser.setCreateDate(now);
            defaultUser.setModifiedDate(now);
            defaultUser.setDefaultUser(true);
            defaultUser.setContactId(this.counterLocalService.increment());
            defaultUser.setPassword("password");
            defaultUser.setScreenName(String.valueOf(defaultUser.getUserId()));
            defaultUser.setEmailAddress("default@" + company.getMx());
            if (Validator.isNotNull((String)PropsValues.COMPANY_DEFAULT_LOCALE)) {
                defaultUser.setLanguageId(PropsValues.COMPANY_DEFAULT_LOCALE);
            } else {
                Locale locale = LocaleUtil.getDefault();
                defaultUser.setLanguageId(locale.toString());
            }
            if (Validator.isNotNull((String)PropsValues.COMPANY_DEFAULT_TIME_ZONE)) {
                defaultUser.setTimeZoneId(PropsValues.COMPANY_DEFAULT_TIME_ZONE);
            } else {
                TimeZone timeZone = TimeZoneUtil.getDefault();
                defaultUser.setTimeZoneId(timeZone.getID());
            }
            defaultUser.setGreeting(LanguageUtil.format((Locale)defaultUser.getLocale(), (String)"welcome-x", (Object)"", (boolean)false));
            defaultUser.setLoginDate(now);
            defaultUser.setFailedLoginAttempts(0);
            defaultUser.setAgreedToTermsOfUse(true);
            defaultUser.setStatus(0);
            this.userPersistence.update((BaseModel)defaultUser, false);
            Contact defaultContact = this.contactPersistence.create(defaultUser.getContactId());
            defaultContact.setCompanyId(defaultUser.getCompanyId());
            defaultContact.setUserId(defaultUser.getUserId());
            defaultContact.setUserName("");
            defaultContact.setCreateDate(now);
            defaultContact.setModifiedDate(now);
            defaultContact.setAccountId(company.getAccountId());
            defaultContact.setParentContactId(0L);
            defaultContact.setFirstName("");
            defaultContact.setMiddleName("");
            defaultContact.setLastName("");
            defaultContact.setMale(true);
            defaultContact.setBirthday(now);
            this.contactPersistence.update((BaseModel)defaultContact, false);
        }
        this.roleLocalService.checkSystemRoles(companyId);
        this.groupLocalService.checkSystemGroups(companyId);
        this.groupLocalService.checkCompanyGroup(companyId);
        this.passwordPolicyLocalService.checkDefaultPasswordPolicy(companyId);
        Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
        this.roleLocalService.setUserRoles(defaultUser.getUserId(), new long[]{guestRole.getRoleId()});
        if (this.userPersistence.countByCompanyId(companyId) == 1) {
            String emailAddress = String.valueOf(PropsValues.DEFAULT_ADMIN_EMAIL_ADDRESS_PREFIX) + "@" + mx;
            this.userLocalService.addDefaultAdminUser(companyId, PropsValues.DEFAULT_ADMIN_SCREEN_NAME, emailAddress, defaultUser.getLocale(), PropsValues.DEFAULT_ADMIN_FIRST_NAME, PropsValues.DEFAULT_ADMIN_MIDDLE_NAME, PropsValues.DEFAULT_ADMIN_LAST_NAME);
        }
        this.portletLocalService.checkPortlets(companyId);
        return company;
    }

    public void checkCompanyKey(long companyId) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (Validator.isNull((String)company.getKey()) && company.getKeyObj() == null) {
            try {
                company.setKey(Base64.objectToString((Object)Encryptor.generateKey()));
            }
            catch (EncryptorException ee) {
                throw new SystemException((Throwable)ee);
            }
            this.companyPersistence.update((BaseModel)company, false);
        }
    }

    public void deleteLogo(long companyId) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        long logoId = company.getLogoId();
        if (logoId > 0L) {
            company.setLogoId(0L);
            this.companyPersistence.update((BaseModel)company, false);
            this.imageLocalService.deleteImage(logoId);
        }
    }

    public Company fetchCompanyById(long companyId) throws SystemException {
        return this.companyPersistence.fetchByPrimaryKey(companyId);
    }

    public Company fetchCompanyByVirtualHost(String virtualHostname) throws SystemException {
        VirtualHost virtualHost = this.virtualHostPersistence.fetchByHostname(virtualHostname = virtualHostname.trim().toLowerCase());
        if (virtualHost == null || virtualHost.getLayoutSetId() != 0L) {
            return null;
        }
        return this.companyPersistence.fetchByPrimaryKey(virtualHost.getCompanyId());
    }

    public List<Company> getCompanies() throws SystemException {
        return this.companyPersistence.findAll();
    }

    public List<Company> getCompanies(boolean system) throws SystemException {
        return this.companyPersistence.findBySystem(system);
    }

    public int getCompaniesCount(boolean system) throws SystemException {
        return this.companyPersistence.countBySystem(system);
    }

    public Company getCompanyById(long companyId) throws PortalException, SystemException {
        return this.companyPersistence.findByPrimaryKey(companyId);
    }

    public Company getCompanyByLogoId(long logoId) throws PortalException, SystemException {
        return this.companyPersistence.findByLogoId(logoId);
    }

    public Company getCompanyByMx(String mx) throws PortalException, SystemException {
        return this.companyPersistence.findByMx(mx);
    }

    public Company getCompanyByVirtualHost(String virtualHostname) throws PortalException, SystemException {
        try {
            virtualHostname = virtualHostname.trim().toLowerCase();
            VirtualHost virtualHost = this.virtualHostPersistence.findByHostname(virtualHostname);
            if (virtualHost.getLayoutSetId() != 0L) {
                throw new CompanyVirtualHostException("Virtual host is associated with layout set " + virtualHost.getLayoutSetId());
            }
            return this.companyPersistence.findByPrimaryKey(virtualHost.getCompanyId());
        }
        catch (NoSuchVirtualHostException nsvhe) {
            throw new CompanyVirtualHostException((Throwable)nsvhe);
        }
    }

    public Company getCompanyByWebId(String webId) throws PortalException, SystemException {
        return this.companyPersistence.findByWebId(webId);
    }

    public long getCompanyIdByUserId(long userId) throws Exception {
        long companyId;
        block5: {
            long[] companyIds = PortalInstances.getCompanyIds();
            companyId = 0L;
            if (companyIds.length == 1) {
                companyId = companyIds[0];
            } else if (companyIds.length > 1) {
                try {
                    User user = this.userPersistence.findByPrimaryKey(userId);
                    companyId = user.getCompanyId();
                }
                catch (Exception e2) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)("Unable to get the company id for user " + userId), (Throwable)e2);
                }
            }
        }
        return companyId;
    }

    public void removePreferences(long companyId, String[] keys) throws SystemException {
        PortletPreferences preferences = PrefsPropsUtil.getPreferences(companyId);
        try {
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                preferences.reset(key);
                ++n2;
            }
            preferences.store();
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public Hits search(long companyId, long userId, String keywords, int start, int end) throws SystemException {
        return this.search(companyId, userId, null, 0L, null, keywords, start, end);
    }

    public Hits search(long companyId, long userId, String portletId, long groupId, String type, String keywords, int start, int end) throws SystemException {
        try {
            SearchContext searchContext = new SearchContext();
            searchContext.setCompanyId(companyId);
            searchContext.setEnd(end);
            searchContext.setEntryClassNames(SearchEngineUtil.getEntryClassNames());
            if (groupId > 0L) {
                searchContext.setGroupIds(new long[]{groupId});
            }
            searchContext.setKeywords(keywords);
            if (Validator.isNotNull((String)portletId)) {
                searchContext.setPortletIds(new String[]{portletId});
            }
            searchContext.setStart(start);
            searchContext.setUserId(userId);
            AssetEntriesFacet assetEntriesFacet = new AssetEntriesFacet(searchContext);
            assetEntriesFacet.setStatic(true);
            searchContext.addFacet((Facet)assetEntriesFacet);
            ScopeFacet scopeFacet = new ScopeFacet(searchContext);
            scopeFacet.setStatic(true);
            searchContext.addFacet((Facet)scopeFacet);
            Indexer indexer = FacetedSearcher.getInstance();
            return indexer.search(searchContext);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public Company updateCompany(long companyId, String virtualHostname, String mx, int maxUsers, boolean active) throws PortalException, SystemException {
        virtualHostname = virtualHostname.trim().toLowerCase();
        if (!active && companyId == PortalInstances.getDefaultCompanyId()) {
            active = true;
        }
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        this.validate(company.getWebId(), virtualHostname, mx);
        if (PropsValues.MAIL_MX_UPDATE) {
            company.setMx(mx);
        }
        company.setMaxUsers(maxUsers);
        company.setActive(active);
        this.companyPersistence.update((BaseModel)company, false);
        this.updateVirtualHost(companyId, virtualHostname);
        return company;
    }

    public Company updateCompany(long companyId, String virtualHostname, String mx, String homeURL, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size) throws PortalException, SystemException {
        virtualHostname = virtualHostname.trim().toLowerCase();
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        this.validate(company.getWebId(), virtualHostname, mx);
        this.validate(companyId, name);
        if (PropsValues.MAIL_MX_UPDATE) {
            company.setMx(mx);
        }
        company.setHomeURL(homeURL);
        this.companyPersistence.update((BaseModel)company, false);
        this.updateAccount(company, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size);
        this.updateVirtualHost(companyId, virtualHostname);
        return company;
    }

    public void updateDisplay(long companyId, String languageId, String timeZoneId) throws PortalException, SystemException {
        User user = this.userLocalService.getDefaultUser(companyId);
        user.setLanguageId(languageId);
        user.setTimeZoneId(timeZoneId);
        this.userPersistence.update((BaseModel)user, false);
    }

    public Company updateLogo(long companyId, byte[] bytes) throws PortalException, SystemException {
        Company company = this.checkLogo(companyId);
        this.imageLocalService.updateImage(company.getLogoId(), bytes);
        return company;
    }

    public Company updateLogo(long companyId, File file) throws PortalException, SystemException {
        Company company = this.checkLogo(companyId);
        this.imageLocalService.updateImage(company.getLogoId(), file);
        return company;
    }

    public Company updateLogo(long companyId, InputStream is) throws PortalException, SystemException {
        Company company = this.checkLogo(companyId);
        this.imageLocalService.updateImage(company.getLogoId(), is);
        return company;
    }

    public void updatePreferences(long companyId, UnicodeProperties properties) throws PortalException, SystemException {
        PortletPreferences preferences = PrefsPropsUtil.getPreferences(companyId);
        try {
            String oldLocales;
            String newLocales = properties.getProperty("locales");
            if (newLocales != null && !Validator.equals((Object)(oldLocales = preferences.getValue("locales", "")), (Object)newLocales)) {
                this.validateLocales(newLocales);
                LanguageUtil.resetAvailableLocales((long)companyId);
            }
            ArrayList<String> resetKeys = new ArrayList<String>();
            for (Map.Entry entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value.equals("TEMP_OBFUSCATION_VALUE")) continue;
                String propsUtilValue = PropsUtil.get(key);
                if (!value.equals(propsUtilValue)) {
                    preferences.setValue(key, value);
                    continue;
                }
                String preferencesValue = preferences.getValue(key, null);
                if (preferencesValue == null) continue;
                resetKeys.add(key);
            }
            for (String key : resetKeys) {
                preferences.reset(key);
            }
            preferences.store();
        }
        catch (LocaleException le) {
            throw le;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public void updateSecurity(long companyId, String authType, boolean autoLogin, boolean sendPassword, boolean strangers, boolean strangersWithMx, boolean strangersVerify, boolean siteLogo) throws SystemException {
        PortletPreferences preferences = PrefsPropsUtil.getPreferences(companyId);
        try {
            preferences.setValue("company.security.auth.type", authType);
            preferences.setValue("company.security.auto.login", String.valueOf(autoLogin));
            preferences.setValue("company.security.send.password", String.valueOf(sendPassword));
            preferences.setValue("company.security.strangers", String.valueOf(strangers));
            preferences.setValue("company.security.strangers.with.mx", String.valueOf(strangersWithMx));
            preferences.setValue("company.security.strangers.verify", String.valueOf(strangersVerify));
            preferences.setValue("company.security.site.logo", String.valueOf(siteLogo));
            preferences.store();
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        catch (PortletException pe) {
            throw new SystemException((Throwable)pe);
        }
    }

    protected Company checkLogo(long companyId) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        long logoId = company.getLogoId();
        if (logoId <= 0L) {
            logoId = this.counterLocalService.increment();
            company.setLogoId(logoId);
            company = (Company)this.companyPersistence.update((BaseModel)company, false);
        }
        return company;
    }

    protected void updateAccount(Company company, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size) throws SystemException {
        Date now = new Date();
        Account account = this.accountPersistence.fetchByPrimaryKey(company.getAccountId());
        if (account == null) {
            long accountId = this.counterLocalService.increment();
            account = this.accountPersistence.create(accountId);
            account.setCompanyId(company.getCompanyId());
            account.setCreateDate(now);
            account.setUserId(0L);
            account.setUserName("");
            company.setAccountId(accountId);
            this.companyPersistence.update((BaseModel)company, false);
        }
        account.setModifiedDate(now);
        account.setName(name);
        account.setLegalName(legalName);
        account.setLegalId(legalId);
        account.setLegalType(legalType);
        account.setSicCode(sicCode);
        account.setTickerSymbol(tickerSymbol);
        account.setIndustry(industry);
        account.setType(type);
        account.setSize(size);
        this.accountPersistence.update((BaseModel)account, false);
    }

    protected void updateVirtualHost(long companyId, String virtualHostname) throws CompanyVirtualHostException, SystemException {
        if (Validator.isNotNull((String)virtualHostname)) {
            try {
                VirtualHost virtualHost = this.virtualHostPersistence.findByHostname(virtualHostname);
                if (virtualHost.getCompanyId() != companyId || virtualHost.getLayoutSetId() != 0L) {
                    throw new CompanyVirtualHostException();
                }
            }
            catch (NoSuchVirtualHostException noSuchVirtualHostException) {
                this.virtualHostLocalService.updateVirtualHost(companyId, 0L, virtualHostname);
            }
        } else {
            try {
                this.virtualHostPersistence.removeByC_L(companyId, 0L);
            }
            catch (NoSuchVirtualHostException noSuchVirtualHostException) {}
        }
    }

    protected void validate(long companyId, String name) throws PortalException, SystemException {
        Group group = this.groupLocalService.fetchGroup(companyId, name);
        if (group != null || Validator.isNull((String)name)) {
            throw new AccountNameException();
        }
    }

    protected void validate(String webId, String virtualHostname, String mx) throws PortalException, SystemException {
        if (Validator.isNull((String)virtualHostname)) {
            throw new CompanyVirtualHostException();
        }
        if (virtualHostname.equals(_DEFAULT_VIRTUAL_HOST) && !webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            throw new CompanyVirtualHostException();
        }
        if (!Validator.isDomain((String)virtualHostname)) {
            throw new CompanyVirtualHostException();
        }
        try {
            VirtualHost virtualHost = this.virtualHostPersistence.findByHostname(virtualHostname);
            long companyId = virtualHost.getCompanyId();
            Company virtualHostnameCompany = this.companyPersistence.findByPrimaryKey(companyId);
            if (!virtualHostnameCompany.getWebId().equals(webId)) {
                throw new CompanyVirtualHostException();
            }
        }
        catch (NoSuchVirtualHostException noSuchVirtualHostException) {}
        if (Validator.isNull((String)mx)) {
            throw new CompanyMxException();
        }
        if (!Validator.isDomain((String)mx)) {
            throw new CompanyMxException();
        }
    }

    protected void validateLocales(String locales) throws PortalException {
        String[] localesArray;
        String[] stringArray = localesArray = StringUtil.split((String)locales, (String)",");
        int n = localesArray.length;
        int n2 = 0;
        while (n2 < n) {
            String locale = stringArray[n2];
            if (!ArrayUtil.contains((Object[])PropsValues.LOCALES, (Object)locale)) {
                throw new LocaleException();
            }
            ++n2;
        }
    }
}

