/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.GroupServiceBaseImpl;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.service.permission.RolePermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupServiceImpl
extends GroupServiceBaseImpl {
    public Group addGroup(long liveGroupId, String name, String description, int type, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)liveGroupId, (String)"UPDATE");
        return this.groupLocalService.addGroup(this.getUserId(), null, 0L, liveGroupId, name, description, type, friendlyURL, site, active, serviceContext);
    }

    public Group addGroup(String name, String description, int type, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_COMMUNITY");
        return this.groupLocalService.addGroup(this.getUserId(), null, 0L, name, description, type, friendlyURL, site, active, serviceContext);
    }

    public void addRoleGroups(long roleId, long[] groupIds) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"UPDATE");
        this.groupLocalService.addRoleGroups(roleId, groupIds);
    }

    public void deleteGroup(long groupId) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"DELETE");
        this.groupLocalService.deleteGroup(groupId);
    }

    public Group getGroup(long groupId) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW");
        return this.groupLocalService.getGroup(groupId);
    }

    public Group getGroup(long companyId, String name) throws PortalException, SystemException {
        Group group = this.groupLocalService.getGroup(companyId, name);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)group.getGroupId(), (String)"VIEW");
        return group;
    }

    public List<Group> getManageableSites(Collection<Portlet> portlets, int max) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
            params.put("site", Boolean.TRUE);
            return this.groupLocalService.search(permissionChecker.getCompanyId(), null, null, null, params, 0, max);
        }
        UniqueList groups = new UniqueList();
        groups.addAll(this.userPersistence.getGroups(permissionChecker.getUserId(), 0, max));
        groups.addAll(this.getUserOrganizationsGroups(permissionChecker.getUserId(), 0, max));
        List userGroups = this.userPersistence.getUserGroups(permissionChecker.getUserId(), 0, max);
        for (UserGroup userGroup : userGroups) {
            groups.addAll(this.userGroupPersistence.getGroups(userGroup.getUserGroupId(), 0, max));
        }
        Iterator itr = groups.iterator();
        while (itr.hasNext()) {
            Group group = (Group)itr.next();
            if (group.isSite() && PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getGroupId(), (long)0L, portlets, (String)"ACCESS_IN_CONTROL_PANEL")) continue;
            itr.remove();
        }
        return groups;
    }

    public List<Group> getOrganizationsGroups(List<Organization> organizations) throws PortalException, SystemException {
        List groups = this.groupLocalService.getOrganizationsGroups(organizations);
        return this.filterGroups(groups);
    }

    public Group getUserGroup(long companyId, long userId) throws PortalException, SystemException {
        Group group = this.groupLocalService.getUserGroup(companyId, userId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)group.getGroupId(), (String)"VIEW");
        return group;
    }

    public List<Group> getUserGroupsGroups(List<UserGroup> userGroups) throws PortalException, SystemException {
        List groups = this.groupLocalService.getUserGroupsGroups(userGroups);
        return this.filterGroups(groups);
    }

    public List<Group> getUserOrganizationsGroups(long userId, int start, int end) throws PortalException, SystemException {
        List groups = this.groupLocalService.getUserOrganizationsGroups(userId, start, end);
        return this.filterGroups(groups);
    }

    public List<Group> getUserPlaces(long userId, String[] classNames, boolean includeControlPanel, int max) throws PortalException, SystemException {
        PermissionChecker permissionChecker;
        User user = this.userPersistence.fetchByPrimaryKey(userId);
        if (user.isDefaultUser()) {
            return Collections.emptyList();
        }
        Object userPlaces = new UniqueList();
        int start = -1;
        int end = -1;
        if (max != -1) {
            start = 0;
            end = max;
        }
        if (classNames == null || ArrayUtil.contains((Object[])classNames, (Object)Group.class.getName())) {
            LinkedHashMap<String, Comparable<Boolean>> groupParams = new LinkedHashMap<String, Comparable<Boolean>>();
            groupParams.put("active", Boolean.TRUE);
            groupParams.put("usersGroups", new Long(userId));
            userPlaces.addAll(this.groupLocalService.search(user.getCompanyId(), groupParams, start, end));
        }
        if (classNames == null || ArrayUtil.contains((Object[])classNames, (Object)Organization.class.getName())) {
            LinkedHashMap<String, Long> organizationParams = new LinkedHashMap<String, Long>();
            organizationParams.put("usersOrgs", new Long(userId));
            List userOrgs = this.organizationLocalService.search(user.getCompanyId(), organizationParams, start, end);
            for (Organization organization : userOrgs) {
                userPlaces.add(0, organization.getGroup());
                if (PropsValues.ORGANIZATIONS_MEMBERSHIP_STRICT) continue;
                for (Organization ancestorOrganization : organization.getAncestors()) {
                    userPlaces.add(0, ancestorOrganization.getGroup());
                }
            }
        }
        if ((classNames == null || ArrayUtil.contains((Object[])classNames, (Object)User.class.getName())) && (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED || PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED)) {
            Group userGroup = user.getGroup();
            userPlaces.add(0, userGroup);
        }
        if ((permissionChecker = this.getPermissionChecker()).getUserId() != userId) {
            try {
                permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            }
            catch (Exception e2) {
                throw new PrincipalException((Throwable)e2);
            }
        }
        if (includeControlPanel && PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"VIEW_CONTROL_PANEL")) {
            Group controlPanelGroup = this.groupLocalService.getGroup(user.getCompanyId(), "Control Panel");
            userPlaces.add(0, controlPanelGroup);
        }
        if (max != -1 && userPlaces.size() > max) {
            userPlaces = ListUtil.subList((List)userPlaces, (int)start, (int)end);
        }
        return Collections.unmodifiableList(userPlaces);
    }

    public List<Group> getUserPlaces(long userId, String[] classNames, int max) throws PortalException, SystemException {
        return this.getUserPlaces(userId, classNames, false, max);
    }

    public List<Group> getUserPlaces(String[] classNames, int max) throws PortalException, SystemException {
        return this.getUserPlaces(this.getGuestOrUserId(), classNames, false, max);
    }

    public List<Group> getUserSites() throws PortalException, SystemException {
        return this.getUserPlaces(null, -1);
    }

    public boolean hasUserGroup(long userId, long groupId) throws PortalException, SystemException {
        try {
            UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        }
        catch (PrincipalException principalException) {
            GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW_MEMBERS");
        }
        return this.groupLocalService.hasUserGroup(userId, groupId);
    }

    public List<Group> search(long companyId, String name, String description, String[] params, int start, int end) throws PortalException, SystemException {
        LinkedHashMap paramsObj = MapUtil.toLinkedHashMap((String[])params);
        List groups = this.groupLocalService.search(companyId, name, description, paramsObj, start, end);
        return this.filterGroups(groups);
    }

    public int searchCount(long companyId, String name, String description, String[] params) throws SystemException {
        LinkedHashMap paramsObj = MapUtil.toLinkedHashMap((String[])params);
        return this.groupLocalService.searchCount(companyId, name, description, paramsObj);
    }

    public void setRoleGroups(long roleId, long[] groupIds) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"ASSIGN_MEMBERS");
        this.groupLocalService.setRoleGroups(roleId, groupIds);
    }

    public void unsetRoleGroups(long roleId, long[] groupIds) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"ASSIGN_MEMBERS");
        this.groupLocalService.unsetRoleGroups(roleId, groupIds);
    }

    public Group updateFriendlyURL(long groupId, String friendlyURL) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"UPDATE");
        return this.groupLocalService.updateFriendlyURL(groupId, friendlyURL);
    }

    public Group updateGroup(long groupId, String typeSettings) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"UPDATE");
        return this.groupLocalService.updateGroup(groupId, typeSettings);
    }

    public Group updateGroup(long groupId, String name, String description, int type, String friendlyURL, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"UPDATE");
        return this.groupLocalService.updateGroup(groupId, name, description, type, friendlyURL, active, serviceContext);
    }

    protected List<Group> filterGroups(List<Group> groups) throws PortalException, SystemException {
        ArrayList<Group> filteredGroups = new ArrayList<Group>();
        for (Group group : groups) {
            if (!GroupPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)group.getGroupId(), (String)"VIEW")) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }
}

