/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.ImageTypeException;
import com.liferay.portal.image.HookFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.Hook;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.impl.ImageImpl;
import com.liferay.portal.service.base.ImageLocalServiceBaseImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.webserver.WebServerServletTokenUtil;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageLocalServiceImpl
extends ImageLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(ImageLocalServiceImpl.class);
    private Image _defaultCompanyLogo;
    private Image _defaultOrganizationLogo;
    private Image _defaultSpacer;
    private Image _defaultUserFemalePortrait;
    private Image _defaultUserMalePortrait;

    @Override
    public void afterPropertiesSet() {
        InputStream is;
        super.afterPropertiesSet();
        ClassLoader classLoader = this.getClassLoader();
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.spacer"));
            if (is == null) {
                _log.error((Object)"Default spacer is not available");
            }
            this._defaultSpacer = this.getImage(is);
        }
        catch (Exception e2) {
            _log.error((Object)("Unable to configure the default spacer: " + e2.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.company.logo"));
            if (is == null) {
                _log.error((Object)"Default company logo is not available");
            }
            this._defaultCompanyLogo = this.getImage(is);
        }
        catch (Exception e3) {
            _log.error((Object)("Unable to configure the default company logo: " + e3.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.organization.logo"));
            if (is == null) {
                _log.error((Object)"Default organization logo is not available");
            }
            this._defaultOrganizationLogo = this.getImage(is);
        }
        catch (Exception e4) {
            _log.error((Object)("Unable to configure the default organization logo: " + e4.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.user.female.portrait"));
            if (is == null) {
                _log.error((Object)"Default user female portrait is not available");
            }
            this._defaultUserFemalePortrait = this.getImage(is);
        }
        catch (Exception e5) {
            _log.error((Object)("Unable to configure the default user female portrait: " + e5.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.user.male.portrait"));
            if (is == null) {
                _log.error((Object)"Default user male portrait is not available");
            }
            this._defaultUserMalePortrait = this.getImage(is);
        }
        catch (Exception e6) {
            _log.error((Object)("Unable to configure the default user male portrait: " + e6.getMessage()));
        }
    }

    @Override
    public Image deleteImage(long imageId) throws PortalException, SystemException {
        if (imageId <= 0L) {
            return null;
        }
        Image image = this.getImage(imageId);
        if (image != null) {
            this.imagePersistence.remove((BaseModel)image);
            Hook hook = HookFactory.getInstance();
            hook.deleteImage(image);
        }
        return image;
    }

    public Image getCompanyLogo(long imageId) {
        Image image = this.getImage(imageId);
        if (image == null) {
            image = this.getDefaultCompanyLogo();
        }
        return image;
    }

    public Image getDefaultCompanyLogo() {
        return this._defaultCompanyLogo;
    }

    public Image getDefaultOrganizationLogo() {
        return this._defaultOrganizationLogo;
    }

    public Image getDefaultSpacer() {
        return this._defaultSpacer;
    }

    public Image getDefaultUserFemalePortrait() {
        return this._defaultUserFemalePortrait;
    }

    public Image getDefaultUserMalePortrait() {
        return this._defaultUserMalePortrait;
    }

    public Image getImage(byte[] bytes) throws PortalException, SystemException {
        return this.getImage(null, bytes);
    }

    public Image getImage(File file) throws PortalException, SystemException {
        try {
            return this.getImage(new FileInputStream(file));
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public Image getImage(InputStream is) throws PortalException, SystemException {
        return this.getImage(is, null);
    }

    public Image getImage(InputStream is, boolean cleanUpStream) throws PortalException, SystemException {
        return this.getImage(is, null, cleanUpStream);
    }

    @Override
    public Image getImage(long imageId) {
        block3: {
            if (imageId > 0L) {
                try {
                    return this.imagePersistence.fetchByPrimaryKey(imageId);
                }
                catch (Exception e2) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)("Unable to get image " + imageId + ": " + e2.getMessage()));
                }
            }
        }
        return null;
    }

    public Image getImageOrDefault(long imageId) {
        Image image = this.getImage(imageId);
        if (image == null) {
            image = this.getDefaultSpacer();
        }
        return image;
    }

    public List<Image> getImages() throws SystemException {
        return this.imagePersistence.findAll();
    }

    public List<Image> getImagesBySize(int size) throws SystemException {
        return this.imagePersistence.findByLtSize(size);
    }

    public boolean isNullOrDefaultSpacer(byte[] bytes) {
        return bytes == null || bytes.length == 0 || Arrays.equals(bytes, this.getDefaultSpacer().getTextObj());
    }

    public Image updateImage(long imageId, byte[] bytes) throws PortalException, SystemException {
        Image image = this.getImage(bytes);
        return this.updateImage(imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
    }

    public Image updateImage(long imageId, byte[] bytes, String type, int height, int width, int size) throws PortalException, SystemException {
        Image image = this.imagePersistence.fetchByPrimaryKey(imageId);
        if (image == null) {
            image = this.imagePersistence.create(imageId);
        }
        image.setModifiedDate(new Date());
        image.setType(type);
        image.setHeight(height);
        image.setWidth(width);
        image.setSize(size);
        Hook hook = HookFactory.getInstance();
        hook.updateImage(image, type, bytes);
        this.imagePersistence.update((BaseModel)image, false);
        WebServerServletTokenUtil.resetToken((long)imageId);
        return image;
    }

    public Image updateImage(long imageId, File file) throws PortalException, SystemException {
        Image image = this.getImage(file);
        return this.updateImage(imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
    }

    public Image updateImage(long imageId, InputStream is) throws PortalException, SystemException {
        Image image = this.getImage(is);
        return this.updateImage(imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
    }

    public Image updateImage(long imageId, InputStream is, boolean cleanUpStream) throws PortalException, SystemException {
        Image image = this.getImage(is, cleanUpStream);
        return this.updateImage(imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
    }

    protected Image getImage(InputStream is, byte[] bytes) throws PortalException, SystemException {
        return this.getImage(is, bytes, true);
    }

    protected Image getImage(InputStream is, byte[] bytes, boolean cleanUpStream) throws PortalException, SystemException {
        block5: {
            try {
                if (is != null) {
                    bytes = FileUtil.getBytes((InputStream)is, (int)-1, (boolean)cleanUpStream);
                }
                if (bytes != null) break block5;
                return null;
            }
            catch (IOException ioe) {
                throw new SystemException((Throwable)ioe);
            }
        }
        ImageBag imageBag = ImageToolUtil.read((byte[])bytes);
        RenderedImage renderedImage = imageBag.getRenderedImage();
        String type = imageBag.getType();
        if (renderedImage == null) {
            throw new ImageTypeException();
        }
        int height = renderedImage.getHeight();
        int width = renderedImage.getWidth();
        int size = bytes.length;
        ImageImpl image = new ImageImpl();
        image.setTextObj(bytes);
        image.setType(type);
        image.setHeight(height);
        image.setWidth(width);
        image.setSize(size);
        return image;
    }
}

