/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.LayoutBranchNameException;
import com.liferay.portal.NoSuchLayoutBranchException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.LayoutBranch;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.LayoutBranchLocalServiceBaseImpl;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutBranchLocalServiceImpl
extends LayoutBranchLocalServiceBaseImpl {
    public LayoutBranch addLayoutBranch(long layoutSetBranchId, long plid, String name, String description, boolean master, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(serviceContext.getUserId());
        LayoutSetBranch layoutSetBranch = this.layoutSetBranchPersistence.findByPrimaryKey(layoutSetBranchId);
        this.validate(0L, layoutSetBranchId, plid, name);
        long layoutBranchId = this.counterLocalService.increment();
        LayoutBranch layoutBranch = this.layoutBranchPersistence.create(layoutBranchId);
        layoutBranch.setGroupId(layoutSetBranch.getGroupId());
        layoutBranch.setCompanyId(user.getCompanyId());
        layoutBranch.setUserId(user.getUserId());
        layoutBranch.setUserName(user.getFullName());
        layoutBranch.setLayoutSetBranchId(layoutSetBranchId);
        layoutBranch.setPlid(plid);
        layoutBranch.setName(name);
        layoutBranch.setDescription(description);
        layoutBranch.setMaster(master);
        this.layoutBranchPersistence.update((BaseModel)layoutBranch, false);
        return layoutBranch;
    }

    public LayoutBranch addLayoutBranch(long layoutRevisionId, String name, String description, boolean master, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutRevision layoutRevision = this.layoutRevisionPersistence.findByPrimaryKey(layoutRevisionId);
        LayoutBranch layoutBranch = this.addLayoutBranch(layoutRevision.getLayoutSetBranchId(), layoutRevision.getPlid(), name, description, master, serviceContext);
        this.layoutRevisionService.addLayoutRevision(layoutBranch.getUserId(), layoutRevision.getLayoutSetBranchId(), layoutBranch.getLayoutBranchId(), 0L, false, layoutRevision.getPlid(), layoutRevision.getLayoutRevisionId(), layoutRevision.isPrivateLayout(), layoutRevision.getName(), layoutRevision.getTitle(), layoutRevision.getDescription(), layoutRevision.getKeywords(), layoutRevision.getRobots(), layoutRevision.getTypeSettings(), layoutRevision.getIconImage(), layoutRevision.getIconImageId(), layoutRevision.getThemeId(), layoutRevision.getColorSchemeId(), layoutRevision.getWapThemeId(), layoutRevision.getWapColorSchemeId(), layoutRevision.getCss(), serviceContext);
        return layoutBranch;
    }

    @Override
    public LayoutBranch deleteLayoutBranch(long layoutBranchId) throws PortalException, SystemException {
        LayoutBranch layoutBranch = this.layoutBranchPersistence.findByPrimaryKey(layoutBranchId);
        this.layoutRevisionLocalService.deleteLayoutRevisions(layoutBranch.getLayoutSetBranchId(), layoutBranchId, layoutBranch.getPlid());
        return this.layoutBranchLocalService.deleteLayoutBranch(layoutBranch);
    }

    public void deleteLayoutSetBranchLayoutBranches(long layoutSetBranchId) throws PortalException, SystemException {
        List layoutBranches = this.layoutBranchPersistence.findByLayoutSetBranchId(layoutSetBranchId);
        for (LayoutBranch layoutBranch : layoutBranches) {
            this.deleteLayoutBranch(layoutBranch.getLayoutBranchId());
        }
    }

    public List<LayoutBranch> getLayoutBranches(long layoutSetBranchId, long plid, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.layoutBranchPersistence.findByL_P(layoutSetBranchId, plid, start, end, orderByComparator);
    }

    public List<LayoutBranch> getLayoutSetBranchLayoutBranches(long layoutSetBranchId) throws SystemException {
        return this.layoutBranchPersistence.findByLayoutSetBranchId(layoutSetBranchId);
    }

    public LayoutBranch getMasterLayoutBranch(long layoutSetBranchId, long plid) throws PortalException, SystemException {
        return this.layoutBranchPersistence.findByL_P_M(layoutSetBranchId, plid, true);
    }

    public LayoutBranch updateLayoutBranch(long layoutBranchId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutBranch layoutBranch = this.layoutBranchPersistence.findByPrimaryKey(layoutBranchId);
        this.validate(layoutBranch.getLayoutBranchId(), layoutBranch.getLayoutSetBranchId(), layoutBranch.getPlid(), name);
        layoutBranch.setName(name);
        layoutBranch.setDescription(description);
        this.layoutBranchPersistence.update((BaseModel)layoutBranch, false);
        return layoutBranch;
    }

    protected void validate(long layoutBranchId, long layoutSetBranchId, long plid, String name) throws PortalException, SystemException {
        if (Validator.isNull((String)name) || name.length() < 4) {
            throw new LayoutBranchNameException(3);
        }
        if (name.length() > 100) {
            throw new LayoutBranchNameException(2);
        }
        try {
            LayoutBranch layoutBranch = this.layoutBranchPersistence.findByL_P_N(layoutSetBranchId, plid, name);
            if (layoutBranch.getLayoutBranchId() != layoutBranchId) {
                throw new LayoutBranchNameException(1);
            }
        }
        catch (NoSuchLayoutBranchException noSuchLayoutBranchException) {}
    }
}

