/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.LayoutFriendlyURLException;
import com.liferay.portal.LayoutHiddenException;
import com.liferay.portal.LayoutNameException;
import com.liferay.portal.LayoutParentLayoutIdException;
import com.liferay.portal.LayoutTypeException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.RequiredLayoutException;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.lar.LayoutExporter;
import com.liferay.portal.lar.LayoutImporter;
import com.liferay.portal.lar.PortletExporter;
import com.liferay.portal.lar.PortletImporter;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutReference;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.LayoutLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.comparator.LayoutComparator;
import com.liferay.portal.util.comparator.LayoutPriorityComparator;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.sites.util.SitesUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutLocalServiceImpl
extends LayoutLocalServiceBaseImpl {
    private static final int _PRIORITY_BUFFER = 1000000;

    public static String getCounterName(long groupId, boolean privateLayout) {
        StringBundler sb = new StringBundler();
        sb.append(Layout.class.getName());
        sb.append("#");
        sb.append(groupId);
        sb.append("#");
        sb.append(privateLayout);
        return sb.toString();
    }

    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long layoutId = this.getNextLayoutId(groupId, privateLayout);
        parentLayoutId = this.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        String name = nameMap.get(LocaleUtil.getDefault());
        friendlyURL = this.getFriendlyURL(groupId, privateLayout, layoutId, name, friendlyURL);
        int priority = this.getNextPriority(groupId, privateLayout, parentLayoutId, null, -1);
        this.validate(groupId, privateLayout, layoutId, parentLayoutId, name, type, hidden, friendlyURL);
        Date now = new Date();
        long plid = this.counterLocalService.increment();
        Layout layout = this.layoutPersistence.create(plid);
        layout.setUuid(serviceContext.getUuid());
        layout.setGroupId(groupId);
        layout.setCompanyId(user.getCompanyId());
        layout.setCreateDate(serviceContext.getCreateDate(now));
        layout.setModifiedDate(serviceContext.getModifiedDate(now));
        layout.setPrivateLayout(privateLayout);
        layout.setLayoutId(layoutId);
        layout.setParentLayoutId(parentLayoutId);
        layout.setNameMap(nameMap);
        layout.setTitleMap(titleMap);
        layout.setDescriptionMap(descriptionMap);
        layout.setKeywordsMap(keywordsMap);
        layout.setRobotsMap(robotsMap);
        layout.setType(type);
        layout.setHidden(hidden);
        layout.setFriendlyURL(friendlyURL);
        layout.setPriority(priority);
        boolean layoutUpdateable = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutUpdateable", (boolean)true);
        if (!layoutUpdateable) {
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            typeSettingsProperties.put("layoutUpdateable", String.valueOf(layoutUpdateable));
            layout.setTypeSettingsProperties(typeSettingsProperties);
        }
        String layoutPrototypeUuid = ParamUtil.getString((ServiceContext)serviceContext, (String)"layoutPrototypeUuid");
        boolean layoutPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutPrototypeLinkEnabled", (boolean)PropsValues.LAYOUT_PROTOTYPE_LINK_ENABLED_DEFAULT);
        if (Validator.isNotNull((String)layoutPrototypeUuid)) {
            layout.setLayoutPrototypeUuid(layoutPrototypeUuid);
            layout.setLayoutPrototypeLinkEnabled(layoutPrototypeLinkEnabled);
        }
        if (type.equals("portlet")) {
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.LAYOUT_DEFAULT_TEMPLATE_ID, false);
        }
        this.layoutPersistence.update((BaseModel)layout, false);
        if (Validator.isNotNull((String)layoutPrototypeUuid) && !layoutPrototypeLinkEnabled) {
            LayoutPrototype layoutPrototype = this.layoutPrototypeLocalService.getLayoutPrototypeByUuid(layoutPrototypeUuid);
            try {
                SitesUtil.applyLayoutPrototype(layoutPrototype, layout, layoutPrototypeLinkEnabled);
            }
            catch (PortalException pe) {
                throw pe;
            }
            catch (SystemException se) {
                throw se;
            }
            catch (Exception e2) {
                throw new SystemException((Throwable)e2);
            }
        }
        boolean addGroupPermissions = true;
        Group group = this.groupLocalService.getGroup(groupId);
        if (privateLayout && group.isUser()) {
            addGroupPermissions = false;
        }
        boolean addGuestPermissions = false;
        if (!privateLayout || type.equals("control_panel") || group.isLayoutSetPrototype()) {
            addGuestPermissions = true;
        }
        this.resourceLocalService.addResources(user.getCompanyId(), groupId, user.getUserId(), Layout.class.getName(), layout.getPlid(), false, addGroupPermissions, addGuestPermissions);
        this.groupLocalService.updateSite(groupId, true);
        this.layoutSetLocalService.updatePageCount(groupId, privateLayout);
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        layout.setLayoutSet(layoutSet);
        ExpandoBridge expandoBridge = layout.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        if (PropsValues.LAYOUT_COMMENTS_ENABLED) {
            this.mbMessageLocalService.addDiscussionMessage(userId, user.getFullName(), groupId, Layout.class.getName(), plid, 1);
        }
        return layout;
    }

    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException, SystemException {
        HashMap<Locale, String> localeNamesMap = new HashMap<Locale, String>();
        Locale defaultLocale = LocaleUtil.getDefault();
        localeNamesMap.put(defaultLocale, name);
        return this.addLayout(userId, groupId, privateLayout, parentLayoutId, localeNamesMap, new HashMap<Locale, String>(), new HashMap<Locale, String>(), new HashMap<Locale, String>(), new HashMap<Locale, String>(), type, hidden, friendlyURL, serviceContext);
    }

    public void deleteLayout(Layout layout, boolean updateLayoutSet, ServiceContext serviceContext) throws PortalException, SystemException {
        Layout firstLayout;
        List rootLayouts;
        if (layout.getParentLayoutId() == 0L && (rootLayouts = this.layoutPersistence.findByG_P_P(layout.getGroupId(), layout.isPrivateLayout(), 0L, 0, 2)).size() > 1 && (firstLayout = (Layout)rootLayouts.get(0)).getLayoutId() == layout.getLayoutId()) {
            Layout secondLayout = (Layout)rootLayouts.get(1);
            this.validateFirstLayout(secondLayout.getType());
        }
        List childLayouts = this.layoutPersistence.findByG_P_P(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        for (Layout childLayout : childLayouts) {
            this.deleteLayout(childLayout, updateLayoutSet, serviceContext);
        }
        this.portletPreferencesLocalService.deletePortletPreferences(0L, 3, layout.getPlid());
        this.subscriptionLocalService.deleteSubscriptions(layout.getCompanyId(), Layout.class.getName(), layout.getPlid());
        this.ratingsStatsLocalService.deleteStats(Layout.class.getName(), layout.getPlid());
        this.mbMessageLocalService.deleteDiscussionMessages(Layout.class.getName(), layout.getPlid());
        this.journalArticleLocalService.deleteLayoutArticleReferences(layout.getGroupId(), layout.getUuid());
        this.journalContentSearchLocalService.deleteLayoutContentSearches(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        this.expandoValueLocalService.deleteValues(Layout.class.getName(), layout.getPlid());
        this.imageLocalService.deleteImage(layout.getIconImageId());
        Group scopeGroup = layout.getScopeGroup();
        if (scopeGroup != null) {
            this.groupLocalService.deleteGroup(scopeGroup.getGroupId());
        }
        String primKey = String.valueOf(layout.getPlid()) + "_LAYOUT_" + "%";
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            List resourcePermissions = this.resourcePermissionPersistence.findByC_P(layout.getCompanyId(), primKey);
            for (ResourcePermission resourcePermission : resourcePermissions) {
                this.resourcePermissionLocalService.deleteResourcePermission(resourcePermission);
            }
        } else {
            List resources = this.resourceFinder.findByC_P(layout.getCompanyId(), primKey);
            for (Resource resource : resources) {
                this.resourceLocalService.deleteResource(resource);
            }
        }
        this.resourceLocalService.deleteResource(layout.getCompanyId(), Layout.class.getName(), 4, layout.getPlid());
        this.layoutPersistence.remove((BaseModel)layout);
        if (updateLayoutSet) {
            this.layoutSetLocalService.updatePageCount(layout.getGroupId(), layout.isPrivateLayout());
        }
    }

    public void deleteLayout(long groupId, boolean privateLayout, long layoutId, ServiceContext serviceContext) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        this.deleteLayout(layout, true, serviceContext);
    }

    public void deleteLayout(long plid, ServiceContext serviceContext) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        this.deleteLayout(layout, true, serviceContext);
    }

    public void deleteLayouts(long groupId, boolean privateLayout, ServiceContext serviceContext) throws PortalException, SystemException {
        List layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, 0L);
        for (Layout layout : layouts) {
            try {
                this.deleteLayout(layout, false, serviceContext);
            }
            catch (NoSuchLayoutException noSuchLayoutException) {}
        }
        this.layoutSetLocalService.updatePageCount(groupId, privateLayout);
        this.counterLocalService.reset(LayoutLocalServiceImpl.getCounterName(groupId, privateLayout));
    }

    public byte[] exportLayouts(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        File file = this.exportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
        try {
            byte[] byArray = FileUtil.getBytes((File)file);
            return byArray;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            file.delete();
        }
    }

    public byte[] exportLayouts(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        return this.exportLayouts(groupId, privateLayout, null, parameterMap, startDate, endDate);
    }

    public File exportLayoutsAsFile(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            LayoutExporter layoutExporter = new LayoutExporter();
            return layoutExporter.exportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public byte[] exportPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        File file = this.exportPortletInfoAsFile(plid, groupId, portletId, parameterMap, startDate, endDate);
        try {
            byte[] byArray = FileUtil.getBytes((File)file);
            return byArray;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            file.delete();
        }
    }

    public File exportPortletInfoAsFile(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            PortletExporter portletExporter = new PortletExporter();
            return portletExporter.exportPortletInfoAsFile(plid, groupId, portletId, parameterMap, startDate, endDate);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public Layout fetchFirstLayout(long groupId, boolean privateLayout, long parentLayoutId) throws SystemException {
        return this.layoutPersistence.fetchByG_P_P_First(groupId, privateLayout, parentLayoutId, (OrderByComparator)new LayoutPriorityComparator());
    }

    public Layout fetchLayoutByUuidAndGroupId(String uuid, long groupId) throws SystemException {
        return this.layoutPersistence.fetchByUUID_G(uuid, groupId);
    }

    public long getDefaultPlid(long groupId) throws SystemException {
        List layouts;
        if (groupId > 0L && (layouts = this.layoutPersistence.findByGroupId(groupId, 0, 1)).size() > 0) {
            Layout layout = (Layout)layouts.get(0);
            return layout.getPlid();
        }
        return 0L;
    }

    public long getDefaultPlid(long groupId, boolean privateLayout) throws SystemException {
        List layouts;
        if (groupId > 0L && (layouts = this.layoutPersistence.findByG_P(groupId, privateLayout, 0, 1)).size() > 0) {
            Layout layout = (Layout)layouts.get(0);
            return layout.getPlid();
        }
        return 0L;
    }

    public long getDefaultPlid(long groupId, boolean privateLayout, String portletId) throws PortalException, SystemException {
        if (groupId > 0L) {
            List layouts = this.layoutPersistence.findByG_P(groupId, privateLayout);
            for (Layout layout : layouts) {
                LayoutTypePortlet layoutTypePortlet;
                if (!layout.isTypePortlet() || !(layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType()).hasPortletId(portletId)) continue;
                return layout.getPlid();
            }
        }
        return 0L;
    }

    public Layout getFriendlyURLLayout(long groupId, boolean privateLayout, String friendlyURL) throws PortalException, SystemException {
        if (Validator.isNull((String)friendlyURL)) {
            throw new NoSuchLayoutException();
        }
        Layout layout = this.layoutPersistence.fetchByG_P_F(groupId, privateLayout, friendlyURL = this.getFriendlyURL(friendlyURL));
        if (layout == null && friendlyURL.startsWith("/") && Validator.isNumber((String)friendlyURL.substring(1))) {
            long layoutId = GetterUtil.getLong((String)friendlyURL.substring(1));
            layout = this.layoutPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
        }
        if (layout == null) {
            throw new NoSuchLayoutException();
        }
        return layout;
    }

    public Layout getLayout(long groupId, boolean privateLayout, long layoutId) throws PortalException, SystemException {
        return this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
    }

    public Layout getLayoutByIconImageId(long iconImageId) throws PortalException, SystemException {
        return this.layoutPersistence.findByIconImageId(iconImageId);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout) throws SystemException {
        return this.layoutPersistence.findByG_P(groupId, privateLayout);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId) throws SystemException {
        return this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, int start, int end) throws SystemException {
        return this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId, start, end);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long[] layoutIds) throws PortalException, SystemException {
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        long[] lArray = layoutIds;
        int n = layoutIds.length;
        int n2 = 0;
        while (n2 < n) {
            long layoutId = lArray[n2];
            Layout layout = this.getLayout(groupId, privateLayout, layoutId);
            layouts.add(layout);
            ++n2;
        }
        return layouts;
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, String type) throws SystemException {
        return this.layoutPersistence.findByG_P_T(groupId, privateLayout, type);
    }

    public LayoutReference[] getLayouts(long companyId, String portletId, String preferencesKey, String preferencesValue) throws SystemException {
        List layoutReferences = this.layoutFinder.findByC_P_P(companyId, portletId, preferencesKey, preferencesValue);
        return layoutReferences.toArray(new LayoutReference[layoutReferences.size()]);
    }

    public int getLayoutsByLayoutPrototypeUuidCount(String layoutPrototypeUuid) throws SystemException {
        return this.layoutPersistence.countByLayoutPrototypeUuid(layoutPrototypeUuid);
    }

    public int getLayoutsCount(Group group, boolean privateLayout) throws PortalException, SystemException {
        List userGroups;
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(group.getGroupId(), privateLayout);
        int count = layoutSet.getPageCount();
        if (PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE && group.isUser() && !(userGroups = this.userPersistence.getUserGroups(group.getClassPK())).isEmpty()) {
            long userGroupClassNameId = this.classNameLocalService.getClassNameId(UserGroup.class);
            for (UserGroup userGroup : userGroups) {
                Group userGroupGroup = this.groupPersistence.findByC_C_C(group.getCompanyId(), userGroupClassNameId, userGroup.getUserGroupId());
                layoutSet = this.layoutSetPersistence.findByG_P(userGroupGroup.getGroupId(), privateLayout);
                count += layoutSet.getPageCount();
            }
        }
        return count;
    }

    public int getLayoutsCount(User user, boolean privateLayout) throws PortalException, SystemException {
        long classNameId = this.classNameLocalService.getClassNameId(User.class);
        Group group = this.groupPersistence.findByC_C_C(user.getCompanyId(), classNameId, user.getUserId());
        return this.getLayoutsCount(group, privateLayout);
    }

    public long getNextLayoutId(long groupId, boolean privateLayout) throws SystemException {
        List layouts;
        long nextLayoutId = this.counterLocalService.increment(LayoutLocalServiceImpl.getCounterName(groupId, privateLayout));
        if (nextLayoutId == 1L && !(layouts = this.layoutPersistence.findByG_P(groupId, privateLayout, 0, 1, (OrderByComparator)new LayoutComparator())).isEmpty()) {
            Layout layout = (Layout)layouts.get(0);
            nextLayoutId = layout.getLayoutId() + 1L;
            this.counterLocalService.reset(LayoutLocalServiceImpl.getCounterName(groupId, privateLayout), nextLayoutId);
        }
        return nextLayoutId;
    }

    public List<Layout> getNullFriendlyURLLayouts() throws SystemException {
        return this.layoutFinder.findByNullFriendlyURL();
    }

    public List<Layout> getScopeGroupLayouts(long groupId, boolean privateLayout) throws SystemException {
        return this.layoutFinder.findByScopeGroup(groupId, privateLayout);
    }

    public boolean hasLayouts(Group group, boolean privateLayout) throws PortalException, SystemException {
        List userGroups;
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(group.getGroupId(), privateLayout);
        if (layoutSet.getPageCount() > 0) {
            return true;
        }
        if (PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE && group.isUser() && !(userGroups = this.userPersistence.getUserGroups(group.getClassPK())).isEmpty()) {
            long userGroupClassNameId = this.classNameLocalService.getClassNameId(UserGroup.class);
            for (UserGroup userGroup : userGroups) {
                Group userGroupGroup = this.groupPersistence.findByC_C_C(group.getCompanyId(), userGroupClassNameId, userGroup.getUserGroupId());
                layoutSet = this.layoutSetPersistence.findByG_P(userGroupGroup.getGroupId(), privateLayout);
                if (layoutSet.getPageCount() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasLayouts(long groupId, boolean privateLayout, long parentLayoutId) throws SystemException {
        return this.layoutPersistence.countByG_P_P(groupId, privateLayout, parentLayoutId) > 0;
    }

    public boolean hasLayouts(User user, boolean privateLayout) throws PortalException, SystemException {
        long classNameId = this.classNameLocalService.getClassNameId(User.class);
        Group group = this.groupPersistence.findByC_C_C(user.getCompanyId(), classNameId, user.getUserId());
        return this.hasLayouts(group, privateLayout);
    }

    public boolean hasLayoutSetPrototypeLayout(long layoutSetPrototypeId, String layoutUuid) throws PortalException, SystemException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypeLocalService.getLayoutSetPrototype(layoutSetPrototypeId);
        return this.hasLayoutSetPrototypeLayout(layoutSetPrototype, layoutUuid);
    }

    public boolean hasLayoutSetPrototypeLayout(String layoutSetPrototypeUuid, String layoutUuid) throws PortalException, SystemException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypeLocalService.getLayoutSetPrototypeByUuid(layoutSetPrototypeUuid);
        return this.hasLayoutSetPrototypeLayout(layoutSetPrototype, layoutUuid);
    }

    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, byte[] bytes) throws PortalException, SystemException {
        this.importLayouts(userId, groupId, privateLayout, parameterMap, (InputStream)new UnsyncByteArrayInputStream(bytes));
    }

    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        try {
            LayoutImporter layoutImporter = new LayoutImporter();
            layoutImporter.importLayouts(userId, groupId, privateLayout, parameterMap, file);
        }
        catch (PortalException pe) {
            Throwable cause = pe.getCause();
            if (cause instanceof LocaleException) {
                throw (PortalException)cause;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        try {
            File file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)is);
            this.importLayouts(userId, groupId, privateLayout, parameterMap, file);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void importPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        try {
            PortletImporter portletImporter = new PortletImporter();
            portletImporter.importPortletInfo(userId, plid, groupId, portletId, parameterMap, file);
        }
        catch (PortalException pe) {
            Throwable cause = pe.getCause();
            if (cause instanceof LocaleException) {
                throw (PortalException)cause;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public void importPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        try {
            File file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)is);
            this.importPortletInfo(userId, plid, groupId, portletId, parameterMap, file);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void setLayouts(long groupId, boolean privateLayout, long parentLayoutId, long[] layoutIds, ServiceContext serviceContext) throws PortalException, SystemException {
        if (layoutIds == null) {
            return;
        }
        if (parentLayoutId == 0L) {
            if (layoutIds.length < 1) {
                throw new RequiredLayoutException(1);
            }
            Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutIds[0]);
            if (!PortalUtil.isLayoutFirstPageable((String)layout.getType())) {
                throw new RequiredLayoutException(3);
            }
            if (layout.isHidden()) {
                throw new RequiredLayoutException(4);
            }
        }
        LinkedHashSet<Long> layoutIdsSet = new LinkedHashSet<Long>();
        long[] lArray = layoutIds;
        int n = layoutIds.length;
        int n2 = 0;
        while (n2 < n) {
            long layoutId = lArray[n2];
            layoutIdsSet.add(layoutId);
            ++n2;
        }
        HashSet<Long> newLayoutIdsSet = new HashSet<Long>();
        List layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId);
        for (Layout layout : layouts) {
            if (!layoutIdsSet.contains(layout.getLayoutId())) {
                this.deleteLayout(layout, true, serviceContext);
                continue;
            }
            newLayoutIdsSet.add(layout.getLayoutId());
        }
        int priority = 0;
        Iterator iterator = layoutIdsSet.iterator();
        while (iterator.hasNext()) {
            long layoutId = (Long)iterator.next();
            Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
            layout.setPriority(priority++);
            this.layoutPersistence.update((BaseModel)layout, false);
        }
        this.layoutSetLocalService.updatePageCount(groupId, privateLayout);
    }

    public Layout updateFriendlyURL(long plid, String friendlyURL) throws PortalException, SystemException {
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        friendlyURL = this.getFriendlyURL(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), "", friendlyURL);
        this.validateFriendlyURL(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), friendlyURL);
        layout.setModifiedDate(now);
        layout.setFriendlyURL(friendlyURL);
        this.layoutPersistence.update((BaseModel)layout, false);
        return layout;
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, String friendlyURL, Boolean iconImage, byte[] iconBytes, ServiceContext serviceContext) throws PortalException, SystemException {
        parentLayoutId = this.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        String name = nameMap.get(LocaleUtil.getDefault());
        friendlyURL = this.getFriendlyURL(groupId, privateLayout, layoutId, "", friendlyURL);
        this.validate(groupId, privateLayout, layoutId, parentLayoutId, name, type, hidden, friendlyURL);
        this.validateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        List modifiedLocales = LocalizationUtil.getModifiedLocales((Map)layout.getNameMap(), nameMap);
        if (parentLayoutId != layout.getParentLayoutId()) {
            int priority = this.getNextPriority(groupId, privateLayout, parentLayoutId, layout.getSourcePrototypeLayoutUuid(), -1);
            layout.setPriority(priority);
        }
        layout.setModifiedDate(serviceContext.getModifiedDate(now));
        layout.setParentLayoutId(parentLayoutId);
        layout.setNameMap(nameMap);
        layout.setTitleMap(titleMap);
        layout.setDescriptionMap(descriptionMap);
        layout.setKeywordsMap(keywordsMap);
        layout.setRobotsMap(robotsMap);
        layout.setType(type);
        layout.setHidden(hidden);
        layout.setFriendlyURL(friendlyURL);
        if (iconImage != null) {
            long iconImageId;
            layout.setIconImage(iconImage.booleanValue());
            if (iconImage.booleanValue() && (iconImageId = layout.getIconImageId()) <= 0L) {
                iconImageId = this.counterLocalService.increment();
                layout.setIconImageId(iconImageId);
            }
        }
        boolean layoutUpdateable = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutUpdateable", (boolean)true);
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        typeSettingsProperties.put("layoutUpdateable", String.valueOf(layoutUpdateable));
        layout.setTypeSettingsProperties(typeSettingsProperties);
        String layoutPrototypeUuid = ParamUtil.getString((ServiceContext)serviceContext, (String)"layoutPrototypeUuid");
        boolean layoutPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutPrototypeLinkEnabled");
        if (Validator.isNotNull((String)layoutPrototypeUuid)) {
            layout.setLayoutPrototypeUuid(layoutPrototypeUuid);
            layout.setLayoutPrototypeLinkEnabled(layoutPrototypeLinkEnabled);
        }
        this.layoutPersistence.update((BaseModel)layout, false);
        if (iconImage != null) {
            if (!iconImage.booleanValue()) {
                this.imageLocalService.deleteImage(layout.getIconImageId());
            } else if (iconBytes != null && iconBytes.length > 0) {
                this.imageLocalService.updateImage(layout.getIconImageId(), iconBytes);
            }
        }
        if (!modifiedLocales.isEmpty()) {
            this.updateScopedPortletNames(groupId, privateLayout, layoutId, nameMap, modifiedLocales);
        }
        ExpandoBridge expandoBridge = layout.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        return layout;
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException, SystemException {
        Date now = new Date();
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.fastLoad(typeSettings);
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        layout.setModifiedDate(now);
        layout.setTypeSettings(typeSettingsProperties.toString());
        this.layoutPersistence.update((BaseModel)layout, false);
        return layout;
    }

    public Layout updateLookAndFeel(long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css, boolean wapTheme) throws PortalException, SystemException {
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        layout.setModifiedDate(now);
        if (wapTheme) {
            layout.setWapThemeId(themeId);
            layout.setWapColorSchemeId(colorSchemeId);
        } else {
            layout.setThemeId(themeId);
            layout.setColorSchemeId(colorSchemeId);
            layout.setCss(css);
        }
        this.layoutPersistence.update((BaseModel)layout, false);
        return layout;
    }

    public Layout updateName(Layout layout, String name, String languageId) throws PortalException, SystemException {
        Date now = new Date();
        this.validateName(name, languageId);
        layout.setModifiedDate(now);
        layout.setName(name, LocaleUtil.fromLanguageId((String)languageId));
        this.layoutPersistence.update((BaseModel)layout, false);
        return layout;
    }

    public Layout updateName(long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        return this.layoutLocalService.updateName(layout, name, languageId);
    }

    public Layout updateName(long plid, String name, String languageId) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        return this.layoutLocalService.updateName(layout, name, languageId);
    }

    public Layout updateParentLayoutId(long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException, SystemException {
        parentLayoutId = this.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        this.validateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        if (parentLayoutId != layout.getParentLayoutId()) {
            int priority = this.getNextPriority(groupId, privateLayout, parentLayoutId, layout.getSourcePrototypeLayoutUuid(), -1);
            layout.setPriority(priority);
        }
        layout.setModifiedDate(now);
        layout.setParentLayoutId(parentLayoutId);
        this.layoutPersistence.update((BaseModel)layout, false);
        return layout;
    }

    public Layout updateParentLayoutId(long plid, long parentPlid) throws PortalException, SystemException {
        Layout parentLayout;
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        long parentLayoutId = 0L;
        if (parentPlid > 0L && (parentLayout = this.layoutPersistence.fetchByPrimaryKey(parentPlid)) != null) {
            parentLayoutId = parentLayout.getLayoutId();
        }
        parentLayoutId = this.getParentLayoutId(layout.getGroupId(), layout.isPrivateLayout(), parentLayoutId);
        this.validateParentLayoutId(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), parentLayoutId);
        if (parentLayoutId != layout.getParentLayoutId()) {
            int priority = this.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), parentLayoutId, layout.getSourcePrototypeLayoutUuid(), -1);
            layout.setPriority(priority);
        }
        layout.setModifiedDate(now);
        layout.setParentLayoutId(parentLayoutId);
        this.layoutPersistence.update((BaseModel)layout, false);
        return layout;
    }

    public void updatePriorities(long groupId, boolean privateLayout) throws PortalException, SystemException {
        List layouts = this.layoutPersistence.findByG_P(groupId, privateLayout);
        for (Layout layout : layouts) {
            int nextPriority = this.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), layout.getSourcePrototypeLayoutUuid(), layout.getPriority());
            layout.setPriority(nextPriority);
            this.layoutPersistence.update((BaseModel)layout, false);
        }
    }

    public Layout updatePriority(Layout layout, int priority) throws SystemException {
        if (layout.getPriority() == priority) {
            return layout;
        }
        Date now = new Date();
        layout.setModifiedDate(now);
        int oldPriority = layout.getPriority();
        int nextPriority = this.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), layout.getSourcePrototypeLayoutUuid(), priority);
        layout.setPriority(nextPriority);
        this.layoutPersistence.update((BaseModel)layout, false);
        List layouts = this.layoutPersistence.findByG_P_P(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId());
        boolean lessThan = false;
        if (oldPriority < priority) {
            lessThan = true;
        }
        layouts = ListUtil.sort((List)layouts, (Comparator)new LayoutPriorityComparator(layout, lessThan));
        priority = 0;
        for (Layout curLayout : layouts) {
            curLayout.setModifiedDate(now);
            int curNextPriority = this.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), curLayout.getSourcePrototypeLayoutUuid(), priority++);
            curLayout.setPriority(curNextPriority);
            this.layoutPersistence.update((BaseModel)curLayout, false);
            if (!curLayout.equals(layout)) continue;
            layout = curLayout;
        }
        return layout;
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, int priority) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        return this.updatePriority(layout, priority);
    }

    public Layout updatePriority(long plid, int priority) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        return this.updatePriority(layout, priority);
    }

    public void updateScopedPortletNames(long groupId, boolean privateLayout, long layoutId, Map<Locale, String> nameMap, List<Locale> nameMapModifiedLocales) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        DynamicQuery portletPreferencesDynamicQuery = DynamicQueryFactoryUtil.forClass(com.liferay.portal.model.PortletPreferences.class, (String)"PortletPreferences", (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Property plidProperty = PropertyFactoryUtil.forName((String)"plid");
        DynamicQuery layoutDynamicQuery = DynamicQueryFactoryUtil.forClass(Layout.class, (String)"Layout", (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Projection plidProjection = ProjectionFactoryUtil.property((String)"plid");
        layoutDynamicQuery.setProjection(plidProjection);
        Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
        layoutDynamicQuery.add(groupIdProperty.eq((Object)groupId));
        Property privateLayoutProperty = PropertyFactoryUtil.forName((String)"privateLayout");
        layoutDynamicQuery.add(privateLayoutProperty.eq((Object)privateLayout));
        portletPreferencesDynamicQuery.add(plidProperty.in(layoutDynamicQuery));
        Disjunction junction = RestrictionsFactoryUtil.disjunction();
        List scopablePortlets = this.portletLocalService.getScopablePortlets();
        for (Portlet scopablePortlet : scopablePortlets) {
            Criterion criterion;
            if (scopablePortlet.isInstanceable()) {
                criterion = RestrictionsFactoryUtil.like((String)"portletId", (Object)(String.valueOf(scopablePortlet.getPortletId()) + "_INSTANCE_" + "%"));
                junction.add(criterion);
                continue;
            }
            criterion = RestrictionsFactoryUtil.eq((String)"portletId", (Object)scopablePortlet.getPortletId());
            junction.add(criterion);
        }
        portletPreferencesDynamicQuery.add((Criterion)junction);
        List portletPreferencesList = this.portletPreferencesLocalService.dynamicQuery(portletPreferencesDynamicQuery);
        for (com.liferay.portal.model.PortletPreferences portletPreferences : portletPreferencesList) {
            Layout curLayout;
            PortletPreferences jxPreferences;
            String scopeLayoutUuid;
            if (portletPreferences.getPortletId() == null || !(scopeLayoutUuid = GetterUtil.getString((String)(jxPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)(curLayout = this.layoutPersistence.findByPrimaryKey(portletPreferences.getPlid())), (String)portletPreferences.getPortletId())).getValue("lfrScopeLayoutUuid", null))).equals(layout.getUuid())) continue;
            for (Locale locale : nameMapModifiedLocales) {
                String languageId = LanguageUtil.getLanguageId((Locale)locale);
                String portletTitle = PortalUtil.getPortletTitle((String)PortletConstants.getRootPortletId((String)portletPreferences.getPortletId()), (String)languageId);
                String newPortletTitle = PortalUtil.getNewPortletTitle((String)portletTitle, (String)curLayout.getName(languageId), (String)nameMap.get(locale));
                if (newPortletTitle.equals(portletTitle)) continue;
                try {
                    jxPreferences.setValue("portletSetupTitle_" + languageId, newPortletTitle);
                    jxPreferences.setValue("portletSetupUseCustomTitle", Boolean.TRUE.toString());
                    jxPreferences.store();
                }
                catch (IOException ioe) {
                    throw new SystemException((Throwable)ioe);
                }
                catch (PortletException pe) {
                    throw new SystemException((Throwable)pe);
                }
            }
        }
    }

    public void updateScopedPortletNames(long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException, SystemException {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        map.put(locale, name);
        ArrayList<Locale> locales = new ArrayList<Locale>();
        locales.add(locale);
        this.updateScopedPortletNames(groupId, privateLayout, layoutId, map, locales);
    }

    protected String getFriendlyURL(long groupId, boolean privateLayout, long layoutId, String name, String friendlyURL) throws PortalException, SystemException {
        if (Validator.isNull((String)(friendlyURL = this.getFriendlyURL(friendlyURL)))) {
            String originalFriendlyURL = friendlyURL = "/" + this.getFriendlyURL(name);
            int i2 = 1;
            while (true) {
                try {
                    this.validateFriendlyURL(groupId, privateLayout, layoutId, friendlyURL);
                }
                catch (LayoutFriendlyURLException lfurle) {
                    int type = lfurle.getType();
                    if (type != 6) {
                        friendlyURL = "/" + layoutId;
                        break;
                    }
                    friendlyURL = String.valueOf(originalFriendlyURL) + i2;
                    ++i2;
                    continue;
                }
                break;
            }
        }
        return friendlyURL;
    }

    protected String getFriendlyURL(String friendlyURL) {
        return FriendlyURLNormalizerUtil.normalize((String)friendlyURL);
    }

    protected int getNextPriority(long groupId, boolean privateLayout, long parentLayoutId, String sourcePrototypeLayoutUuid, int defaultPriority) throws SystemException {
        try {
            LayoutSet layoutSet;
            int priority = defaultPriority;
            if (priority < 0) {
                Layout layout = this.layoutPersistence.findByG_P_P_First(groupId, privateLayout, parentLayoutId, (OrderByComparator)new LayoutPriorityComparator(false));
                priority = layout.getPriority() + 1;
            }
            if (priority < 1000000 && Validator.isNull((String)sourcePrototypeLayoutUuid) && Validator.isNotNull((String)(layoutSet = this.layoutSetPersistence.fetchByG_P(groupId, privateLayout)).getLayoutSetPrototypeUuid())) {
                priority += 1000000;
            }
            return priority;
        }
        catch (NoSuchLayoutException noSuchLayoutException) {
            return 0;
        }
    }

    protected long getParentLayoutId(long groupId, boolean privateLayout, long parentLayoutId) throws SystemException {
        Layout parentLayout;
        if (parentLayoutId != 0L && (parentLayout = this.layoutPersistence.fetchByG_P_L(groupId, privateLayout, parentLayoutId)) == null) {
            parentLayoutId = 0L;
        }
        return parentLayoutId;
    }

    protected boolean hasLayoutSetPrototypeLayout(LayoutSetPrototype layoutSetPrototype, String layoutUuid) throws PortalException, SystemException {
        Group group = layoutSetPrototype.getGroup();
        Layout layout = this.layoutPersistence.fetchByUUID_G(layoutUuid, group.getGroupId());
        return layout != null;
    }

    protected void validate(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, String name, String type, boolean hidden, String friendlyURL) throws PortalException, SystemException {
        this.validateName(name);
        boolean firstLayout = false;
        if (parentLayoutId == 0L) {
            List layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId, 0, 1);
            if (layouts.size() == 0) {
                firstLayout = true;
            } else {
                long firstLayoutId = ((Layout)layouts.get(0)).getLayoutId();
                if (firstLayoutId == layoutId) {
                    firstLayout = true;
                }
            }
        }
        if (firstLayout) {
            this.validateFirstLayout(type);
        }
        if (!PortalUtil.isLayoutParentable((String)type) && this.layoutPersistence.countByG_P_P(groupId, privateLayout, layoutId) > 0) {
            throw new LayoutTypeException(1);
        }
        this.validateFriendlyURL(groupId, privateLayout, layoutId, friendlyURL);
    }

    protected void validateFirstLayout(String type) throws PortalException {
        if (Validator.isNull((String)type) || !PortalUtil.isLayoutFirstPageable((String)type)) {
            LayoutTypeException lte = new LayoutTypeException(2);
            lte.setLayoutType(type);
            throw lte;
        }
    }

    protected void validateFriendlyURL(long groupId, boolean privateLayout, long layoutId, String friendlyURL) throws PortalException, SystemException {
        if (Validator.isNull((String)friendlyURL)) {
            return;
        }
        int exceptionType = LayoutImpl.validateFriendlyURL(friendlyURL);
        if (exceptionType != -1) {
            throw new LayoutFriendlyURLException(exceptionType);
        }
        Layout layout = this.layoutPersistence.fetchByG_P_F(groupId, privateLayout, friendlyURL);
        if (layout != null && layout.getLayoutId() != layoutId) {
            throw new LayoutFriendlyURLException(6);
        }
        LayoutImpl.validateFriendlyURLKeyword(friendlyURL);
        String layoutIdFriendlyURL = friendlyURL.substring(1);
        if (Validator.isNumber((String)layoutIdFriendlyURL) && !layoutIdFriendlyURL.equals(String.valueOf(layoutId))) {
            LayoutFriendlyURLException lfurle = new LayoutFriendlyURLException(8);
            lfurle.setKeywordConflict(layoutIdFriendlyURL);
            throw lfurle;
        }
    }

    protected void validateName(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new LayoutNameException();
        }
    }

    protected void validateName(String name, String languageId) throws PortalException {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        if (defaultLanguageId.equals(languageId)) {
            this.validateName(name);
        }
    }

    protected void validateParentLayoutId(long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        if (parentLayoutId != layout.getParentLayoutId()) {
            List layouts;
            long firstLayoutId;
            if (parentLayoutId == 0L) {
                return;
            }
            Layout parentLayout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, parentLayoutId);
            if (!PortalUtil.isLayoutParentable((Layout)parentLayout)) {
                throw new LayoutParentLayoutIdException(1);
            }
            if (PortalUtil.isLayoutDescendant((Layout)layout, (long)parentLayoutId)) {
                throw new LayoutParentLayoutIdException(2);
            }
            if (layout.getParentLayoutId() == 0L && (firstLayoutId = ((Layout)(layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, 0L, 0, 2)).get(0)).getLayoutId()) == layoutId) {
                Layout secondLayout = (Layout)layouts.get(1);
                try {
                    this.validateFirstLayout(secondLayout.getType());
                }
                catch (LayoutHiddenException layoutHiddenException) {
                    throw new LayoutParentLayoutIdException(4);
                }
                catch (LayoutTypeException layoutTypeException) {
                    throw new LayoutParentLayoutIdException(3);
                }
            }
        }
    }
}

