/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.impl.VirtualLayout;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.sites.util.SitesUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.annotation.Order;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Order(value=2)
public class LayoutLocalServiceVirtualLayoutsAdvice
implements MethodInterceptor {
    private static final Class<?>[] _TYPES_L = new Class[]{Long.TYPE};
    private static final Class<?>[] _TYPES_L_B_L = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE};
    private static final Class<?>[] _TYPES_L_B_L_B_I_I = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE};
    private static Log _log = LogFactoryUtil.getLog(LayoutLocalServiceVirtualLayoutsAdvice.class);
    private static ThreadLocal<Long> _virtualLayoutTargetGroupId = new AutoResetThreadLocal(LayoutLocalServiceVirtualLayoutsAdvice.class + "._virtualLayoutTargetGroupId", (Object)0L);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return methodInvocation.proceed();
        }
        Method method = methodInvocation.getMethod();
        String methodName = method.getName();
        Object[] arguments = methodInvocation.getArguments();
        Object[] parameterTypes = method.getParameterTypes();
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        if (methodName.equals("getLayout") && (Arrays.equals(parameterTypes, _TYPES_L) || Arrays.equals(parameterTypes, _TYPES_L_B_L))) {
            Layout layout = (Layout)methodInvocation.proceed();
            if (Validator.isNull((String)layout.getLayoutPrototypeUuid()) && Validator.isNull((String)layout.getSourcePrototypeLayoutUuid())) {
                return layout;
            }
            Group group = layout.getGroup();
            LayoutSet layoutSet = layout.getLayoutSet();
            try {
                MergeLayoutPrototypesThreadLocal.setInProgress((boolean)true);
                WorkflowThreadLocal.setEnabled((boolean)false);
                SitesUtil.mergeLayoutProtypeLayout(group, layout);
                if (!Validator.isNotNull((String)layout.getSourcePrototypeLayoutUuid()) || SitesUtil.isLayoutModifiedSinceLastMerge(layout)) return methodInvocation.proceed();
                SitesUtil.mergeLayoutSetProtypeLayouts(group, layoutSet);
                return methodInvocation.proceed();
            }
            finally {
                MergeLayoutPrototypesThreadLocal.setInProgress((boolean)false);
                WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
            }
        }
        if (!methodName.equals("getLayouts") || !Arrays.equals(parameterTypes, _TYPES_L_B_L) && !Arrays.equals(parameterTypes, _TYPES_L_B_L_B_I_I)) return methodInvocation.proceed();
        long groupId = (Long)arguments[0];
        boolean privateLayout = (Boolean)arguments[1];
        long parentLayoutId = (Long)arguments[2];
        try {
            long targetGroupId;
            List layouts;
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
            try {
                MergeLayoutPrototypesThreadLocal.setInProgress((boolean)true);
                WorkflowThreadLocal.setEnabled((boolean)false);
                layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout);
                if (layouts.isEmpty()) {
                    SitesUtil.mergeLayoutSetProtypeLayouts(group, layoutSet);
                }
                boolean modified = false;
                for (Layout layout : layouts) {
                    if (!SitesUtil.isLayoutModifiedSinceLastMerge(layout)) continue;
                    modified = true;
                    break;
                }
                if (!modified) {
                    SitesUtil.mergeLayoutSetProtypeLayouts(group, layoutSet);
                }
            }
            finally {
                MergeLayoutPrototypesThreadLocal.setInProgress((boolean)false);
                WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
            }
            layouts = (List)methodInvocation.proceed();
            if (PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE) {
                return layouts;
            }
            if (group.isUser()) {
                _virtualLayoutTargetGroupId.set(group.getGroupId());
                if (parentLayoutId != 0L) return this.addChildUserGroupLayouts(group, layouts);
                return this.addUserGroupLayouts(group, layoutSet, layouts, parentLayoutId);
            }
            if (!group.isUserGroup() || parentLayoutId == 0L || (targetGroupId = _virtualLayoutTargetGroupId.get().longValue()) == 0L) return layouts;
            Group targetGroup = GroupLocalServiceUtil.getGroup((long)targetGroupId);
            return this.addChildUserGroupLayouts(targetGroup, layouts);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw e2;
        }
    }

    protected List<Layout> addChildUserGroupLayouts(Group group, List<Layout> layouts) throws Exception {
        layouts = ListUtil.copy(layouts);
        ArrayList<Layout> childLayouts = new ArrayList<Layout>();
        Iterator iterator = layouts.iterator();
        while (iterator.hasNext()) {
            Layout layout;
            Object childLayout = layout = (Layout)iterator.next();
            Group layoutGroup = layout.getGroup();
            if (layoutGroup.isUserGroup()) {
                childLayout = new VirtualLayout(layout, group);
            }
            childLayouts.add((Layout)childLayout);
        }
        return childLayouts;
    }

    protected List<Layout> addUserGroupLayouts(Group group, LayoutSet layoutSet, List<Layout> layouts, long parentLayoutId) throws Exception {
        layouts = ListUtil.copy(layouts);
        List userUserGroups = UserGroupLocalServiceUtil.getUserUserGroups((long)group.getClassPK());
        for (UserGroup userGroup : userUserGroups) {
            Group userGroupGroup = userGroup.getGroup();
            List userGroupLayouts = LayoutLocalServiceUtil.getLayouts((long)userGroupGroup.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (long)parentLayoutId);
            for (Layout userGroupLayout : userGroupLayouts) {
                VirtualLayout virtualLayout = new VirtualLayout(userGroupLayout, group);
                layouts.add(virtualLayout);
            }
        }
        return layouts;
    }
}

