/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.RequiredLayoutPrototypeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.LayoutPrototypeLocalServiceBaseImpl;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutPrototypeLocalServiceImpl
extends LayoutPrototypeLocalServiceBaseImpl {
    public LayoutPrototype addLayoutPrototype(long userId, long companyId, Map<Locale, String> nameMap, String description, boolean active) throws PortalException, SystemException {
        long layoutPrototypeId = this.counterLocalService.increment();
        LayoutPrototype layoutPrototype = this.layoutPrototypePersistence.create(layoutPrototypeId);
        layoutPrototype.setCompanyId(companyId);
        layoutPrototype.setNameMap(nameMap);
        layoutPrototype.setDescription(description);
        layoutPrototype.setActive(active);
        this.layoutPrototypePersistence.update((BaseModel)layoutPrototype, false);
        if (userId > 0L) {
            this.resourceLocalService.addResources(companyId, 0L, userId, LayoutPrototype.class.getName(), layoutPrototype.getLayoutPrototypeId(), false, false, false);
        }
        String friendlyURL = "/template-" + layoutPrototype.getLayoutPrototypeId();
        Group group = this.groupLocalService.addGroup(userId, LayoutPrototype.class.getName(), layoutPrototype.getLayoutPrototypeId(), layoutPrototype.getName(LocaleUtil.getDefault()), null, 0, friendlyURL, false, true, null);
        ServiceContext serviceContext = new ServiceContext();
        this.layoutLocalService.addLayout(userId, group.getGroupId(), true, 0L, layoutPrototype.getName(LocaleUtil.getDefault()), null, null, "portlet", false, "/layout", serviceContext);
        return layoutPrototype;
    }

    @Override
    public LayoutPrototype deleteLayoutPrototype(LayoutPrototype layoutPrototype) throws PortalException, SystemException {
        if (this.layoutPersistence.countByLayoutPrototypeUuid(layoutPrototype.getUuid()) > 0) {
            throw new RequiredLayoutPrototypeException();
        }
        Group group = layoutPrototype.getGroup();
        this.groupLocalService.deleteGroup(group);
        this.resourceLocalService.deleteResource(layoutPrototype.getCompanyId(), LayoutPrototype.class.getName(), 4, layoutPrototype.getLayoutPrototypeId());
        this.layoutPrototypePersistence.remove((BaseModel)layoutPrototype);
        PermissionCacheUtil.clearCache();
        return layoutPrototype;
    }

    @Override
    public LayoutPrototype deleteLayoutPrototype(long layoutPrototypeId) throws PortalException, SystemException {
        LayoutPrototype layoutPrototype = this.layoutPrototypePersistence.findByPrimaryKey(layoutPrototypeId);
        return this.deleteLayoutPrototype(layoutPrototype);
    }

    public LayoutPrototype getLayoutPrototypeByUuid(String uuid) throws PortalException, SystemException {
        return this.layoutPrototypePersistence.findByUuid_First(uuid, null);
    }

    public List<LayoutPrototype> search(long companyId, Boolean active, int start, int end, OrderByComparator obc) throws SystemException {
        if (active != null) {
            return this.layoutPrototypePersistence.findByC_A(companyId, active.booleanValue(), start, end, obc);
        }
        return this.layoutPrototypePersistence.findByCompanyId(companyId, start, end, obc);
    }

    public int searchCount(long companyId, Boolean active) throws SystemException {
        if (active != null) {
            return this.layoutPrototypePersistence.countByC_A(companyId, active.booleanValue());
        }
        return this.layoutPrototypePersistence.countByCompanyId(companyId);
    }

    public LayoutPrototype updateLayoutPrototype(long layoutPrototypeId, Map<Locale, String> nameMap, String description, boolean active) throws PortalException, SystemException {
        LayoutPrototype layoutPrototype = this.layoutPrototypePersistence.findByPrimaryKey(layoutPrototypeId);
        layoutPrototype.setNameMap(nameMap);
        layoutPrototype.setDescription(description);
        layoutPrototype.setActive(active);
        this.layoutPrototypePersistence.update((BaseModel)layoutPrototype, false);
        Group group = this.groupLocalService.getLayoutPrototypeGroup(layoutPrototype.getCompanyId(), layoutPrototypeId);
        group.setName(layoutPrototype.getName(LocaleUtil.getDefault()));
        this.groupPersistence.update((BaseModel)group, false);
        return layoutPrototype;
    }
}

