/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.model.LayoutSetStagingHandler;
import com.liferay.portal.model.impl.ColorSchemeImpl;
import com.liferay.portal.model.impl.ThemeImpl;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.service.impl.LayoutSetLocalServiceImpl;
import com.liferay.portal.staging.StagingAdvicesThreadLocal;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutSetLocalServiceStagingAdvice
extends LayoutSetLocalServiceImpl
implements MethodInterceptor {
    private static Set<String> _layoutSetLocalServiceStagingAdviceMethodNames = new HashSet<String>();

    static {
        _layoutSetLocalServiceStagingAdviceMethodNames.add("updateLayoutSetPrototypeLinkEnabled");
        _layoutSetLocalServiceStagingAdviceMethodNames.add("updateLogo");
        _layoutSetLocalServiceStagingAdviceMethodNames.add("updateLookAndFeel");
        _layoutSetLocalServiceStagingAdviceMethodNames.add("updateSettings");
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (!StagingAdvicesThreadLocal.isEnabled()) {
            return methodInvocation.proceed();
        }
        Method method = methodInvocation.getMethod();
        String methodName = method.getName();
        Object[] arguments = methodInvocation.getArguments();
        if (!_layoutSetLocalServiceStagingAdviceMethodNames.contains(methodName)) {
            return this.wrapReturnValue(methodInvocation.proceed());
        }
        Object returnValue = null;
        if (methodName.equals("updateLayoutSetPrototypeLinkEnabled") && arguments.length == 5) {
            this.updateLayoutSetPrototypeLinkEnabled((Long)arguments[0], (Boolean)arguments[1], (Boolean)arguments[2], (String)arguments[3]);
        } else if (methodName.equals("updateLogo") && arguments.length == 5) {
            this.updateLogo((Long)arguments[0], (Boolean)arguments[1], (Boolean)arguments[2], (InputStream)arguments[3], (Boolean)arguments[4]);
        } else if (methodName.equals("updateLookAndFeel") && arguments.length == 6) {
            returnValue = this.updateLookAndFeel((Long)arguments[0], (Boolean)arguments[1], (String)arguments[2], (String)arguments[3], (String)arguments[4], (Boolean)arguments[5]);
        } else if (methodName.equals("updateSettings")) {
            returnValue = this.updateSettings((Long)arguments[0], (Boolean)arguments[1], (String)arguments[2]);
        } else {
            try {
                Class<?> clazz = ((Object)((Object)this)).getClass();
                Method localMethod = clazz.getMethod(methodName, method.getParameterTypes());
                returnValue = localMethod.invoke((Object)this, arguments);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
            catch (NoSuchMethodException nsme) {
                throw new SystemException((Throwable)nsme);
            }
        }
        return this.wrapReturnValue(returnValue);
    }

    @Override
    public void updateLayoutSetPrototypeLinkEnabled(long groupId, boolean privateLayout, boolean layoutSetPrototypeLinkEnabled, String layoutSetPrototypeUuid) throws PortalException, SystemException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        LayoutSetBranch layoutSetBranch = LayoutStagingUtil.getLayoutSetBranch((LayoutSet)(layoutSet = this.wrapLayoutSet(layoutSet)));
        if (layoutSetBranch == null) {
            super.updateLayoutSetPrototypeLinkEnabled(groupId, privateLayout, layoutSetPrototypeLinkEnabled, layoutSetPrototypeUuid);
            return;
        }
        if (Validator.isNull((String)layoutSetPrototypeUuid)) {
            layoutSetPrototypeUuid = layoutSetBranch.getLayoutSetPrototypeUuid();
        }
        if (Validator.isNull((String)layoutSetPrototypeUuid) && layoutSetPrototypeLinkEnabled) {
            throw new IllegalStateException("Cannot set layoutSetPrototypeLinkEnabled to true when layoutSetPrototypeUuid is null");
        }
        layoutSetBranch.setLayoutSetPrototypeLinkEnabled(layoutSetPrototypeLinkEnabled);
        layoutSetBranch.setLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
        this.layoutSetBranchPersistence.update((BaseModel)layoutSetBranch, false);
    }

    @Override
    public LayoutSet updateLogo(long groupId, boolean privateLayout, boolean logo, InputStream is, boolean cleanUpStream) throws PortalException, SystemException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        LayoutSetBranch layoutSetBranch = LayoutStagingUtil.getLayoutSetBranch((LayoutSet)(layoutSet = this.wrapLayoutSet(layoutSet)));
        if (layoutSetBranch == null) {
            return super.updateLogo(groupId, privateLayout, logo, is, cleanUpStream);
        }
        layoutSetBranch.setModifiedDate(new Date());
        layoutSetBranch.setLogo(logo);
        if (logo) {
            long logoId = layoutSetBranch.getLogoId();
            if (logoId <= 0L) {
                logoId = this.counterLocalService.increment();
                layoutSet.setLogoId(logoId);
            }
        } else {
            layoutSet.setLogoId(0L);
        }
        this.layoutSetBranchPersistence.update((BaseModel)layoutSetBranch, false);
        if (logo) {
            this.imageLocalService.updateImage(layoutSetBranch.getLogoId(), is, cleanUpStream);
        } else {
            this.imageLocalService.deleteImage(layoutSetBranch.getLogoId());
        }
        return layoutSet;
    }

    @Override
    public LayoutSet updateLookAndFeel(long groupId, boolean privateLayout, String themeId, String colorSchemeId, String css, boolean wapTheme) throws PortalException, SystemException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        LayoutSetBranch layoutSetBranch = LayoutStagingUtil.getLayoutSetBranch((LayoutSet)(layoutSet = this.wrapLayoutSet(layoutSet)));
        if (layoutSetBranch == null) {
            return super.updateLookAndFeel(groupId, privateLayout, themeId, colorSchemeId, css, wapTheme);
        }
        layoutSetBranch.setModifiedDate(new Date());
        if (Validator.isNull((String)themeId)) {
            themeId = ThemeImpl.getDefaultRegularThemeId(layoutSetBranch.getCompanyId());
        }
        if (Validator.isNull((String)colorSchemeId)) {
            colorSchemeId = ColorSchemeImpl.getDefaultRegularColorSchemeId();
        }
        if (wapTheme) {
            layoutSetBranch.setWapThemeId(themeId);
            layoutSetBranch.setWapColorSchemeId(colorSchemeId);
        } else {
            layoutSetBranch.setThemeId(themeId);
            layoutSetBranch.setColorSchemeId(colorSchemeId);
            layoutSetBranch.setCss(css);
        }
        this.layoutSetBranchPersistence.update((BaseModel)layoutSetBranch, false);
        return layoutSet;
    }

    @Override
    public LayoutSet updateSettings(long groupId, boolean privateLayout, String settings) throws PortalException, SystemException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        LayoutSetBranch layoutSetBranch = LayoutStagingUtil.getLayoutSetBranch((LayoutSet)(layoutSet = this.wrapLayoutSet(layoutSet)));
        if (layoutSetBranch == null) {
            return super.updateSettings(groupId, privateLayout, settings);
        }
        layoutSetBranch.setModifiedDate(new Date());
        layoutSetBranch.setSettings(settings);
        this.layoutSetBranchPersistence.update((BaseModel)layoutSetBranch, false);
        return layoutSet;
    }

    protected LayoutSet unwrapLayoutSet(LayoutSet layoutSet) {
        LayoutSetStagingHandler layoutSetStagingHandler = LayoutStagingUtil.getLayoutSetStagingHandler((LayoutSet)layoutSet);
        if (layoutSetStagingHandler == null) {
            return layoutSet;
        }
        return layoutSetStagingHandler.getLayoutSet();
    }

    protected LayoutSet wrapLayoutSet(LayoutSet layoutSet) {
        LayoutSetStagingHandler layoutSetStagingHandler = LayoutStagingUtil.getLayoutSetStagingHandler((LayoutSet)layoutSet);
        if (layoutSetStagingHandler != null) {
            return layoutSet;
        }
        Group group = null;
        try {
            group = layoutSet.getGroup();
        }
        catch (Exception exception) {
            return layoutSet;
        }
        if (!LayoutStagingUtil.isBranchingLayoutSet((Group)group, (boolean)layoutSet.getPrivateLayout())) {
            return layoutSet;
        }
        return (LayoutSet)ProxyUtil.newProxyInstance((ClassLoader)PACLClassLoaderUtil.getPortalClassLoader(), (Class[])new Class[]{LayoutSet.class}, (InvocationHandler)new LayoutSetStagingHandler(layoutSet));
    }

    protected List<LayoutSet> wrapLayoutSets(List<LayoutSet> layoutSets) {
        if (layoutSets.isEmpty()) {
            return layoutSets;
        }
        ArrayList<LayoutSet> wrappedLayoutSets = new ArrayList<LayoutSet>(layoutSets.size());
        int i2 = 0;
        while (i2 < layoutSets.size()) {
            LayoutSet wrappedLayoutSet = this.wrapLayoutSet(layoutSets.get(i2));
            wrappedLayoutSets.add(wrappedLayoutSet);
            ++i2;
        }
        return wrappedLayoutSets;
    }

    protected Object wrapReturnValue(Object returnValue) {
        if (returnValue instanceof LayoutSet) {
            returnValue = this.wrapLayoutSet((LayoutSet)returnValue);
        } else if (returnValue instanceof List) {
            returnValue = this.wrapLayoutSets(returnValue);
        }
        return returnValue;
    }
}

