/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.service.impl.LayoutSetPrototypeLayoutListener;
import com.liferay.portal.service.persistence.LayoutSetPrototypeUtil;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutSetPrototypeLayoutSetListener
extends BaseModelListener<LayoutSet> {
    private static Log _log = LogFactoryUtil.getLog(LayoutSetPrototypeLayoutListener.class);

    public void onAfterCreate(LayoutSet layoutSet) {
        this.updateLayoutSetPrototype(layoutSet, layoutSet.getModifiedDate());
    }

    public void onAfterRemove(LayoutSet layoutSet) {
        this.updateLayoutSetPrototype(layoutSet, new Date());
    }

    public void onAfterUpdate(LayoutSet layoutSet) {
        this.updateLayoutSetPrototype(layoutSet, layoutSet.getModifiedDate());
    }

    protected void updateLayoutSetPrototype(LayoutSet layoutSet, Date modifiedDate) {
        try {
            Group group = layoutSet.getGroup();
            if (!group.isLayoutSetPrototype()) {
                return;
            }
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)group.getClassPK());
            layoutSetPrototype.setModifiedDate(modifiedDate);
            UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
            settingsProperties.remove((Object)"merge-fail-count");
            LayoutSetPrototypeUtil.update((LayoutSetPrototype)layoutSetPrototype, (boolean)false);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }
}

