/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.PhoneNumberException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.format.PhoneNumberFormatUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.User;
import com.liferay.portal.service.base.PhoneLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhoneLocalServiceImpl
extends PhoneLocalServiceBaseImpl {
    public Phone addPhone(long userId, String className, long classPK, String number, String extension, int typeId, boolean primary) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        Date now = new Date();
        this.validate(0L, user.getCompanyId(), classNameId, classPK, number, extension, typeId, primary);
        long phoneId = this.counterLocalService.increment();
        Phone phone = this.phonePersistence.create(phoneId);
        phone.setCompanyId(user.getCompanyId());
        phone.setUserId(user.getUserId());
        phone.setUserName(user.getFullName());
        phone.setCreateDate(now);
        phone.setModifiedDate(now);
        phone.setClassNameId(classNameId);
        phone.setClassPK(classPK);
        phone.setNumber(number);
        phone.setExtension(extension);
        phone.setTypeId(typeId);
        phone.setPrimary(primary);
        this.phonePersistence.update((BaseModel)phone, false);
        return phone;
    }

    public void deletePhones(long companyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        List phones = this.phonePersistence.findByC_C_C(companyId, classNameId, classPK);
        for (Phone phone : phones) {
            this.deletePhone(phone);
        }
    }

    public List<Phone> getPhones() throws SystemException {
        return this.phonePersistence.findAll();
    }

    public List<Phone> getPhones(long companyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.phonePersistence.findByC_C_C(companyId, classNameId, classPK);
    }

    public Phone updatePhone(long phoneId, String number, String extension, int typeId, boolean primary) throws PortalException, SystemException {
        this.validate(phoneId, 0L, 0L, 0L, number, extension, typeId, primary);
        Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
        phone.setModifiedDate(new Date());
        phone.setNumber(number);
        phone.setExtension(extension);
        phone.setTypeId(typeId);
        phone.setPrimary(primary);
        this.phonePersistence.update((BaseModel)phone, false);
        return phone;
    }

    protected void validate(long phoneId, long companyId, long classNameId, long classPK, boolean primary) throws SystemException {
        if (primary) {
            for (Phone phone : this.phonePersistence.findByC_C_C_P(companyId, classNameId, classPK, primary)) {
                if (phoneId > 0L && phone.getPhoneId() == phoneId) continue;
                phone.setPrimary(false);
                this.phonePersistence.update((BaseModel)phone, false);
            }
        }
    }

    protected void validate(long phoneId, long companyId, long classNameId, long classPK, String number, String extension, int typeId, boolean primary) throws PortalException, SystemException {
        if (!PhoneNumberFormatUtil.validate((String)number)) {
            throw new PhoneNumberException();
        }
        if (Validator.isNotNull((String)extension)) {
            int i2 = 0;
            while (i2 < extension.length()) {
                if (!Character.isDigit(extension.charAt(i2))) {
                    throw new PhoneNumberException();
                }
                ++i2;
            }
        }
        if (phoneId > 0L) {
            Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
            companyId = phone.getCompanyId();
            classNameId = phone.getClassNameId();
            classPK = phone.getClassPK();
        }
        if (classNameId == PortalUtil.getClassNameId(Account.class) || classNameId == PortalUtil.getClassNameId(Contact.class) || classNameId == PortalUtil.getClassNameId(Organization.class)) {
            this.listTypeService.validate(typeId, classNameId, ".phone");
        }
        this.validate(phoneId, companyId, classNameId, classPK, primary);
    }
}

