/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.concurrent.LockRegistry;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.PortalPreferences;
import com.liferay.portal.service.base.PortalPreferencesLocalServiceBaseImpl;
import com.liferay.portlet.PortalPreferencesImpl;
import com.liferay.portlet.PortalPreferencesWrapper;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletPreferencesThreadLocal;
import java.util.concurrent.locks.ReentrantLock;
import javax.portlet.PortletPreferences;

public class PortalPreferencesLocalServiceImpl
extends PortalPreferencesLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(PortalPreferencesLocalServiceImpl.class);

    public PortalPreferences addPortalPreferences(long companyId, long ownerId, int ownerType, String defaultPreferences) throws SystemException {
        PortalPreferences portalPreferences;
        block4: {
            long portalPreferencesId = this.counterLocalService.increment();
            portalPreferences = this.portalPreferencesPersistence.create(portalPreferencesId);
            portalPreferences.setOwnerId(ownerId);
            portalPreferences.setOwnerType(ownerType);
            if (Validator.isNull((String)defaultPreferences)) {
                defaultPreferences = "<portlet-preferences />";
            }
            portalPreferences.setPreferences(defaultPreferences);
            try {
                this.portalPreferencesPersistence.update((BaseModel)portalPreferences, false);
            }
            catch (SystemException se) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Add failed, fetch {ownerId=" + ownerId + ", ownerType=" + ownerType + "}"));
                }
                if ((portalPreferences = this.portalPreferencesPersistence.fetchByO_O(ownerId, ownerType, false)) != null) break block4;
                throw se;
            }
        }
        return portalPreferences;
    }

    public PortletPreferences getPreferences(long companyId, long ownerId, int ownerType) throws SystemException {
        return this.getPreferences(companyId, ownerId, ownerType, null);
    }

    public PortletPreferences getPreferences(long companyId, long ownerId, int ownerType, String defaultPreferences) throws SystemException {
        DB db = DBFactoryUtil.getDB();
        String dbType = db.getType();
        if (!dbType.equals("hypersonic")) {
            return this.doGetPreferences(companyId, ownerId, ownerType, defaultPreferences);
        }
        StringBundler sb = new StringBundler(4);
        sb.append(ownerId);
        sb.append("#");
        sb.append(ownerType);
        sb.append("#");
        String groupName = ((Object)((Object)this)).getClass().getName();
        String key = sb.toString();
        ReentrantLock lock = LockRegistry.allocateLock((String)groupName, (String)key);
        lock.lock();
        try {
            PortletPreferences portletPreferences = this.doGetPreferences(companyId, ownerId, ownerType, defaultPreferences);
            return portletPreferences;
        }
        finally {
            lock.unlock();
            LockRegistry.freeLock((String)groupName, (String)key);
        }
    }

    public PortalPreferences updatePreferences(long ownerId, int ownerType, com.liferay.portlet.PortalPreferences portalPreferences) throws SystemException {
        String xml = PortletPreferencesFactoryUtil.toXML((com.liferay.portlet.PortalPreferences)portalPreferences);
        return this.updatePreferences(ownerId, ownerType, xml);
    }

    public PortalPreferences updatePreferences(long ownerId, int ownerType, String xml) throws SystemException {
        PortalPreferences portalPreferences = this.portalPreferencesPersistence.fetchByO_O(ownerId, ownerType);
        if (portalPreferences == null) {
            long portalPreferencesId = this.counterLocalService.increment();
            portalPreferences = this.portalPreferencesPersistence.create(portalPreferencesId);
            portalPreferences.setOwnerId(ownerId);
            portalPreferences.setOwnerType(ownerType);
        }
        portalPreferences.setPreferences(xml);
        this.portalPreferencesPersistence.update((BaseModel)portalPreferences, false);
        return portalPreferences;
    }

    protected PortletPreferences doGetPreferences(long companyId, long ownerId, int ownerType, String defaultPreferences) throws SystemException {
        PortalPreferences portalPreferences = this.portalPreferencesPersistence.fetchByO_O(ownerId, ownerType);
        if (portalPreferences == null) {
            if (PortletPreferencesThreadLocal.isStrict() && Validator.isNull((String)defaultPreferences)) {
                return new PortalPreferencesWrapper(new PortalPreferencesImpl());
            }
            portalPreferences = this.portalPreferencesLocalService.addPortalPreferences(companyId, ownerId, ownerType, defaultPreferences);
        }
        PortalPreferencesImpl portalPreferencesImpl = (PortalPreferencesImpl)PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (String)portalPreferences.getPreferences());
        return new PortalPreferencesWrapper(portalPreferencesImpl);
    }
}

