/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchPortletItemException;
import com.liferay.portal.PortletItemNameException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.PortletItem;
import com.liferay.portal.model.PortletPreferences;
import com.liferay.portal.model.User;
import com.liferay.portal.service.base.PortletItemLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletItemLocalServiceImpl
extends PortletItemLocalServiceBaseImpl {
    public PortletItem addPortletItem(long userId, long groupId, String name, String portletId, String className) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        Date now = new Date();
        this.validate(name);
        long portletItemId = this.counterLocalService.increment();
        PortletItem portletItem = this.portletItemPersistence.create(portletItemId);
        portletItem.setGroupId(groupId);
        portletItem.setCompanyId(user.getCompanyId());
        portletItem.setUserId(user.getUserId());
        portletItem.setUserName(user.getFullName());
        portletItem.setCreateDate(now);
        portletItem.setModifiedDate(now);
        portletItem.setName(name);
        portletItem.setPortletId(portletId);
        portletItem.setClassNameId(classNameId);
        this.portletItemPersistence.update((BaseModel)portletItem, false);
        return portletItem;
    }

    public PortletItem getPortletItem(long groupId, String name, String portletId, String className) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.portletItemPersistence.findByG_N_P_C(groupId, name, portletId, classNameId);
    }

    public List<PortletItem> getPortletItems(long groupId, String className) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.portletItemPersistence.findByG_C(groupId, classNameId);
    }

    public List<PortletItem> getPortletItems(long groupId, String portletId, String className) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.portletItemPersistence.findByG_P_C(groupId, portletId, classNameId);
    }

    public PortletItem updatePortletItem(long userId, long groupId, String name, String portletId, String className) throws PortalException, SystemException {
        PortletItem portletItem = null;
        try {
            User user = this.userPersistence.findByPrimaryKey(userId);
            portletItem = this.getPortletItem(groupId, name, portletId, PortletPreferences.class.getName());
            portletItem.setUserId(userId);
            portletItem.setUserName(user.getFullName());
            portletItem.setModifiedDate(new Date());
            this.portletItemPersistence.update((BaseModel)portletItem, false);
        }
        catch (NoSuchPortletItemException noSuchPortletItemException) {
            portletItem = this.addPortletItem(userId, groupId, name, portletId, PortletPreferences.class.getName());
        }
        return portletItem;
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new PortletItemNameException();
        }
    }
}

