/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.PortletPreferencesIds;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.impl.LayoutLocalServiceImpl;
import com.liferay.portal.service.persistence.LayoutRevisionUtil;
import com.liferay.portal.staging.StagingAdvicesThreadLocal;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class PortletPreferencesLocalServiceStagingAdvice
extends LayoutLocalServiceImpl
implements MethodInterceptor {
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (!StagingAdvicesThreadLocal.isEnabled()) {
            return methodInvocation.proceed();
        }
        try {
            Object[] arguments = methodInvocation.getArguments();
            if (arguments == null) {
                return methodInvocation.proceed();
            }
            Method method = methodInvocation.getMethod();
            String methodName = method.getName();
            if (methodName.equals("getPortletPreferences") && arguments.length == 4) {
                return this.getPortletPreferences(methodInvocation);
            }
            if (methodName.equals("getPreferences")) {
                return this.getPreferences(methodInvocation);
            }
            if (methodName.equals("getStrictPreferences")) {
                return this.getPreferences(methodInvocation);
            }
            if (methodName.equals("updatePreferences")) {
                return this.updatePreferences(methodInvocation);
            }
            return methodInvocation.proceed();
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    protected Object getPortletPreferences(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        Object[] arguments = methodInvocation.getArguments();
        long plid = (Long)arguments[2];
        if (plid <= 0L) {
            return methodInvocation.proceed();
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        if (!LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
            return methodInvocation.proceed();
        }
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout);
        arguments[2] = layoutRevision.getLayoutRevisionId();
        return method.invoke(methodInvocation.getThis(), arguments);
    }

    protected Object getPreferences(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        Object[] arguments = methodInvocation.getArguments();
        long plid = 0L;
        if (arguments.length == 1) {
            PortletPreferencesIds portletPreferencesIds = (PortletPreferencesIds)arguments[0];
            plid = portletPreferencesIds.getPlid();
        } else {
            plid = (Long)arguments[3];
        }
        if (plid <= 0L) {
            return methodInvocation.proceed();
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        if (!LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
            return methodInvocation.proceed();
        }
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout);
        plid = layoutRevision.getLayoutRevisionId();
        if (arguments.length == 1) {
            PortletPreferencesIds portletPreferencesIds = (PortletPreferencesIds)arguments[0];
            portletPreferencesIds.setPlid(plid);
        } else {
            arguments[3] = plid;
        }
        return method.invoke(methodInvocation.getThis(), arguments);
    }

    protected Object updatePreferences(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        Object[] arguments = methodInvocation.getArguments();
        long plid = (Long)arguments[2];
        if (plid <= 0L) {
            return methodInvocation.proceed();
        }
        LayoutRevision layoutRevision = LayoutRevisionUtil.fetchByPrimaryKey((long)plid);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return methodInvocation.proceed();
        }
        boolean exporting = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"exporting");
        if (layoutRevision == null || exporting) {
            return methodInvocation.proceed();
        }
        if (!MergeLayoutPrototypesThreadLocal.isInProgress()) {
            serviceContext.setWorkflowAction(2);
        }
        layoutRevision = LayoutRevisionLocalServiceUtil.updateLayoutRevision((long)serviceContext.getUserId(), (long)layoutRevision.getLayoutRevisionId(), (long)layoutRevision.getLayoutBranchId(), (String)layoutRevision.getName(), (String)layoutRevision.getTitle(), (String)layoutRevision.getDescription(), (String)layoutRevision.getKeywords(), (String)layoutRevision.getRobots(), (String)layoutRevision.getTypeSettings(), (boolean)layoutRevision.getIconImage(), (long)layoutRevision.getIconImageId(), (String)layoutRevision.getThemeId(), (String)layoutRevision.getColorSchemeId(), (String)layoutRevision.getWapThemeId(), (String)layoutRevision.getWapColorSchemeId(), (String)layoutRevision.getCss(), (ServiceContext)serviceContext);
        arguments[2] = layoutRevision.getLayoutRevisionId();
        return method.invoke(methodInvocation.getThis(), arguments);
    }
}

