/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.InvalidRepositoryException;
import com.liferay.portal.NoSuchRepositoryException;
import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.ImportExportThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.BaseRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.cmis.BaseCmisRepository;
import com.liferay.portal.kernel.repository.cmis.CMISRepositoryHandler;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.RepositoryEntry;
import com.liferay.portal.model.User;
import com.liferay.portal.repository.cmis.CMISRepository;
import com.liferay.portal.repository.liferayrepository.LiferayLocalRepository;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.repository.proxy.BaseRepositoryProxyBean;
import com.liferay.portal.repository.util.RepositoryFactoryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.RepositoryLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.RepositoryNameException;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RepositoryLocalServiceImpl
extends RepositoryLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(RepositoryLocalServiceImpl.class);
    private long _defaultClassNameId;
    private Map<Long, LocalRepository> _localRepositoriesByRepositoryEntryId = new ConcurrentHashMap<Long, LocalRepository>();
    private Map<Long, LocalRepository> _localRepositoriesByRepositoryId = new ConcurrentHashMap<Long, LocalRepository>();
    private Map<Long, Repository> _repositoriesByEntryId = new ConcurrentHashMap<Long, Repository>();
    private Map<Long, Repository> _repositoriesByRepositoryId = new ConcurrentHashMap<Long, Repository>();

    public long addRepository(long userId, long groupId, long classNameId, long parentFolderId, String name, String description, String portletId, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        long repositoryId = this.counterLocalService.increment();
        com.liferay.portal.model.Repository repository = this.repositoryPersistence.create(repositoryId);
        repository.setUuid(serviceContext.getUuid());
        repository.setGroupId(groupId);
        repository.setCompanyId(user.getCompanyId());
        repository.setUserId(user.getUserId());
        repository.setUserName(user.getFullName());
        repository.setCreateDate(now);
        repository.setModifiedDate(now);
        repository.setClassNameId(classNameId);
        repository.setName(name);
        repository.setDescription(description);
        repository.setPortletId(portletId);
        repository.setTypeSettingsProperties(typeSettingsProperties);
        repository.setDlFolderId(this.getDLFolderId(user, groupId, repositoryId, parentFolderId, name, description, serviceContext));
        this.repositoryPersistence.update((BaseModel)repository, false);
        if (classNameId != this.getDefaultClassNameId()) {
            try {
                this.createRepositoryImpl(repositoryId, classNameId);
            }
            catch (Exception e2) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)e2, (Throwable)e2);
                }
                throw new InvalidRepositoryException((Throwable)e2);
            }
        }
        return repositoryId;
    }

    public void checkRepository(long repositoryId) throws SystemException {
        Group group = this.groupPersistence.fetchByPrimaryKey(repositoryId);
        if (group != null) {
            return;
        }
        try {
            this.repositoryPersistence.findByPrimaryKey(repositoryId);
        }
        catch (NoSuchRepositoryException nsre) {
            throw new RepositoryException(nsre.getMessage());
        }
    }

    public void deleteRepositories(long groupId) throws PortalException, SystemException {
        List repositories = this.repositoryPersistence.findByGroupId(groupId);
        for (com.liferay.portal.model.Repository repository : repositories) {
            this.deleteRepository(repository.getRepositoryId());
        }
        this.dlFolderLocalService.deleteAll(groupId);
    }

    public com.liferay.portal.model.Repository deleteRepository(long repositoryId) throws PortalException, SystemException {
        com.liferay.portal.model.Repository repository = this.repositoryPersistence.fetchByPrimaryKey(repositoryId);
        if (repository != null) {
            this.expandoValueLocalService.deleteValues(com.liferay.portal.model.Repository.class.getName(), repositoryId);
            try {
                this.dlFolderLocalService.deleteFolder(repository.getDlFolderId());
            }
            catch (NoSuchFolderException noSuchFolderException) {}
            this.repositoryPersistence.remove((BaseModel)repository);
            this.repositoryEntryPersistence.removeByRepositoryId(repositoryId);
        }
        return repository;
    }

    public LocalRepository getLocalRepositoryImpl(long repositoryId) throws PortalException, SystemException {
        LocalRepository localRepositoryImpl = this._localRepositoriesByRepositoryId.get(repositoryId);
        if (localRepositoryImpl != null) {
            return localRepositoryImpl;
        }
        long classNameId = this.getRepositoryClassNameId(repositoryId);
        if (classNameId == this.getDefaultClassNameId()) {
            localRepositoryImpl = new LiferayLocalRepository(this.repositoryLocalService, this.repositoryService, this.dlAppHelperLocalService, this.dlFileEntryLocalService, this.dlFileEntryService, this.dlFileVersionLocalService, this.dlFileVersionService, this.dlFolderLocalService, this.dlFolderService, repositoryId);
        } else {
            BaseRepository baseRepository = this.createRepositoryImpl(repositoryId, classNameId);
            localRepositoryImpl = baseRepository.getLocalRepository();
        }
        this.checkRepository(repositoryId);
        this._localRepositoriesByRepositoryId.put(repositoryId, localRepositoryImpl);
        return localRepositoryImpl;
    }

    public LocalRepository getLocalRepositoryImpl(long folderId, long fileEntryId, long fileVersionId) throws PortalException, SystemException {
        long repositoryEntryId = this.getRepositoryEntryId(folderId, fileEntryId, fileVersionId);
        LocalRepository localRepositoryImpl = this._localRepositoriesByRepositoryEntryId.get(repositoryEntryId);
        if (localRepositoryImpl != null) {
            return localRepositoryImpl;
        }
        localRepositoryImpl = new LiferayLocalRepository(this.repositoryLocalService, this.repositoryService, this.dlAppHelperLocalService, this.dlFileEntryLocalService, this.dlFileEntryService, this.dlFileVersionLocalService, this.dlFileVersionService, this.dlFolderLocalService, this.dlFolderService, folderId, fileEntryId, fileVersionId);
        if (localRepositoryImpl.getRepositoryId() == 0L) {
            localRepositoryImpl = null;
        }
        if (localRepositoryImpl == null) {
            BaseRepository baseRepository = this.createRepositoryImpl(repositoryEntryId);
            localRepositoryImpl = baseRepository.getLocalRepository();
        } else {
            this.checkRepository(localRepositoryImpl.getRepositoryId());
        }
        this._localRepositoriesByRepositoryEntryId.put(repositoryEntryId, localRepositoryImpl);
        return localRepositoryImpl;
    }

    public Repository getRepositoryImpl(long repositoryId) throws PortalException, SystemException {
        Repository repositoryImpl = this._repositoriesByRepositoryId.get(repositoryId);
        if (repositoryImpl != null) {
            return repositoryImpl;
        }
        long classNameId = this.getRepositoryClassNameId(repositoryId);
        repositoryImpl = classNameId == PortalUtil.getClassNameId((String)LiferayRepository.class.getName()) ? new LiferayRepository(this.repositoryLocalService, this.repositoryService, this.dlAppHelperLocalService, this.dlFileEntryLocalService, this.dlFileEntryService, this.dlFileVersionLocalService, this.dlFileVersionService, this.dlFolderLocalService, this.dlFolderService, repositoryId) : this.createRepositoryImpl(repositoryId, classNameId);
        this.checkRepository(repositoryId);
        this._repositoriesByRepositoryId.put(repositoryId, repositoryImpl);
        return repositoryImpl;
    }

    public Repository getRepositoryImpl(long folderId, long fileEntryId, long fileVersionId) throws PortalException, SystemException {
        long repositoryEntryId = this.getRepositoryEntryId(folderId, fileEntryId, fileVersionId);
        Repository repositoryImpl = this._repositoriesByEntryId.get(repositoryEntryId);
        if (repositoryImpl != null) {
            return repositoryImpl;
        }
        repositoryImpl = new LiferayRepository(this.repositoryLocalService, this.repositoryService, this.dlAppHelperLocalService, this.dlFileEntryLocalService, this.dlFileEntryService, this.dlFileVersionLocalService, this.dlFileVersionService, this.dlFolderLocalService, this.dlFolderService, folderId, fileEntryId, fileVersionId);
        if (repositoryImpl.getRepositoryId() == 0L) {
            repositoryImpl = null;
        }
        if (repositoryImpl == null) {
            repositoryImpl = this.createRepositoryImpl(repositoryEntryId);
        } else {
            this.checkRepository(repositoryImpl.getRepositoryId());
        }
        this._repositoriesByEntryId.put(repositoryEntryId, repositoryImpl);
        return repositoryImpl;
    }

    public UnicodeProperties getTypeSettingsProperties(long repositoryId) throws PortalException, SystemException {
        com.liferay.portal.model.Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        return repository.getTypeSettingsProperties();
    }

    public void updateRepository(long repositoryId, String name, String description) throws PortalException, SystemException {
        Date now = new Date();
        com.liferay.portal.model.Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        repository.setModifiedDate(now);
        repository.setName(name);
        repository.setDescription(description);
        this.repositoryPersistence.update((BaseModel)repository, false);
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(repository.getDlFolderId());
        dlFolder.setModifiedDate(now);
        dlFolder.setName(name);
        dlFolder.setDescription(description);
        this.dlFolderPersistence.update((BaseModel)dlFolder, false);
    }

    protected BaseRepository createRepositoryImpl(long repositoryEntryId) throws PortalException, SystemException {
        RepositoryEntry repositoryEntry = this.repositoryEntryPersistence.findByPrimaryKey(repositoryEntryId);
        long repositoryId = repositoryEntry.getRepositoryId();
        return (BaseRepository)this.getRepositoryImpl(repositoryId);
    }

    protected BaseRepository createRepositoryImpl(long repositoryId, long classNameId) throws PortalException, SystemException {
        BaseRepositoryProxyBean baseRepositoryProxyBean;
        ClassLoaderBeanHandler classLoaderBeanHandler;
        Object bean;
        BaseRepository baseRepository = null;
        com.liferay.portal.model.Repository repository = null;
        try {
            repository = this.getRepository(repositoryId);
            String repositoryImplClassName = PortalUtil.getClassName((long)classNameId);
            baseRepository = RepositoryFactoryUtil.getInstance(repositoryImplClassName);
        }
        catch (Exception e2) {
            throw new RepositoryException("There is no valid repository class with class name id " + classNameId, (Throwable)e2);
        }
        CMISRepositoryHandler cmisRepositoryHandler = null;
        if (baseRepository instanceof CMISRepositoryHandler) {
            cmisRepositoryHandler = (CMISRepositoryHandler)baseRepository;
        } else if (baseRepository instanceof BaseRepositoryProxyBean && (bean = (classLoaderBeanHandler = (ClassLoaderBeanHandler)ProxyUtil.getInvocationHandler((Object)(baseRepositoryProxyBean = (BaseRepositoryProxyBean)baseRepository).getProxyBean())).getBean()) instanceof CMISRepositoryHandler) {
            cmisRepositoryHandler = (CMISRepositoryHandler)bean;
        }
        if (cmisRepositoryHandler != null) {
            CMISRepository cmisRepository = new CMISRepository(cmisRepositoryHandler);
            cmisRepositoryHandler.setCmisRepository((BaseCmisRepository)cmisRepository);
            this.setupRepository(repositoryId, repository, (BaseRepository)cmisRepository);
        }
        this.setupRepository(repositoryId, repository, baseRepository);
        if (!ImportExportThreadLocal.isImportInProcess()) {
            baseRepository.initRepository();
        }
        return baseRepository;
    }

    protected long getDefaultClassNameId() {
        if (this._defaultClassNameId == 0L) {
            this._defaultClassNameId = PortalUtil.getClassNameId((String)LiferayRepository.class.getName());
        }
        return this._defaultClassNameId;
    }

    protected long getDLFolderId(User user, long groupId, long repositoryId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        if (Validator.isNull((String)name)) {
            throw new RepositoryNameException();
        }
        DLFolder dlFolder = this.dlFolderLocalService.addFolder(user.getUserId(), groupId, repositoryId, true, parentFolderId, name, description, serviceContext);
        return dlFolder.getFolderId();
    }

    protected long getRepositoryClassNameId(long repositoryId) throws SystemException {
        com.liferay.portal.model.Repository repository = this.repositoryPersistence.fetchByPrimaryKey(repositoryId);
        if (repository != null) {
            return repository.getClassNameId();
        }
        return PortalUtil.getClassNameId((String)LiferayRepository.class.getName());
    }

    protected long getRepositoryEntryId(long folderId, long fileEntryId, long fileVersionId) throws RepositoryException {
        long repositoryEntryId = 0L;
        if (folderId != 0L) {
            repositoryEntryId = folderId;
        } else if (fileEntryId != 0L) {
            repositoryEntryId = fileEntryId;
        } else if (fileVersionId != 0L) {
            repositoryEntryId = fileVersionId;
        }
        if (repositoryEntryId == 0L) {
            throw new RepositoryException("Missing a valid ID for folder, file entry or file version");
        }
        return repositoryEntryId;
    }

    protected void setupRepository(long repositoryId, com.liferay.portal.model.Repository repository, BaseRepository baseRepository) {
        baseRepository.setAssetEntryLocalService(this.assetEntryLocalService);
        baseRepository.setCompanyId(repository.getCompanyId());
        baseRepository.setCompanyLocalService(this.companyLocalService);
        baseRepository.setCounterLocalService(this.counterLocalService);
        baseRepository.setDLAppHelperLocalService(this.dlAppHelperLocalService);
        baseRepository.setGroupId(repository.getGroupId());
        baseRepository.setRepositoryId(repositoryId);
        baseRepository.setTypeSettingsProperties(repository.getTypeSettingsProperties());
        baseRepository.setUserLocalService(this.userLocalService);
    }
}

