/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.BaseRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Repository;
import com.liferay.portal.repository.util.RepositoryFactoryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.RepositoryServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLPermission;

public class RepositoryServiceImpl
extends RepositoryServiceBaseImpl {
    public long addRepository(long groupId, long classNameId, long parentFolderId, String name, String description, String portletId, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        DLPermission.check(this.getPermissionChecker(), groupId, "ADD_REPOSITORY");
        return this.repositoryLocalService.addRepository(this.getUserId(), groupId, classNameId, parentFolderId, name, description, portletId, typeSettingsProperties, serviceContext);
    }

    public void checkRepository(long repositoryId) throws PortalException, SystemException {
        Group group = this.groupPersistence.fetchByPrimaryKey(repositoryId);
        if (group != null) {
            return;
        }
        try {
            Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
            DLFolderPermission.check(this.getPermissionChecker(), repository.getGroupId(), repository.getDlFolderId(), "VIEW");
        }
        catch (NoSuchRepositoryException nsre) {
            throw new RepositoryException(nsre.getMessage());
        }
    }

    public void deleteRepository(long repositoryId) throws PortalException, SystemException {
        Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        DLFolderPermission.check(this.getPermissionChecker(), repository.getGroupId(), repository.getDlFolderId(), "DELETE");
        this.repositoryLocalService.deleteRepository(repository.getRepositoryId());
    }

    public LocalRepository getLocalRepositoryImpl(long repositoryId) throws PortalException, SystemException {
        this.checkRepository(repositoryId);
        return this.repositoryLocalService.getLocalRepositoryImpl(repositoryId);
    }

    public LocalRepository getLocalRepositoryImpl(long folderId, long fileEntryId, long fileVersionId) throws PortalException, SystemException {
        LocalRepository localRepositoryImpl = this.repositoryLocalService.getLocalRepositoryImpl(folderId, fileEntryId, fileVersionId);
        this.checkRepository(localRepositoryImpl.getRepositoryId());
        return localRepositoryImpl;
    }

    public Repository getRepository(long repositoryId) throws PortalException, SystemException {
        return this.repositoryPersistence.findByPrimaryKey(repositoryId);
    }

    public com.liferay.portal.kernel.repository.Repository getRepositoryImpl(long repositoryId) throws PortalException, SystemException {
        this.checkRepository(repositoryId);
        return this.repositoryLocalService.getRepositoryImpl(repositoryId);
    }

    public com.liferay.portal.kernel.repository.Repository getRepositoryImpl(long folderId, long fileEntryId, long fileVersionId) throws PortalException, SystemException {
        com.liferay.portal.kernel.repository.Repository repositoryImpl = this.repositoryLocalService.getRepositoryImpl(folderId, fileEntryId, fileVersionId);
        this.checkRepository(repositoryImpl.getRepositoryId());
        return repositoryImpl;
    }

    public String[] getSupportedConfigurations(long classNameId) throws SystemException {
        try {
            String repositoryImplClassName = PortalUtil.getClassName((long)classNameId);
            BaseRepository baseRepository = RepositoryFactoryUtil.getInstance(repositoryImplClassName);
            return baseRepository.getSupportedConfigurations();
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public String[] getSupportedParameters(long classNameId, String configuration) throws SystemException {
        try {
            String repositoryImplClassName = PortalUtil.getClassName((long)classNameId);
            BaseRepository baseRepository = RepositoryFactoryUtil.getInstance(repositoryImplClassName);
            String[] supportedConfigurations = baseRepository.getSupportedConfigurations();
            String[][] supportedParameters = baseRepository.getSupportedParameters();
            int i2 = 0;
            while (i2 < supportedConfigurations.length) {
                if (supportedConfigurations[i2].equals(configuration)) {
                    return supportedParameters[i2];
                }
                ++i2;
            }
            throw new RepositoryException("Configuration not found for repository with class name id " + classNameId);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public UnicodeProperties getTypeSettingsProperties(long repositoryId) throws PortalException, SystemException {
        this.checkRepository(repositoryId);
        return this.repositoryLocalService.getTypeSettingsProperties(repositoryId);
    }

    public void updateRepository(long repositoryId, String name, String description) throws PortalException, SystemException {
        Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        DLFolderPermission.check(this.getPermissionChecker(), repository.getGroupId(), repository.getDlFolderId(), "UPDATE");
        this.repositoryLocalService.updateRepository(repositoryId, name, description);
    }
}

