/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchResourceException;
import com.liferay.portal.ResourceActionsException;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.GroupedModel;
import com.liferay.portal.model.Permission;
import com.liferay.portal.model.PermissionedModel;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.ResourceCode;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.impl.ResourceImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.security.permission.PermissionsListFilter;
import com.liferay.portal.security.permission.PermissionsListFilterFactory;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.ResourceLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.ResourcePermissionsThreadLocal;
import com.liferay.portal.util.comparator.ResourceComparator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLocalServiceImpl
extends ResourceLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(ResourceLocalServiceImpl.class);

    public void addModelResources(AuditedModel auditedModel, ServiceContext serviceContext) throws PortalException, SystemException {
        ClassedModel classedModel = (ClassedModel)auditedModel;
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addResources(auditedModel.getCompanyId(), this.getGroupId(auditedModel), auditedModel.getUserId(), classedModel.getModelClassName(), String.valueOf(classedModel.getPrimaryKeyObj()), false, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions(), this.getPermissionedModel(auditedModel));
        } else {
            if (serviceContext.isDeriveDefaultPermissions()) {
                serviceContext.deriveDefaultPermissions(this.getGroupId(auditedModel), classedModel.getModelClassName());
            }
            this.addModelResources(auditedModel.getCompanyId(), this.getGroupId(auditedModel), auditedModel.getUserId(), classedModel.getModelClassName(), String.valueOf(classedModel.getPrimaryKeyObj()), serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions(), this.getPermissionedModel(auditedModel));
        }
    }

    public void addModelResources(long companyId, long groupId, long userId, String name, long primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.addModelResources(companyId, groupId, userId, name, String.valueOf(primKey), groupPermissions, guestPermissions, null);
    }

    public void addModelResources(long companyId, long groupId, long userId, String name, String primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.addModelResources(companyId, groupId, userId, name, primKey, groupPermissions, guestPermissions, null);
    }

    public Resource addResource(long companyId, String name, int scope, String primKey) throws SystemException {
        if (!PermissionThreadLocal.isAddResource()) {
            return null;
        }
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            return this.addResource_6(companyId, name, scope, primKey);
        }
        return this.addResource_1to5(companyId, name, scope, primKey);
    }

    public void addResources(long companyId, long groupId, long userId, String name, long primKey, boolean portletActions, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.addResources(companyId, groupId, userId, name, String.valueOf(primKey), portletActions, addGroupPermissions, addGuestPermissions, null);
    }

    public void addResources(long companyId, long groupId, long userId, String name, String primKey, boolean portletActions, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.addResources(companyId, groupId, userId, name, primKey, portletActions, addGroupPermissions, addGuestPermissions, null);
    }

    public void addResources(long companyId, long groupId, String name, boolean portletActions) throws PortalException, SystemException {
        this.addResources(companyId, groupId, 0L, name, null, portletActions, false, false);
    }

    public void deleteResource(AuditedModel auditedModel, int scope) throws PortalException, SystemException {
        ClassedModel classedModel = (ClassedModel)auditedModel;
        this.deleteResource(auditedModel.getCompanyId(), classedModel.getModelClassName(), scope, String.valueOf(classedModel.getPrimaryKeyObj()), this.getPermissionedModel(auditedModel));
    }

    @Override
    public Resource deleteResource(long resourceId) throws SystemException {
        Resource resource;
        block2: {
            resource = null;
            try {
                resource = this.resourcePersistence.findByPrimaryKey(resourceId);
                this.deleteResource(resource);
            }
            catch (NoSuchResourceException nsre) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)nsre);
            }
        }
        return resource;
    }

    public void deleteResource(long companyId, String name, int scope, long primKey) throws PortalException, SystemException {
        this.deleteResource(companyId, name, scope, String.valueOf(primKey), null);
    }

    public void deleteResource(long companyId, String name, int scope, String primKey) throws PortalException, SystemException {
        this.deleteResource(companyId, name, scope, primKey, null);
    }

    @Override
    public Resource deleteResource(Resource resource) throws SystemException {
        List permissions = this.permissionPersistence.findByResourceId(resource.getResourceId());
        for (Permission permission : permissions) {
            this.orgGroupPermissionPersistence.removeByPermissionId(permission.getPermissionId());
        }
        this.permissionPersistence.removeByResourceId(resource.getResourceId());
        return (Resource)this.resourcePersistence.remove((BaseModel)resource);
    }

    public void deleteResources(String name) throws SystemException {
        List resources = this.resourceFinder.findByName(name);
        for (Resource resource : resources) {
            this.deleteResource(resource);
        }
    }

    public Resource fetchResource(long companyId, String name, int scope, String primKey) throws SystemException {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            return this.getResource_6(companyId, name, scope, primKey);
        }
        return this.fetchResource_1to5(companyId, name, scope, primKey);
    }

    public long getLatestResourceId() throws SystemException {
        List resources = this.resourcePersistence.findAll(0, 1, (OrderByComparator)new ResourceComparator());
        if (resources.size() == 0) {
            return 0L;
        }
        Resource resource = (Resource)resources.get(0);
        return resource.getResourceId();
    }

    public Resource getResource(long companyId, String name, int scope, String primKey) throws PortalException, SystemException {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            return this.getResource_6(companyId, name, scope, primKey);
        }
        return this.getResource_1to5(companyId, name, scope, primKey);
    }

    public List<Resource> getResources() throws SystemException {
        return this.resourcePersistence.findAll();
    }

    public void updateModelResources(AuditedModel auditedModel, ServiceContext serviceContext) throws PortalException, SystemException {
        ClassedModel classedModel = (ClassedModel)auditedModel;
        this.updateResources(auditedModel.getCompanyId(), this.getGroupId(auditedModel), classedModel.getModelClassName(), String.valueOf(classedModel.getPrimaryKeyObj()), serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions(), this.getPermissionedModel(auditedModel));
    }

    public void updateResources(long companyId, long groupId, String name, long primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.updateResources(companyId, groupId, name, String.valueOf(primKey), groupPermissions, guestPermissions, null);
    }

    public void updateResources(long companyId, long groupId, String name, String primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.updateResources(companyId, groupId, name, primKey, groupPermissions, guestPermissions, null);
    }

    public void updateResources(long companyId, String name, int scope, String primKey, String newPrimKey) throws PortalException, SystemException {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            if (!this.resourceBlockLocalService.isSupported(name)) {
                this.updateResources_6(companyId, name, scope, primKey, newPrimKey);
            }
        } else {
            this.updateResources_1to5(companyId, name, scope, primKey, newPrimKey);
        }
    }

    protected void addGroupPermissions(long companyId, long groupId, long userId, String name, Resource resource, boolean portletActions, PermissionedModel permissionedModel) throws PortalException, SystemException {
        List actions = null;
        actions = portletActions ? ResourceActionsUtil.getPortletResourceGroupDefaultActions((String)name) : ResourceActionsUtil.getModelResourceGroupDefaultActions((String)name);
        String[] actionIds = actions.toArray(new String[actions.size()]);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            if (this.resourceBlockLocalService.isSupported(name)) {
                this.addGroupPermissions_6Blocks(groupId, resource, actions, permissionedModel);
            } else {
                this.addGroupPermissions_6(groupId, resource, actionIds);
            }
        } else {
            this.addGroupPermissions_1to5(companyId, groupId, userId, name, resource, portletActions, actionIds);
        }
    }

    protected void addGroupPermissions_1to5(long companyId, long groupId, long userId, String name, Resource resource, boolean portletActions, String[] actionIds) throws PortalException, SystemException {
        long resourceId = resource.getResourceId();
        String primKey = resource.getPrimKey();
        List groupPermissionsList = this.permissionLocalService.getPermissions(companyId, actionIds, resourceId);
        PermissionsListFilter permissionsListFilter = PermissionsListFilterFactory.getInstance();
        groupPermissionsList = permissionsListFilter.filterGroupPermissions(companyId, groupId, userId, name, primKey, portletActions, groupPermissionsList);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            Role role = this.roleLocalService.getDefaultGroupRole(groupId);
            this.rolePersistence.addPermissions(role.getRoleId(), groupPermissionsList);
        } else {
            this.groupPersistence.addPermissions(groupId, groupPermissionsList);
        }
    }

    protected void addGroupPermissions_6(long groupId, Resource resource, String[] actionIds) throws PortalException, SystemException {
        Role role = this.roleLocalService.getDefaultGroupRole(groupId);
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), actionIds);
    }

    protected void addGroupPermissions_6Blocks(long groupId, Resource resource, List<String> actionIds, PermissionedModel permissionedModel) throws PortalException, SystemException {
        if (permissionedModel == null) {
            throw new IllegalArgumentException("Permissioned model is null");
        }
        Role role = this.roleLocalService.getDefaultGroupRole(groupId);
        this.resourceBlockLocalService.setIndividualScopePermissions(resource.getCompanyId(), groupId, resource.getName(), permissionedModel, role.getRoleId(), actionIds);
    }

    protected void addGuestPermissions(long companyId, long groupId, long userId, String name, Resource resource, boolean portletActions, PermissionedModel permissionedModel) throws PortalException, SystemException {
        List actions = null;
        actions = portletActions ? ResourceActionsUtil.getPortletResourceGuestDefaultActions((String)name) : ResourceActionsUtil.getModelResourceGuestDefaultActions((String)name);
        String[] actionIds = actions.toArray(new String[actions.size()]);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            if (this.resourceBlockLocalService.isSupported(name)) {
                this.addGuestPermissions_6Blocks(companyId, groupId, resource, actions, permissionedModel);
            } else {
                this.addGuestPermissions_6(companyId, resource, actionIds);
            }
        } else {
            this.addGuestPermissions_1to5(companyId, groupId, userId, name, resource, portletActions, actionIds);
        }
    }

    protected void addGuestPermissions_1to5(long companyId, long groupId, long userId, String name, Resource resource, boolean portletActions, String[] actionIds) throws PortalException, SystemException {
        List guestPermissionsList = this.permissionLocalService.getPermissions(companyId, actionIds, resource.getResourceId());
        PermissionsListFilter permissionsListFilter = PermissionsListFilterFactory.getInstance();
        guestPermissionsList = permissionsListFilter.filterGuestPermissions(companyId, groupId, userId, name, resource.getPrimKey(), portletActions, guestPermissionsList);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
            this.rolePersistence.addPermissions(guestRole.getRoleId(), guestPermissionsList);
        } else {
            long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
            this.userPersistence.addPermissions(defaultUserId, guestPermissionsList);
        }
    }

    protected void addGuestPermissions_6(long companyId, Resource resource, String[] actionIds) throws PortalException, SystemException {
        Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), guestRole.getRoleId(), actionIds);
    }

    protected void addGuestPermissions_6Blocks(long companyId, long groupId, Resource resource, List<String> actionIds, PermissionedModel permissionedModel) throws PortalException, SystemException {
        if (permissionedModel == null) {
            throw new IllegalArgumentException("Permissioned model is null");
        }
        Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
        this.resourceBlockLocalService.setIndividualScopePermissions(resource.getCompanyId(), groupId, resource.getName(), permissionedModel, guestRole.getRoleId(), actionIds);
    }

    protected void addModelResources(long companyId, long groupId, long userId, String name, String primKey, String[] groupPermissions, String[] guestPermissions, PermissionedModel permissionedModel) throws PortalException, SystemException {
        if (!PermissionThreadLocal.isAddResource()) {
            return;
        }
        this.validate(name, false);
        this.addResource(companyId, name, 1, String.valueOf(companyId));
        long guestGroupId = this.getGuestGroupId(companyId);
        this.addResource(companyId, name, 2, String.valueOf(guestGroupId));
        if (groupId > 0L && guestGroupId != groupId) {
            this.addResource(companyId, name, 2, String.valueOf(groupId));
        }
        if (primKey == null) {
            return;
        }
        Resource resource = this.addResource(companyId, name, 4, primKey);
        boolean flushEnabled = PermissionThreadLocal.isFlushEnabled();
        PermissionThreadLocal.setIndexEnabled((boolean)false);
        try {
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                this.addModelResources_6(companyId, groupId, userId, resource, groupPermissions, guestPermissions, permissionedModel);
            } else {
                this.addModelResources_1to5(companyId, groupId, userId, resource, groupPermissions, guestPermissions);
            }
        }
        finally {
            PermissionThreadLocal.setIndexEnabled((boolean)flushEnabled);
            PermissionCacheUtil.clearCache();
            SearchEngineUtil.updatePermissionFields((String)name, (String)primKey);
        }
    }

    protected void addModelResources_1to5(long companyId, long groupId, long userId, Resource resource, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
        PermissionsListFilter permissionsListFilter = PermissionsListFilterFactory.getInstance();
        List permissionsList = this.permissionLocalService.addPermissions(companyId, resource.getName(), resource.getResourceId(), false);
        List userPermissionsList = permissionsListFilter.filterUserPermissions(companyId, groupId, userId, resource.getName(), resource.getPrimKey(), false, permissionsList);
        this.filterOwnerPermissions(resource.getName(), userPermissionsList);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            Role ownerRole = this.roleLocalService.getRole(companyId, "Owner");
            this.rolePersistence.addPermissions(ownerRole.getRoleId(), userPermissionsList);
        } else if (userId > 0L && userId != defaultUserId) {
            this.userPersistence.addPermissions(userId, userPermissionsList);
        }
        if (groupId > 0L) {
            if (groupPermissions == null) {
                groupPermissions = new String[]{};
            }
            List groupPermissionsList = this.permissionLocalService.getPermissions(companyId, groupPermissions, resource.getResourceId());
            groupPermissionsList = permissionsListFilter.filterGroupPermissions(companyId, groupId, userId, resource.getName(), resource.getPrimKey(), false, groupPermissionsList);
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                Role role = this.roleLocalService.getDefaultGroupRole(groupId);
                this.rolePersistence.addPermissions(role.getRoleId(), groupPermissionsList);
            } else {
                this.groupPersistence.addPermissions(groupId, groupPermissionsList);
            }
        }
        if (guestPermissions == null) {
            guestPermissions = new String[]{};
        }
        List guestPermissionsList = this.permissionLocalService.getPermissions(companyId, guestPermissions, resource.getResourceId());
        guestPermissionsList = permissionsListFilter.filterGuestPermissions(companyId, groupId, userId, resource.getName(), resource.getPrimKey(), false, guestPermissionsList);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
            this.rolePersistence.addPermissions(guestRole.getRoleId(), guestPermissionsList);
        } else {
            this.userPersistence.addPermissions(defaultUserId, guestPermissionsList);
        }
    }

    protected void addModelResources_6(long companyId, long groupId, long userId, Resource resource, String[] groupPermissions, String[] guestPermissions, PermissionedModel permissionedModel) throws PortalException, SystemException {
        Role ownerRole = this.roleLocalService.getRole(companyId, "Owner");
        List ownerActionIds = ResourceActionsUtil.getModelResourceActions((String)resource.getName());
        ownerActionIds = ListUtil.copy((List)ownerActionIds);
        this.filterOwnerActions(resource.getName(), ownerActionIds);
        String[] ownerPermissions = ownerActionIds.toArray(new String[ownerActionIds.size()]);
        Role defaultGroupRole = null;
        if (groupId > 0L) {
            defaultGroupRole = this.roleLocalService.getDefaultGroupRole(groupId);
            if (groupPermissions == null) {
                groupPermissions = new String[]{};
            }
        }
        Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
        if (guestPermissions == null) {
            guestPermissions = new String[]{};
        }
        if (this.resourceBlockLocalService.isSupported(resource.getName())) {
            if (permissionedModel == null) {
                throw new IllegalArgumentException("Permissioned model is null");
            }
            this.resourceBlockLocalService.setIndividualScopePermissions(resource.getCompanyId(), groupId, resource.getName(), permissionedModel, ownerRole.getRoleId(), ownerActionIds);
            if (groupId > 0L) {
                this.resourceBlockLocalService.setIndividualScopePermissions(resource.getCompanyId(), groupId, resource.getName(), permissionedModel, defaultGroupRole.getRoleId(), Arrays.asList(groupPermissions));
            }
            this.resourceBlockLocalService.setIndividualScopePermissions(resource.getCompanyId(), groupId, resource.getName(), permissionedModel, guestRole.getRoleId(), Arrays.asList(guestPermissions));
        } else {
            this.resourcePermissionLocalService.setOwnerResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), ownerRole.getRoleId(), userId, ownerPermissions);
            if (groupId > 0L) {
                this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), defaultGroupRole.getRoleId(), groupPermissions);
            }
            this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), guestRole.getRoleId(), guestPermissions);
        }
    }

    protected Resource addResource_1to5(long companyId, String name, int scope, String primKey) throws SystemException {
        Resource resource;
        block4: {
            ResourceCode resourceCode = this.resourceCodeLocalService.getResourceCode(companyId, name, scope);
            long codeId = resourceCode.getCodeId();
            resource = this.resourcePersistence.fetchByC_P(codeId, primKey);
            if (resource == null) {
                long resourceId = this.counterLocalService.increment(Resource.class.getName());
                resource = this.resourcePersistence.create(resourceId);
                resource.setCodeId(codeId);
                resource.setPrimKey(primKey);
                try {
                    this.resourcePersistence.update((BaseModel)resource, false);
                }
                catch (SystemException se) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Add failed, fetch {codeId=" + codeId + ", primKey=" + primKey + "}"));
                    }
                    if ((resource = this.resourcePersistence.fetchByC_P(codeId, primKey, false)) != null) break block4;
                    throw se;
                }
            }
        }
        return resource;
    }

    protected Resource addResource_6(long companyId, String name, int scope, String primKey) {
        ResourceImpl resource = new ResourceImpl();
        resource.setCompanyId(companyId);
        resource.setName(name);
        resource.setScope(scope);
        resource.setPrimKey(primKey);
        return resource;
    }

    protected void addResources(long companyId, long groupId, long userId, String name, String primKey, boolean portletActions, boolean addGroupPermissions, boolean addGuestPermissions, PermissionedModel permissionedModel) throws PortalException, SystemException {
        if (!PermissionThreadLocal.isAddResource()) {
            return;
        }
        this.validate(name, portletActions);
        this.addResource(companyId, name, 1, String.valueOf(companyId));
        if (groupId > 0L) {
            this.addResource(companyId, name, 2, String.valueOf(groupId));
        }
        if (primKey == null) {
            return;
        }
        Resource resource = this.addResource(companyId, name, 4, primKey);
        boolean flushEnabled = PermissionThreadLocal.isFlushEnabled();
        PermissionThreadLocal.setIndexEnabled((boolean)false);
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P(companyId, name, 4, primKey);
        ResourcePermissionsThreadLocal.setResourcePermissions(resourcePermissions);
        try {
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                this.addResources_6(companyId, groupId, userId, resource, portletActions, permissionedModel);
            } else {
                this.addResources_1to5(companyId, groupId, userId, resource, portletActions);
            }
            if (groupId > 0L && addGroupPermissions) {
                this.addGroupPermissions(companyId, groupId, userId, name, resource, portletActions, permissionedModel);
            }
            if (addGuestPermissions) {
                this.addGuestPermissions(companyId, groupId, userId, name, resource, portletActions, permissionedModel);
            }
        }
        finally {
            ResourcePermissionsThreadLocal.setResourcePermissions(null);
            PermissionThreadLocal.setIndexEnabled((boolean)flushEnabled);
            PermissionCacheUtil.clearCache();
            SearchEngineUtil.updatePermissionFields((String)name, (String)primKey);
        }
    }

    protected void addResources_1to5(long companyId, long groupId, long userId, Resource resource, boolean portletActions) throws PortalException, SystemException {
        List permissionsList = this.permissionLocalService.addPermissions(companyId, resource.getName(), resource.getResourceId(), portletActions);
        PermissionsListFilter permissionsListFilter = PermissionsListFilterFactory.getInstance();
        List userPermissionsList = permissionsListFilter.filterUserPermissions(companyId, groupId, userId, resource.getName(), resource.getPrimKey(), portletActions, permissionsList);
        this.filterOwnerPermissions(resource.getName(), userPermissionsList);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            Role ownerRole = this.roleLocalService.getRole(companyId, "Owner");
            this.rolePersistence.addPermissions(ownerRole.getRoleId(), userPermissionsList);
        } else {
            long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
            if (userId > 0L && userId != defaultUserId) {
                this.userPersistence.addPermissions(userId, userPermissionsList);
            }
        }
    }

    protected void addResources_6(long companyId, long groupId, long userId, Resource resource, boolean portletActions, PermissionedModel permissionedModel) throws PortalException, SystemException {
        List actionIds = null;
        if (portletActions) {
            actionIds = ResourceActionsUtil.getPortletResourceActions((String)resource.getName());
        } else {
            actionIds = ResourceActionsUtil.getModelResourceActions((String)resource.getName());
            actionIds = ListUtil.copy((List)actionIds);
            this.filterOwnerActions(resource.getName(), actionIds);
        }
        Role role = this.roleLocalService.getRole(companyId, "Owner");
        if (this.resourceBlockLocalService.isSupported(resource.getName())) {
            if (permissionedModel == null) {
                throw new IllegalArgumentException("Permissioned model is null");
            }
            this.resourceBlockLocalService.setIndividualScopePermissions(resource.getCompanyId(), groupId, resource.getName(), permissionedModel, role.getRoleId(), actionIds);
        } else {
            this.resourcePermissionLocalService.setOwnerResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), userId, actionIds.toArray(new String[actionIds.size()]));
        }
    }

    protected void deleteResource(long companyId, String name, int scope, String primKey, PermissionedModel permissionedModel) throws PortalException, SystemException {
        block5: {
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                if (this.resourceBlockLocalService.isSupported(name)) {
                    if (permissionedModel == null) {
                        throw new IllegalArgumentException("Permissioned model is null");
                    }
                    this.resourceBlockLocalService.releasePermissionedModelResourceBlock(permissionedModel);
                    return;
                }
                this.resourcePermissionLocalService.deleteResourcePermissions(companyId, name, scope, primKey);
                return;
            }
            try {
                Resource resource = this.getResource(companyId, name, scope, primKey);
                this.deleteResource(resource.getResourceId());
            }
            catch (NoSuchResourceException nsre) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Throwable)nsre);
            }
        }
    }

    protected Resource fetchResource_1to5(long companyId, String name, int scope, String primKey) throws SystemException {
        ResourceCode resourceCode = this.resourceCodeLocalService.getResourceCode(companyId, name, scope);
        return this.resourcePersistence.fetchByC_P(resourceCode.getCodeId(), primKey);
    }

    protected void filterOwnerActions(String name, List<String> actionIds) {
        List defaultOwnerActions = ResourceActionsUtil.getModelResourceOwnerDefaultActions((String)name);
        if (defaultOwnerActions.isEmpty()) {
            return;
        }
        Iterator<String> itr = actionIds.iterator();
        while (itr.hasNext()) {
            String actionId = itr.next();
            if (defaultOwnerActions.contains(actionId)) continue;
            itr.remove();
        }
    }

    protected void filterOwnerPermissions(String name, List<Permission> permissions) {
        List defaultOwnerActions = ResourceActionsUtil.getModelResourceOwnerDefaultActions((String)name);
        if (defaultOwnerActions.isEmpty()) {
            return;
        }
        Iterator<Permission> itr = permissions.iterator();
        while (itr.hasNext()) {
            Permission permission = itr.next();
            String actionId = permission.getActionId();
            if (defaultOwnerActions.contains(actionId)) continue;
            itr.remove();
        }
    }

    protected long getGroupId(AuditedModel auditedModel) {
        long groupId = 0L;
        if (auditedModel instanceof GroupedModel) {
            GroupedModel groupedModel = (GroupedModel)auditedModel;
            groupId = groupedModel.getGroupId();
        }
        return groupId;
    }

    protected long getGuestGroupId(long companyId) throws NoSuchGroupException {
        long guestGroupId = 0L;
        try {
            Group guestGroup = this.groupLocalService.getGroup(companyId, "Guest");
            return guestGroup.getGroupId();
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2.getMessage());
            }
            if ((guestGroupId = this.getGuestGroupIdBySQL(companyId)) > 0L) {
                return guestGroupId;
            }
            StringBundler sb = new StringBundler(5);
            sb.append("No Group exists with the key {companyId=");
            sb.append(companyId);
            sb.append(", name=");
            sb.append("Guest");
            sb.append("}");
            throw new NoSuchGroupException(sb.toString());
        }
    }

    protected long getGuestGroupIdBySQL(long companyId) {
        block7: {
            Connection con = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                con = DataAccess.getConnection();
                StringBundler sb = new StringBundler(5);
                sb.append("select groupId from Group_ where companyId = ");
                sb.append(companyId);
                sb.append(" and name = '");
                sb.append("Guest");
                sb.append("'");
                ps = con.prepareStatement(sb.toString());
                rs = ps.executeQuery();
                if (rs.next()) {
                    long l = rs.getLong("groupId");
                    DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
                    return l;
                }
            }
            catch (SQLException sqle) {
                _log.error((Object)sqle, (Throwable)sqle);
                break block7;
            }
            finally {
                DataAccess.cleanUp((Connection)con, ps, rs);
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        }
        return 0L;
    }

    protected PermissionedModel getPermissionedModel(AuditedModel auditedModel) {
        PermissionedModel permissionedModel = null;
        if (auditedModel instanceof PermissionedModel) {
            permissionedModel = (PermissionedModel)auditedModel;
        }
        return permissionedModel;
    }

    protected Resource getResource_1to5(long companyId, String name, int scope, String primKey) throws PortalException, SystemException {
        ResourceCode resourceCode = this.resourceCodeLocalService.getResourceCode(companyId, name, scope);
        return this.resourcePersistence.findByC_P(resourceCode.getCodeId(), primKey);
    }

    protected Resource getResource_6(long companyId, String name, int scope, String primKey) {
        ResourceImpl resource = new ResourceImpl();
        resource.setCompanyId(companyId);
        resource.setName(name);
        resource.setScope(scope);
        resource.setPrimKey(primKey);
        return resource;
    }

    protected void updateResources(long companyId, long groupId, String name, String primKey, String[] groupPermissions, String[] guestPermissions, PermissionedModel permissionedModel) throws PortalException, SystemException {
        Resource resource = this.getResource(companyId, name, 4, primKey);
        if (groupPermissions == null) {
            groupPermissions = new String[]{};
        }
        if (guestPermissions == null) {
            guestPermissions = new String[]{};
        }
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            if (this.resourceBlockLocalService.isSupported(name)) {
                this.updateResources_6Blocks(companyId, groupId, resource, groupPermissions, guestPermissions, permissionedModel);
            } else {
                this.updateResources_6(companyId, groupId, resource, groupPermissions, guestPermissions);
            }
        } else {
            this.updateResources_1to5(companyId, groupId, resource, groupPermissions, guestPermissions);
        }
    }

    protected void updateResources_1to5(long companyId, long groupId, Resource resource, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        Role role = this.roleLocalService.getDefaultGroupRole(groupId);
        this.permissionLocalService.setRolePermissions(role.getRoleId(), groupPermissions, resource.getResourceId());
        role = this.roleLocalService.getRole(companyId, "Guest");
        this.permissionLocalService.setRolePermissions(role.getRoleId(), guestPermissions, resource.getResourceId());
    }

    protected void updateResources_1to5(long companyId, String name, int scope, String primKey, String newPrimKey) throws PortalException, SystemException {
        Resource resource = this.getResource(companyId, name, scope, primKey);
        resource.setPrimKey(newPrimKey);
        this.resourcePersistence.update((BaseModel)resource, false);
    }

    protected void updateResources_6(long companyId, long groupId, Resource resource, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        Role role = this.roleLocalService.getDefaultGroupRole(groupId);
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), groupPermissions);
        role = this.roleLocalService.getRole(companyId, "Guest");
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), guestPermissions);
    }

    protected void updateResources_6(long companyId, String name, int scope, String primKey, String newPrimKey) throws SystemException {
        List resourcePermissions = this.resourcePermissionLocalService.getResourcePermissions(companyId, name, scope, primKey);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            resourcePermission.setPrimKey(newPrimKey);
            this.resourcePermissionPersistence.update((BaseModel)resourcePermission, false);
        }
    }

    protected void updateResources_6Blocks(long companyId, long groupId, Resource resource, String[] groupPermissions, String[] guestPermissions, PermissionedModel permissionedModel) throws PortalException, SystemException {
        if (permissionedModel == null) {
            throw new IllegalArgumentException("Permissioned model is null");
        }
        Role role = this.roleLocalService.getDefaultGroupRole(groupId);
        this.resourceBlockLocalService.setIndividualScopePermissions(companyId, groupId, resource.getName(), permissionedModel, role.getRoleId(), Arrays.asList(groupPermissions));
        role = this.roleLocalService.getRole(companyId, "Guest");
        this.resourceBlockLocalService.setIndividualScopePermissions(companyId, groupId, resource.getName(), permissionedModel, role.getRoleId(), Arrays.asList(guestPermissions));
    }

    protected void validate(String name, boolean portletActions) throws PortalException {
        List actions = null;
        actions = portletActions ? ResourceActionsUtil.getPortletResourceActions((String)name) : ResourceActionsUtil.getModelResourceActions((String)name);
        if (actions.size() == 0) {
            throw new ResourceActionsException("There are no actions associated with the resource " + name);
        }
    }
}

