/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.DuplicateTeamException;
import com.liferay.portal.TeamNameException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.User;
import com.liferay.portal.service.base.TeamLocalServiceBaseImpl;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamLocalServiceImpl
extends TeamLocalServiceBaseImpl {
    public Team addTeam(long userId, long groupId, String name, String description) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        this.validate(0L, groupId, name);
        long teamId = this.counterLocalService.increment();
        Team team = this.teamPersistence.create(teamId);
        team.setUserId(userId);
        team.setCompanyId(user.getCompanyId());
        team.setUserName(user.getFullName());
        team.setCreateDate(now);
        team.setModifiedDate(now);
        team.setGroupId(groupId);
        team.setName(name);
        team.setDescription(description);
        this.teamPersistence.update((BaseModel)team, false);
        this.resourceLocalService.addResources(user.getCompanyId(), groupId, userId, Team.class.getName(), team.getTeamId(), false, true, true);
        this.roleLocalService.addRole(userId, user.getCompanyId(), String.valueOf(teamId), null, null, 4, Team.class.getName(), teamId);
        return team;
    }

    @Override
    public Team deleteTeam(long teamId) throws PortalException, SystemException {
        Team team = this.teamPersistence.findByPrimaryKey(teamId);
        return this.deleteTeam(team);
    }

    @Override
    public Team deleteTeam(Team team) throws PortalException, SystemException {
        this.teamPersistence.remove((BaseModel)team);
        this.resourceLocalService.deleteResource(team.getCompanyId(), Team.class.getName(), 4, team.getTeamId());
        Role role = team.getRole();
        this.roleLocalService.deleteRole(role);
        return team;
    }

    public void deleteTeams(long groupId) throws PortalException, SystemException {
        List teams = this.teamPersistence.findByGroupId(groupId);
        for (Team team : teams) {
            this.deleteTeam(team.getTeamId());
        }
    }

    public List<Team> getGroupTeams(long groupId) throws SystemException {
        return this.teamPersistence.findByGroupId(groupId);
    }

    public Team getTeam(long groupId, String name) throws PortalException, SystemException {
        return this.teamPersistence.findByG_N(groupId, name);
    }

    public List<Team> getUserTeams(long userId) throws SystemException {
        return this.userPersistence.getTeams(userId);
    }

    public List<Team> getUserTeams(long userId, long groupId) throws SystemException {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersTeams", userId);
        return this.search(groupId, null, null, params, -1, -1, null);
    }

    public boolean hasUserTeam(long userId, long teamId) throws SystemException {
        return this.userPersistence.containsTeam(userId, teamId);
    }

    public List<Team> search(long groupId, String name, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        return this.teamFinder.findByG_N_D(groupId, name, description, params, start, end, obc);
    }

    public int searchCount(long groupId, String name, String description, LinkedHashMap<String, Object> params) throws SystemException {
        return this.teamFinder.countByG_N_D(groupId, name, description, params);
    }

    public Team updateTeam(long teamId, String name, String description) throws PortalException, SystemException {
        Date now = new Date();
        Team team = this.teamPersistence.findByPrimaryKey(teamId);
        this.validate(teamId, team.getGroupId(), name);
        team.setModifiedDate(now);
        team.setName(name);
        team.setDescription(description);
        this.teamPersistence.update((BaseModel)team, false);
        return team;
    }

    protected void validate(long teamId, long groupId, String name) throws PortalException, SystemException {
        if (Validator.isNull((String)name) || Validator.isNumber((String)name) || name.indexOf(44) != -1 || name.indexOf(42) != -1) {
            throw new TeamNameException();
        }
        Team team = this.teamPersistence.fetchByG_N(groupId, name);
        if (team != null && (teamId <= 0L || team.getTeamId() != teamId)) {
            throw new DuplicateTeamException();
        }
    }
}

