/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.impl.VirtualLayout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.PortletPermission;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.sites.util.SitesUtil;
import java.util.Collection;
import java.util.List;
import javax.portlet.PortletMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletPermissionImpl
implements PortletPermission {
    public static final boolean DEFAULT_STRICT = false;
    private static Log _log = LogFactoryUtil.getLog(PortletPermissionImpl.class);

    public void check(PermissionChecker permissionChecker, Layout layout, String portletId, String actionId) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, 0L, layout, portletId, actionId, false)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, Layout layout, String portletId, String actionId, boolean strict) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, 0L, layout, portletId, actionId, strict)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, long groupId, Layout layout, String portletId, String actionId) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, groupId, layout, portletId, actionId, false)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, long groupId, Layout layout, String portletId, String actionId, boolean strict) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, groupId, layout, portletId, actionId, strict)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, long groupId, long plid, String portletId, String actionId) throws PortalException, SystemException {
        this.check(permissionChecker, groupId, plid, portletId, actionId, false);
    }

    public void check(PermissionChecker permissionChecker, long groupId, long plid, String portletId, String actionId, boolean strict) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, groupId, plid, portletId, actionId, strict)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, long plid, String portletId, String actionId) throws PortalException, SystemException {
        this.check(permissionChecker, plid, portletId, actionId, false);
    }

    public void check(PermissionChecker permissionChecker, long plid, String portletId, String actionId, boolean strict) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, plid, portletId, actionId, strict)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, String portletId, String actionId) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, portletId, actionId)) {
            throw new PrincipalException();
        }
    }

    public boolean contains(PermissionChecker permissionChecker, Layout layout, Portlet portlet, String actionId) throws PortalException, SystemException {
        return this.contains(permissionChecker, layout, portlet, actionId, false);
    }

    public boolean contains(PermissionChecker permissionChecker, Layout layout, Portlet portlet, String actionId, boolean strict) throws PortalException, SystemException {
        return this.contains(permissionChecker, 0L, layout, portlet, actionId, strict);
    }

    public boolean contains(PermissionChecker permissionChecker, Layout layout, String portletId, String actionId) throws PortalException, SystemException {
        return this.contains(permissionChecker, layout, portletId, actionId, false);
    }

    public boolean contains(PermissionChecker permissionChecker, Layout layout, String portletId, String actionId, boolean strict) throws PortalException, SystemException {
        return this.contains(permissionChecker, 0L, layout, portletId, actionId, strict);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, Layout layout, Portlet portlet, String actionId) throws PortalException, SystemException {
        return this.contains(permissionChecker, groupId, layout, portlet, actionId, false);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, Layout layout, Portlet portlet, String actionId, boolean strict) throws PortalException, SystemException {
        if (portlet.isUndeployedPortlet()) {
            return false;
        }
        if (portlet.isSystem() && actionId.equals("VIEW")) {
            return true;
        }
        return this.contains(permissionChecker, groupId, layout, portlet.getPortletId(), actionId, strict);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, Layout layout, String portletId, String actionId) throws PortalException, SystemException {
        return this.contains(permissionChecker, groupId, layout, portletId, actionId, false);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, Layout layout, String portletId, String actionId, boolean strict) throws PortalException, SystemException {
        String name = null;
        String primKey = null;
        if (layout == null) {
            name = portletId;
            primKey = portletId;
            return permissionChecker.hasPermission(groupId, name, primKey, actionId);
        }
        Group group = layout.getGroup();
        groupId = group.getGroupId();
        name = PortletConstants.getRootPortletId((String)portletId);
        primKey = this.getPrimaryKey(layout.getPlid(), portletId);
        if (!actionId.equals("VIEW") && layout instanceof VirtualLayout) {
            return this.hasCustomizePermission(permissionChecker, layout, portletId, actionId);
        }
        if (!group.isLayoutSetPrototype() && !SitesUtil.isLayoutUpdateable(layout) && actionId.equals("CONFIGURATION")) {
            return false;
        }
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)groupId, (String)name, (long)groupId, (String)name, (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        if (actionId.equals("VIEW") && group.isControlPanel()) {
            return true;
        }
        if (strict) {
            return permissionChecker.hasPermission(groupId, name, primKey, actionId);
        }
        if (this.hasConfigurePermission(permissionChecker, layout, portletId, actionId) || this.hasCustomizePermission(permissionChecker, layout, portletId, actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(groupId, name, primKey, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, long plid, Collection<Portlet> portlets, String actionId) {
        for (Portlet portlet : portlets) {
            if (!permissionChecker.hasPermission(groupId, portlet.getPortletId(), portlet.getPortletId(), "ACCESS_IN_CONTROL_PANEL")) continue;
            return true;
        }
        return false;
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, long plid, Portlet portlet, String actionId) throws PortalException, SystemException {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        return this.contains(permissionChecker, groupId, layout, portlet, actionId, false);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, long plid, Portlet portlet, String actionId, boolean strict) throws PortalException, SystemException {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        return this.contains(permissionChecker, groupId, layout, portlet, actionId, strict);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, long plid, String portletId, String actionId) throws PortalException, SystemException {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        return this.contains(permissionChecker, groupId, layout, portletId, actionId, false);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, long plid, String portletId, String actionId, boolean strict) throws PortalException, SystemException {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        return this.contains(permissionChecker, groupId, layout, portletId, actionId, strict);
    }

    public boolean contains(PermissionChecker permissionChecker, long plid, Portlet portlet, String actionId) throws PortalException, SystemException {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        return this.contains(permissionChecker, layout, portlet, actionId, false);
    }

    public boolean contains(PermissionChecker permissionChecker, long plid, Portlet portlet, String actionId, boolean strict) throws PortalException, SystemException {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        return this.contains(permissionChecker, 0L, layout, portlet, actionId, strict);
    }

    public boolean contains(PermissionChecker permissionChecker, long plid, String portletId, String actionId) throws PortalException, SystemException {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        return this.contains(permissionChecker, layout, portletId, actionId, false);
    }

    public boolean contains(PermissionChecker permissionChecker, long plid, String portletId, String actionId, boolean strict) throws PortalException, SystemException {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        return this.contains(permissionChecker, 0L, layout, portletId, actionId, strict);
    }

    public boolean contains(PermissionChecker permissionChecker, String portletId, String actionId) throws PortalException, SystemException {
        return this.contains(permissionChecker, 0L, portletId, actionId);
    }

    public String getPrimaryKey(long plid, String portletId) {
        return String.valueOf(plid).concat("_LAYOUT_").concat(portletId);
    }

    public boolean hasAccessPermission(PermissionChecker permissionChecker, long scopeGroupId, Layout layout, Portlet portlet, PortletMode portletMode) throws PortalException, SystemException {
        boolean access;
        String category;
        if (layout != null && layout.isTypeControlPanel() && Validator.equals((Object)(category = portlet.getControlPanelEntryCategory()), (Object)"content")) {
            layout = null;
        }
        if ((access = this.contains(permissionChecker, scopeGroupId, layout, portlet, "VIEW")) && !PropsValues.TCK_URL && portletMode.equals((Object)PortletMode.EDIT)) {
            access = this.contains(permissionChecker, scopeGroupId, layout, portlet, "PREFERENCES");
        }
        return access;
    }

    public boolean hasLayoutManagerPermission(String portletId, String actionId) {
        try {
            portletId = PortletConstants.getRootPortletId((String)portletId);
            List layoutManagerActions = ResourceActionsUtil.getPortletResourceLayoutManagerActions((String)portletId);
            return layoutManagerActions.contains(actionId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return false;
        }
    }

    protected boolean hasConfigurePermission(PermissionChecker permissionChecker, Layout layout, String portletId, String actionId) throws PortalException, SystemException {
        if (!(actionId.equals("CONFIGURATION") || actionId.equals("PREFERENCES") || actionId.equals("GUEST_PREFERENCES"))) {
            return false;
        }
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId);
        if (portlet.isPreferencesUniquePerLayout()) {
            return LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"CONFIGURE_PORTLETS");
        }
        return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)layout.getGroupId(), (String)"CONFIGURE_PORTLETS");
    }

    protected boolean hasCustomizePermission(PermissionChecker permissionChecker, Layout layout, String portletId, String actionId) throws PortalException, SystemException {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        if (layoutTypePortlet.isCustomizedView() && layoutTypePortlet.isPortletCustomizable(portletId) && LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"CUSTOMIZE")) {
            Portlet portlet;
            if (actionId.equals("VIEW")) {
                return true;
            }
            if (actionId.equals("CONFIGURATION") && (portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId)).isPreferencesUniquePerLayout()) {
                return true;
            }
        }
        return false;
    }
}

