/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.persistence.OrganizationFinder;
import com.liferay.portal.service.persistence.OrganizationUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizationFinderImpl
extends BasePersistenceImpl<Organization>
implements OrganizationFinder {
    public static final String COUNT_BY_ORGANIZATION_ID = String.valueOf(OrganizationFinder.class.getName()) + ".countByOrganizationId";
    public static final String COUNT_BY_C_PO_N_S_C_Z_R_C = String.valueOf(OrganizationFinder.class.getName()) + ".countByC_PO_N_S_C_Z_R_C";
    public static final String COUNT_BY_C_PO_N_L_S_C_Z_R_C = String.valueOf(OrganizationFinder.class.getName()) + ".countByC_PO_N_L_S_C_Z_R_C";
    public static final String FIND_BY_COMPANY_ID = String.valueOf(OrganizationFinder.class.getName()) + ".findByCompanyId";
    public static final String FIND_BY_C_PO_N_S_C_Z_R_C = String.valueOf(OrganizationFinder.class.getName()) + ".findByC_PO_N_S_C_Z_R_C";
    public static final String FIND_BY_C_PO_N_L_S_C_Z_R_C = String.valueOf(OrganizationFinder.class.getName()) + ".findByC_PO_N_L_S_C_Z_R_C";
    public static final String JOIN_BY_GROUPS_PERMISSIONS = String.valueOf(OrganizationFinder.class.getName()) + ".joinByGroupsPermissions";
    public static final String JOIN_BY_ORGANIZATIONS_GROUPS = String.valueOf(OrganizationFinder.class.getName()) + ".joinByOrganizationsGroups";
    public static final String JOIN_BY_ORGANIZATIONS_PASSWORD_POLICIES = String.valueOf(OrganizationFinder.class.getName()) + ".joinByOrganizationsPasswordPolicies";
    public static final String JOIN_BY_ORGANIZATIONS_ROLES = String.valueOf(OrganizationFinder.class.getName()) + ".joinByOrganizationsRoles";
    public static final String JOIN_BY_ORGANIZATIONS_USERS = String.valueOf(OrganizationFinder.class.getName()) + ".joinByOrganizationsUsers";
    public static final String JOIN_BY_ORG_GROUP_PERMISSION = String.valueOf(OrganizationFinder.class.getName()) + ".joinByOrgGroupPermission";
    public static final String JOIN_BY_USERS_ORGS = String.valueOf(OrganizationFinder.class.getName()) + ".joinByUsersOrgs";
    protected static final String COUNTRY_ID_SQL = "((Organization_.countryId = ?) OR (Address.countryId = ?)) [$AND_OR_CONNECTOR$]";
    protected static final String REGION_ID_SQL = "((Organization_.regionId = ?) OR (Address.regionId = ?)) [$AND_OR_CONNECTOR$]";

    public int countByKeywords(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String keywords, String type, Long regionId, Long countryId, LinkedHashMap<String, Object> params) throws SystemException {
        String[] names = null;
        String[] streets = null;
        String[] cities = null;
        String[] zips = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            names = CustomSQLUtil.keywords((String)keywords);
            streets = CustomSQLUtil.keywords((String)keywords);
            cities = CustomSQLUtil.keywords((String)keywords);
            zips = CustomSQLUtil.keywords((String)keywords);
        } else {
            andOperator = true;
        }
        return this.countByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, names, type, streets, cities, zips, regionId, countryId, params, andOperator);
    }

    public int countByO_U(long organizationId, long userId) throws SystemException {
        LinkedHashMap<String, Object> params1 = new LinkedHashMap<String, Object>();
        params1.put("usersOrgs", userId);
        Session session = null;
        try {
            int count;
            session = this.openSession();
            int n = count = this.countByOrganizationId(session, organizationId, params1);
            return n;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByC_PO_N_T_S_C_Z_R_C(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        String[] names = CustomSQLUtil.keywords((String)name);
        String[] streets = CustomSQLUtil.keywords((String)street);
        String[] cities = CustomSQLUtil.keywords((String)city);
        String[] zips = CustomSQLUtil.keywords((String)zip);
        return this.countByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, names, type, streets, cities, zips, regionId, countryId, params, andOperator);
    }

    public int countByC_PO_N_T_S_C_Z_R_C(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String[] names, String type, String[] streets, String[] cities, String[] zips, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        names = CustomSQLUtil.keywords((String[])names);
        streets = CustomSQLUtil.keywords((String[])streets);
        cities = CustomSQLUtil.keywords((String[])cities);
        zips = CustomSQLUtil.keywords((String[])zips);
        if (params != null) {
            Long resourceId = (Long)params.get("permissionsResourceId");
            Long groupId = (Long)params.get("permissionsGroupId");
            if (Validator.isNotNull((Long)groupId) && Validator.isNotNull((Long)resourceId)) {
                return this.countByPermissions(companyId, parentOrganizationId, parentOrganizationIdComparator, names, type, streets, cities, zips, regionId, countryId, resourceId, groupId, andOperator);
            }
        }
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = null;
            sql = Validator.isNotNull((String)type) ? CustomSQLUtil.get((String)COUNT_BY_C_PO_N_L_S_C_Z_R_C) : CustomSQLUtil.get((String)COUNT_BY_C_PO_N_S_C_Z_R_C);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Organization_.name)", (String)"LIKE", (boolean)false, (String[])names);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street1)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street2)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street3)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.city)", (String)"LIKE", (boolean)false, (String[])cities);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.zip)", (String)"LIKE", (boolean)true, (String[])zips);
            if (regionId == null) {
                sql = StringUtil.replace((String)sql, (String)REGION_ID_SQL, (String)"");
            }
            if (countryId == null) {
                sql = StringUtil.replace((String)sql, (String)COUNTRY_ID_SQL, (String)"");
            }
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
            sql = StringUtil.replace((String)sql, (String)"[$PARENT_ORGANIZATION_ID_COMPARATOR$]", (String)(parentOrganizationIdComparator.equals("=") ? "=" : "!="));
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params);
            qPos.add(companyId);
            qPos.add(parentOrganizationId);
            if (Validator.isNotNull((String)type)) {
                qPos.add(type);
            }
            qPos.add(names, 2);
            qPos.add(streets, 6);
            if (regionId != null) {
                qPos.add(regionId);
                qPos.add(regionId);
            }
            if (countryId != null) {
                qPos.add(countryId);
                qPos.add(countryId);
            }
            qPos.add(cities, 2);
            qPos.add(zips, 2);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Organization> findByCompanyId(long companyId, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        if (params == null) {
            params = new LinkedHashMap();
        }
        StringBundler sb = new StringBundler();
        sb.append("(");
        String sql = CustomSQLUtil.get((String)FIND_BY_COMPANY_ID);
        sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
        sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
        sb.append(sql);
        sb.append(")");
        sql = sb.toString();
        sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)true);
        sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("orgId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params);
            qPos.add(companyId);
            ArrayList<Organization> organizations = new ArrayList<Organization>();
            Iterator itr = QueryUtil.iterate((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            while (itr.hasNext()) {
                Long organizationId = (Long)itr.next();
                Organization organization = OrganizationUtil.findByPrimaryKey((long)organizationId);
                organizations.add(organization);
            }
            ArrayList<Organization> arrayList = organizations;
            return arrayList;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Organization> findByKeywords(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String keywords, String type, Long regionId, Long countryId, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        String[] names = null;
        String[] streets = null;
        String[] cities = null;
        String[] zips = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            names = CustomSQLUtil.keywords((String)keywords);
            streets = CustomSQLUtil.keywords((String)keywords);
            cities = CustomSQLUtil.keywords((String)keywords);
            zips = CustomSQLUtil.keywords((String)keywords);
        } else {
            andOperator = true;
        }
        return this.findByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, names, type, streets, cities, zips, regionId, countryId, params, andOperator, start, end, obc);
    }

    public List<Organization> findByC_PO_N_T_S_C_Z_R_C(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        String[] names = CustomSQLUtil.keywords((String)name);
        String[] streets = CustomSQLUtil.keywords((String)street);
        String[] cities = CustomSQLUtil.keywords((String)city);
        String[] zips = CustomSQLUtil.keywords((String)zip);
        return this.findByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, names, type, streets, cities, zips, regionId, countryId, params, andOperator, start, end, obc);
    }

    public List<Organization> findByC_PO_N_T_S_C_Z_R_C(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String[] names, String type, String[] streets, String[] cities, String[] zips, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        names = CustomSQLUtil.keywords((String[])names);
        streets = CustomSQLUtil.keywords((String[])streets);
        cities = CustomSQLUtil.keywords((String[])cities);
        zips = CustomSQLUtil.keywords((String[])zips);
        if (params != null) {
            Long resourceId = (Long)params.get("permissionsResourceId");
            Long groupId = (Long)params.get("permissionsGroupId");
            if (Validator.isNotNull((Long)groupId) && Validator.isNotNull((Long)resourceId)) {
                return this.findByPermissions(companyId, parentOrganizationId, parentOrganizationIdComparator, names, type, streets, cities, zips, regionId, countryId, resourceId, groupId, andOperator, start, end, obc);
            }
        } else {
            params = new LinkedHashMap();
        }
        StringBundler sb = new StringBundler();
        sb.append("(");
        if (Validator.isNotNull((String)type)) {
            sb.append(CustomSQLUtil.get((String)FIND_BY_C_PO_N_L_S_C_Z_R_C));
        } else {
            sb.append(CustomSQLUtil.get((String)FIND_BY_C_PO_N_S_C_Z_R_C));
        }
        String sql = sb.toString();
        sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
        sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
        sql = sql.concat(")");
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Organization_.name)", (String)"LIKE", (boolean)false, (String[])names);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street1)", (String)"LIKE", (boolean)true, (String[])streets);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street2)", (String)"LIKE", (boolean)true, (String[])streets);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street3)", (String)"LIKE", (boolean)true, (String[])streets);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.city)", (String)"LIKE", (boolean)false, (String[])cities);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.zip)", (String)"LIKE", (boolean)true, (String[])zips);
        sql = StringUtil.replace((String)sql, (String)"[$PARENT_ORGANIZATION_ID_COMPARATOR$]", (String)(parentOrganizationIdComparator.equals("=") ? "=" : "!="));
        if (regionId == null) {
            sql = StringUtil.replace((String)sql, (String)REGION_ID_SQL, (String)"");
        }
        if (countryId == null) {
            sql = StringUtil.replace((String)sql, (String)COUNTRY_ID_SQL, (String)"");
        }
        sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
        sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("orgId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params);
            qPos.add(companyId);
            qPos.add(parentOrganizationId);
            if (Validator.isNotNull((String)type)) {
                qPos.add(type);
            }
            qPos.add(names, 2);
            qPos.add(streets, 6);
            if (regionId != null) {
                qPos.add(regionId);
                qPos.add(regionId);
            }
            if (countryId != null) {
                qPos.add(countryId);
                qPos.add(countryId);
            }
            qPos.add(cities, 2);
            qPos.add(zips, 2);
            ArrayList<Organization> organizations = new ArrayList<Organization>();
            Iterator itr = QueryUtil.iterate((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            while (itr.hasNext()) {
                Long organizationId = (Long)itr.next();
                Organization organization = OrganizationUtil.findByPrimaryKey((long)organizationId);
                organizations.add(organization);
            }
            ArrayList<Organization> arrayList = organizations;
            return arrayList;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int countByOrganizationId(Session session, long organizationId, LinkedHashMap<String, Object> params) {
        Long count;
        String sql = CustomSQLUtil.get((String)COUNT_BY_ORGANIZATION_ID);
        sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
        sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
        SQLQuery q = session.createSQLQuery(sql);
        q.addScalar("COUNT_VALUE", Type.LONG);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        this.setJoin(qPos, params);
        qPos.add(organizationId);
        Iterator itr = q.iterate();
        if (itr.hasNext() && (count = (Long)itr.next()) != null) {
            return count.intValue();
        }
        return 0;
    }

    protected int countByPermissions(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String[] names, String type, String[] streets, String[] cities, String[] zips, Long regionId, Long countryId, long resourceId, long groupId, boolean andOperator) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            StringBundler sb = new StringBundler();
            sb.append("(");
            if (Validator.isNotNull((String)type)) {
                sb.append(CustomSQLUtil.get((String)COUNT_BY_C_PO_N_L_S_C_Z_R_C));
            } else {
                sb.append(CustomSQLUtil.get((String)COUNT_BY_C_PO_N_S_C_Z_R_C));
            }
            String sql = sb.toString();
            if (regionId == null) {
                sql = StringUtil.replace((String)sql, (String)REGION_ID_SQL, (String)"");
            }
            if (countryId == null) {
                sql = StringUtil.replace((String)sql, (String)COUNTRY_ID_SQL, (String)"");
            }
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin("groupsPermissions"));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere("groupsPermissions"));
            sb.setIndex(0);
            sb.append(sql);
            sb.append(") UNION (");
            if (Validator.isNotNull((String)type)) {
                sb.append(CustomSQLUtil.get((String)COUNT_BY_C_PO_N_L_S_C_Z_R_C));
            } else {
                sb.append(CustomSQLUtil.get((String)COUNT_BY_C_PO_N_S_C_Z_R_C));
            }
            sql = sb.toString();
            if (regionId == null) {
                sql = StringUtil.replace((String)sql, (String)REGION_ID_SQL, (String)"");
            }
            if (countryId == null) {
                sql = StringUtil.replace((String)sql, (String)COUNTRY_ID_SQL, (String)"");
            }
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin("orgGroupPermission"));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere("orgGroupPermission"));
            sql = StringUtil.replace((String)sql, (String)"[$PARENT_ORGANIZATION_ID_COMPARATOR$]", (String)parentOrganizationIdComparator);
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
            sb.setIndex(0);
            sb.append(sql);
            sb.append(")");
            sql = sb.toString();
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Organization_.name)", (String)"LIKE", (boolean)false, (String[])names);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street1)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street2)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street3)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.city)", (String)"LIKE", (boolean)false, (String[])cities);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.zip)", (String)"LIKE", (boolean)true, (String[])zips);
            if (regionId == null) {
                sql = StringUtil.replace((String)sql, (String)REGION_ID_SQL, (String)"");
            }
            if (countryId == null) {
                sql = StringUtil.replace((String)sql, (String)COUNTRY_ID_SQL, (String)"");
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            int i2 = 0;
            while (i2 < 2) {
                qPos.add(resourceId);
                if (i2 == 1) {
                    qPos.add(groupId);
                }
                qPos.add(companyId);
                qPos.add(parentOrganizationId);
                if (Validator.isNotNull((String)type)) {
                    qPos.add(type);
                }
                qPos.add(names, 2);
                qPos.add(streets, 6);
                if (regionId != null) {
                    qPos.add(regionId);
                    qPos.add(regionId);
                }
                if (countryId != null) {
                    qPos.add(countryId);
                    qPos.add(countryId);
                }
                qPos.add(cities, 2);
                qPos.add(zips, 2);
                ++i2;
            }
            int count = 0;
            Iterator itr = q.iterate();
            while (itr.hasNext()) {
                Long l = (Long)itr.next();
                if (l == null) continue;
                count += l.intValue();
            }
            int n = count;
            return n;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Organization> findByPermissions(long companyId, long parentOrganizationId, String parentOrganizationIdComparator, String[] names, String type, String[] streets, String[] cities, String[] zips, Long regionId, Long countryId, long resourceId, long groupId, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            StringBundler sb = new StringBundler();
            sb.append("(");
            if (Validator.isNotNull((String)type)) {
                sb.append(CustomSQLUtil.get((String)FIND_BY_C_PO_N_L_S_C_Z_R_C));
            } else {
                sb.append(CustomSQLUtil.get((String)FIND_BY_C_PO_N_S_C_Z_R_C));
            }
            String sql = sb.toString();
            if (regionId == null) {
                sql = StringUtil.replace((String)sql, (String)REGION_ID_SQL, (String)"");
            }
            if (countryId == null) {
                sql = StringUtil.replace((String)sql, (String)COUNTRY_ID_SQL, (String)"");
            }
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin("groupsPermissions"));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere("groupsPermissions"));
            sb.setIndex(0);
            sb.append(sql);
            sb.append(") UNION (");
            if (Validator.isNotNull((String)type)) {
                sb.append(CustomSQLUtil.get((String)FIND_BY_C_PO_N_L_S_C_Z_R_C));
            } else {
                sb.append(CustomSQLUtil.get((String)FIND_BY_C_PO_N_S_C_Z_R_C));
            }
            sql = sb.toString();
            if (regionId == null) {
                sql = StringUtil.replace((String)sql, (String)REGION_ID_SQL, (String)"");
            }
            if (countryId == null) {
                sql = StringUtil.replace((String)sql, (String)COUNTRY_ID_SQL, (String)"");
            }
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin("orgGroupPermission"));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere("orgGroupPermission"));
            sql = StringUtil.replace((String)sql, (String)"[$PARENT_ORGANIZATION_ID_COMPARATOR$]", (String)parentOrganizationIdComparator);
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
            sb.setIndex(0);
            sb.append(sql);
            sb.append(") ");
            sql = sb.toString();
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Organization_.name)", (String)"LIKE", (boolean)false, (String[])names);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street1)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street2)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.street3)", (String)"LIKE", (boolean)true, (String[])streets);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.city)", (String)"LIKE", (boolean)false, (String[])cities);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(Address.zip)", (String)"LIKE", (boolean)true, (String[])zips);
            if (regionId == null) {
                sql = StringUtil.replace((String)sql, (String)REGION_ID_SQL, (String)"");
            }
            if (countryId == null) {
                sql = StringUtil.replace((String)sql, (String)COUNTRY_ID_SQL, (String)"");
            }
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("orgId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            int i2 = 0;
            while (i2 < 2) {
                qPos.add(resourceId);
                if (i2 == 1) {
                    qPos.add(groupId);
                }
                qPos.add(companyId);
                qPos.add(parentOrganizationId);
                if (Validator.isNotNull((String)type)) {
                    qPos.add(type);
                }
                qPos.add(names, 2);
                qPos.add(streets, 6);
                if (regionId != null) {
                    qPos.add(regionId);
                    qPos.add(regionId);
                }
                if (countryId != null) {
                    qPos.add(countryId);
                    qPos.add(countryId);
                }
                qPos.add(cities, 2);
                qPos.add(zips, 2);
                ++i2;
            }
            ArrayList<Organization> organizations = new ArrayList<Organization>();
            Iterator itr = QueryUtil.iterate((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            while (itr.hasNext()) {
                Long organizationId = (Long)itr.next();
                Organization organization = OrganizationUtil.findByPrimaryKey((long)organizationId);
                organizations.add(organization);
            }
            ArrayList<Organization> arrayList = organizations;
            return arrayList;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getJoin(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (key.equals("expandoAttributes") || !Validator.isNotNull((Object)(value = entry.getValue()))) continue;
            sb.append(this.getJoin(key));
        }
        return sb.toString();
    }

    protected String getJoin(String key) {
        int pos;
        String join = "";
        if (key.equals("groupsPermissions")) {
            join = CustomSQLUtil.get((String)JOIN_BY_GROUPS_PERMISSIONS);
        } else if (key.equals("organizationsGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORGANIZATIONS_GROUPS);
        } else if (key.equals("organizationsPasswordPolicies")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORGANIZATIONS_PASSWORD_POLICIES);
        } else if (key.equals("organizationsRoles")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORGANIZATIONS_ROLES);
        } else if (key.equals("organizationsUsers")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORGANIZATIONS_USERS);
        } else if (key.equals("orgGroupPermission")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORG_GROUP_PERMISSION);
        } else if (key.equals("usersOrgs")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_ORGS);
        }
        if (Validator.isNotNull((String)join) && (pos = join.indexOf("WHERE")) != -1) {
            join = join.substring(0, pos);
        }
        return join;
    }

    protected String getWhere(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (key.equals("expandoAttributes") || !Validator.isNotNull((Object)(value = entry.getValue()))) continue;
            sb.append(this.getWhere(key, value));
        }
        return sb.toString();
    }

    protected String getWhere(String key) {
        return this.getWhere(key, null);
    }

    protected String getWhere(String key, Object value) {
        String join = "";
        if (key.equals("groupsPermissions")) {
            join = CustomSQLUtil.get((String)JOIN_BY_GROUPS_PERMISSIONS);
        } else if (key.equals("organizations")) {
            Long[] organizationIds = (Long[])value;
            if (organizationIds.length == 0) {
                join = "WHERE ((Organization_.organizationId = -1) )";
            } else {
                StringBundler sb = new StringBundler(organizationIds.length * 2 + 1);
                sb.append("WHERE (");
                int i2 = 0;
                while (i2 < organizationIds.length) {
                    sb.append("(Organization_.organizationId = ?) ");
                    if (i2 + 1 < organizationIds.length) {
                        sb.append("OR ");
                    }
                    ++i2;
                }
                sb.append(")");
                join = sb.toString();
            }
        } else if (key.equals("organizationsGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORGANIZATIONS_GROUPS);
        } else if (key.equals("organizationsPasswordPolicies")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORGANIZATIONS_PASSWORD_POLICIES);
        } else if (key.equals("organizationsRoles")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORGANIZATIONS_ROLES);
        } else if (key.equals("organizationsTree")) {
            List organizationsTree = (List)value;
            int size = organizationsTree.size();
            if (!organizationsTree.isEmpty()) {
                StringBundler sb = new StringBundler(size * 2 + 1);
                sb.append("WHERE (");
                int i3 = 0;
                while (i3 < size) {
                    sb.append("(Organization_.treePath LIKE ?) ");
                    if (i3 + 1 < size) {
                        sb.append("OR ");
                    }
                    ++i3;
                }
                sb.append(")");
                join = sb.toString();
            }
        } else if (key.equals("organizationsUsers")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORGANIZATIONS_USERS);
        } else if (key.equals("orgGroupPermission")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ORG_GROUP_PERMISSION);
        } else if (key.equals("usersOrgs")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_ORGS);
        }
        if (Validator.isNotNull((String)join)) {
            int pos = join.indexOf("WHERE");
            join = pos != -1 ? join.substring(pos + 5, join.length()).concat(" AND ") : "";
        }
        return join;
    }

    protected void setJoin(QueryPos qPos, LinkedHashMap<String, Object> params) {
        if (params == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String valueString;
            Long[] longArray;
            String key = entry.getKey();
            if (key.equals("expandoAttributes")) continue;
            Object value = entry.getValue();
            if (key.equals("organizationsTree")) {
                List organizationsTree = (List)value;
                if (organizationsTree.isEmpty()) continue;
                for (Organization organization : organizationsTree) {
                    StringBundler sb = new StringBundler(5);
                    sb.append("%");
                    sb.append("/");
                    sb.append(organization.getOrganizationId());
                    sb.append("/");
                    sb.append("%");
                    qPos.add(sb.toString());
                }
                continue;
            }
            if (value instanceof Long) {
                Long valueLong = (Long)value;
                if (!Validator.isNotNull((Long)valueLong)) continue;
                qPos.add(valueLong);
                continue;
            }
            if (value instanceof Long[]) {
                Long[] valueArray;
                longArray = valueArray = (Long[])value;
                int n = valueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Long element = longArray[n2];
                    if (Validator.isNotNull((Long)element)) {
                        qPos.add(element);
                    }
                    ++n2;
                }
                continue;
            }
            if (value instanceof Long[][]) {
                Long[][] valueDoubleArray = (Long[][])value;
                longArray = valueDoubleArray;
                int n = valueDoubleArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Long valueArray;
                    Long l = valueArray = longArray[n3];
                    int n4 = ((Long)l).length;
                    int n5 = 0;
                    while (n5 < n4) {
                        Long valueLong = l[n5];
                        qPos.add(valueLong);
                        ++n5;
                    }
                    ++n3;
                }
                continue;
            }
            if (!(value instanceof String) || !Validator.isNotNull((String)(valueString = (String)value))) continue;
            qPos.add(valueString);
        }
    }
}

