/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Permission;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.impl.PermissionImpl;
import com.liferay.portal.model.impl.PermissionModelImpl;
import com.liferay.portal.service.persistence.PermissionFinder;
import com.liferay.portal.service.persistence.PermissionPersistenceImpl;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionFinderImpl
extends BasePersistenceImpl<Permission>
implements PermissionFinder {
    public static final String COUNT_BY_GROUPS_PERMISSIONS = String.valueOf(PermissionFinder.class.getName()) + ".countByGroupsPermissions";
    public static final String COUNT_BY_GROUPS_ROLES = String.valueOf(PermissionFinder.class.getName()) + ".countByGroupsRoles";
    public static final String COUNT_BY_ROLES_PERMISSIONS = String.valueOf(PermissionFinder.class.getName()) + ".countByRolesPermissions";
    public static final String COUNT_BY_USER_GROUP_ROLE = String.valueOf(PermissionFinder.class.getName()) + ".countByUserGroupRole";
    public static final String COUNT_BY_USERS_PERMISSIONS = String.valueOf(PermissionFinder.class.getName()) + ".countByUsersPermissions";
    public static final String COUNT_BY_USERS_ROLES = String.valueOf(PermissionFinder.class.getName()) + ".countByUsersRoles";
    public static final String COUNT_BY_R_A_C = String.valueOf(PermissionFinder.class.getName()) + ".countByR_A_C";
    public static final String FIND_BY_A_C = String.valueOf(PermissionFinder.class.getName()) + ".findByA_C";
    public static final String FIND_BY_A_R = String.valueOf(PermissionFinder.class.getName()) + ".findByA_R";
    public static final String FIND_BY_G_R = String.valueOf(PermissionFinder.class.getName()) + ".findByG_R";
    public static final String FIND_BY_R_R = String.valueOf(PermissionFinder.class.getName()) + ".findByR_R";
    public static final String FIND_BY_R_S = String.valueOf(PermissionFinder.class.getName()) + ".findByR_S";
    public static final String FIND_BY_U_R = String.valueOf(PermissionFinder.class.getName()) + ".findByU_R";
    public static final String FIND_BY_O_G_R = String.valueOf(PermissionFinder.class.getName()) + ".findByO_G_R";
    public static final String FIND_BY_U_A_R = String.valueOf(PermissionFinder.class.getName()) + ".findByU_A_R";
    public static final String FIND_BY_G_C_N_S_P = String.valueOf(PermissionFinder.class.getName()) + ".findByG_C_N_S_P";
    public static final String FIND_BY_U_C_N_S_P = String.valueOf(PermissionFinder.class.getName()) + ".findByU_C_N_S_P";
    public static final FinderPath FINDER_PATH_COUNT_BY_ROLES_PERMISSIONS = new FinderPath(PermissionModelImpl.ENTITY_CACHE_ENABLED, PermissionModelImpl.FINDER_CACHE_ENABLED, Long.class, "Roles_Permissions", "customCountByRolesPermissions", new String[]{List.class.getName(), List.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_A_R = new FinderPath(PermissionModelImpl.ENTITY_CACHE_ENABLED, PermissionModelImpl.FINDER_CACHE_ENABLED, PermissionImpl.class, PermissionPersistenceImpl.FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "customFindByA_R", new String[]{String.class.getName(), "[L" + Long.class.getName()});

    public boolean containsPermissions_2(List<Permission> permissions, long userId, List<Group> groups, long groupId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = null;
            StringBundler sb = new StringBundler();
            if (groups.size() > 0) {
                sb.append("(");
                sb.append(CustomSQLUtil.get((String)COUNT_BY_GROUPS_ROLES));
                sb.append(") ");
                sql = sb.toString();
                sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_ID$]", (String)this.getPermissionIds(permissions, "Roles_Permissions"));
                sql = StringUtil.replace((String)sql, (String)"[$GROUP_ID$]", (String)this.getGroupIds(groups, "Groups_Roles"));
                sb.setIndex(0);
                sb.append(sql);
                sb.append("UNION ALL (");
                sb.append(CustomSQLUtil.get((String)COUNT_BY_GROUPS_PERMISSIONS));
                sb.append(") ");
                sql = sb.toString();
                sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_ID$]", (String)this.getPermissionIds(permissions, "Groups_Permissions"));
                sql = StringUtil.replace((String)sql, (String)"[$GROUP_ID$]", (String)this.getGroupIds(groups, "Groups_Permissions"));
                sb.setIndex(0);
                sb.append(sql);
                sb.append("UNION ALL ");
            }
            sb.append("(");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_USERS_ROLES));
            sb.append(") ");
            sql = sb.toString();
            sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_ID$]", (String)this.getPermissionIds(permissions, "Roles_Permissions"));
            sb.setIndex(0);
            sb.append(sql);
            sb.append("UNION ALL (");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_USER_GROUP_ROLE));
            sb.append(") ");
            sql = sb.toString();
            sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_ID$]", (String)this.getPermissionIds(permissions, "Roles_Permissions"));
            sb.setIndex(0);
            sb.append(sql);
            sb.append("UNION ALL (");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_USERS_PERMISSIONS));
            sb.append(") ");
            sql = sb.toString();
            sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_ID$]", (String)this.getPermissionIds(permissions, "Users_Permissions"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            if (groups.size() > 0) {
                this.setPermissionIds(qPos, permissions);
                this.setGroupIds(qPos, groups);
                this.setPermissionIds(qPos, permissions);
                this.setGroupIds(qPos, groups);
            }
            this.setPermissionIds(qPos, permissions);
            qPos.add(userId);
            qPos.add(groupId);
            this.setPermissionIds(qPos, permissions);
            qPos.add(userId);
            this.setPermissionIds(qPos, permissions);
            qPos.add(userId);
            Iterator itr = q.iterate();
            while (itr.hasNext()) {
                Long count = (Long)itr.next();
                if (count == null || count.intValue() <= 0) continue;
                return true;
            }
            return false;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public boolean containsPermissions_4(List<Permission> permissions, long userId, List<Group> groups, List<Role> roles) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = null;
            StringBundler sb = new StringBundler();
            if (groups.size() > 0) {
                sb.append("(");
                sb.append(CustomSQLUtil.get((String)COUNT_BY_GROUPS_PERMISSIONS));
                sb.append(") ");
                sql = sb.toString();
                sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_ID$]", (String)this.getPermissionIds(permissions, "Groups_Permissions"));
                sql = StringUtil.replace((String)sql, (String)"[$GROUP_ID$]", (String)this.getGroupIds(groups, "Groups_Permissions"));
                sb.setIndex(0);
                sb.append(sql);
                sb.append("UNION ALL ");
            }
            if (roles.size() > 0) {
                sb.append("(");
                sb.append(CustomSQLUtil.get((String)COUNT_BY_ROLES_PERMISSIONS));
                sb.append(") ");
                sql = sb.toString();
                sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_ID$]", (String)this.getPermissionIds(permissions, "Roles_Permissions"));
                sql = StringUtil.replace((String)sql, (String)"[$ROLE_ID$]", (String)this.getRoleIds(roles, "Roles_Permissions"));
                sb.setIndex(0);
                sb.append(sql);
                sb.append("UNION ALL ");
            }
            sb.append("(");
            sb.append(CustomSQLUtil.get((String)COUNT_BY_USERS_PERMISSIONS));
            sb.append(") ");
            sql = sb.toString();
            sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_ID$]", (String)this.getPermissionIds(permissions, "Users_Permissions"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            if (groups.size() > 0) {
                this.setPermissionIds(qPos, permissions);
                this.setGroupIds(qPos, groups);
            }
            if (roles.size() > 0) {
                this.setPermissionIds(qPos, permissions);
                this.setRoleIds(qPos, roles);
            }
            this.setPermissionIds(qPos, permissions);
            qPos.add(userId);
            Iterator itr = q.iterate();
            while (itr.hasNext()) {
                Long count = (Long)itr.next();
                if (count == null || count.intValue() <= 0) continue;
                return true;
            }
            return false;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByGroupsPermissions(List<Permission> permissions, List<Group> groups) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_GROUPS_PERMISSIONS);
            sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_ID$]", (String)this.getPermissionIds(permissions, "Groups_Permissions"));
            sql = StringUtil.replace((String)sql, (String)"[$GROUP_ID$]", (String)this.getGroupIds(groups, "Groups_Permissions"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setPermissionIds(qPos, permissions);
            this.setGroupIds(qPos, groups);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByGroupsRoles(List<Permission> permissions, List<Group> groups) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_GROUPS_ROLES);
            sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_ID$]", (String)this.getPermissionIds(permissions, "Roles_Permissions"));
            sql = StringUtil.replace((String)sql, (String)"[$GROUP_ID$]", (String)this.getGroupIds(groups, "Groups_Roles"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setPermissionIds(qPos, permissions);
            this.setGroupIds(qPos, groups);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByRolesPermissions(List<Permission> permissions, List<Role> roles) throws SystemException {
        Object[] finderArgs = new Object[]{ListUtil.toString(permissions, (Accessor)Permission.PERMISSION_ID_ACCESSOR), ListUtil.toString(roles, (Accessor)Role.ROLE_ID_ACCESSOR)};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_ROLES_PERMISSIONS, (Object[])finderArgs, (SessionFactory)this);
        if (count != null) {
            return count.intValue();
        }
        Session session = null;
        try {
            try {
                session = this.openSession();
                String sql = CustomSQLUtil.get((String)COUNT_BY_ROLES_PERMISSIONS);
                sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_ID$]", (String)this.getPermissionIds(permissions, "Roles_Permissions"));
                sql = StringUtil.replace((String)sql, (String)"[$ROLE_ID$]", (String)this.getRoleIds(roles, "Roles_Permissions"));
                SQLQuery q = session.createSQLQuery(sql);
                q.addScalar("COUNT_VALUE", Type.LONG);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                this.setPermissionIds(qPos, permissions);
                this.setRoleIds(qPos, roles);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e2) {
                throw new SystemException((Throwable)e2);
            }
        }
        finally {
            if (count == null) {
                count = 0L;
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_ROLES_PERMISSIONS, (Object[])finderArgs, (Object)count);
            this.closeSession(session);
        }
        return count.intValue();
    }

    public int countByUserGroupRole(List<Permission> permissions, long userId, long groupId) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_USER_GROUP_ROLE);
            sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_ID$]", (String)this.getPermissionIds(permissions, "Roles_Permissions"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            this.setPermissionIds(qPos, permissions);
            qPos.add(userId);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByUsersPermissions(List<Permission> permissions, long userId) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_USERS_PERMISSIONS);
            sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_ID$]", (String)this.getPermissionIds(permissions, "Users_Permissions"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setPermissionIds(qPos, permissions);
            qPos.add(userId);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByUsersRoles(List<Permission> permissions, long userId) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_USERS_ROLES);
            sql = StringUtil.replace((String)sql, (String)"[$PERMISSION_ID$]", (String)this.getPermissionIds(permissions, "Roles_Permissions"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setPermissionIds(qPos, permissions);
            qPos.add(userId);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByR_A_C(long roleId, String actionId, long codeId) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_R_A_C);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(roleId);
            qPos.add(actionId);
            qPos.add(codeId);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Permission> findByA_C(String actionId, long codeId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_A_C);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Permission_", PermissionImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(actionId);
            qPos.add(codeId);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Permission> findByA_R(String actionId, long[] resourceIds) throws SystemException {
        Object[] finderArgs = new Object[]{actionId, StringUtil.merge((Object[])ArrayUtil.toArray((long[])resourceIds))};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_A_R, (Object[])finderArgs, (SessionFactory)this);
        if (list != null && !list.isEmpty()) {
            for (Permission permission : list) {
                if (Validator.equals((Object)actionId, (Object)permission.getActionId()) && ArrayUtil.contains((long[])resourceIds, (long)permission.getResourceId())) continue;
                list = null;
                break;
            }
        }
        if (list != null) {
            return list;
        }
        Session session = null;
        try {
            try {
                session = this.openSession();
                String sql = CustomSQLUtil.get((String)FIND_BY_A_R);
                sql = StringUtil.replace((String)sql, (String)"[$RESOURCE_ID$]", (String)this.getResourceIds(resourceIds));
                SQLQuery q = session.createSQLQuery(sql);
                q.addEntity("Permission_", PermissionImpl.class);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(actionId);
                this.setResourceIds(qPos, resourceIds);
                list = q.list(true);
            }
            catch (Exception e2) {
                throw new SystemException((Throwable)e2);
            }
        }
        finally {
            if (list == null) {
                list = new ArrayList();
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_A_R, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public List<Permission> findByG_R(long groupId, long resourceId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_R);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Permission_", PermissionImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(resourceId);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Permission> findByR_R(long roleId, long resourceId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_R_R);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Permission_", PermissionImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(roleId);
            qPos.add(resourceId);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Permission> findByR_S(long roleId, int[] scopes) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_R_S);
            sql = StringUtil.replace((String)sql, (String)"[$SCOPE$]", (String)this.getScopes(scopes));
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Permission_", PermissionImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(roleId);
            qPos.add(scopes);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Permission> findByU_R(long userId, long resourceId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_U_R);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Permission_", PermissionImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(userId);
            qPos.add(resourceId);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Permission> findByO_G_R(long organizationId, long groupId, long resourceId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_O_G_R);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Permission_", PermissionImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(organizationId);
            qPos.add(groupId);
            qPos.add(resourceId);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Permission> findByU_A_R(long userId, String[] actionIds, long resourceId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_U_R);
            sql = StringUtil.replace((String)sql, (String)"[$ACTION_ID$]", (String)this.getActionIds(actionIds));
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Permission_", PermissionImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(userId);
            qPos.add(resourceId);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Permission> findByG_C_N_S_P(long groupId, long companyId, String name, int scope, String primKey) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_C_N_S_P);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Permission_", PermissionImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(companyId);
            qPos.add(name);
            qPos.add(scope);
            qPos.add(primKey);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Permission> findByU_C_N_S_P(long userId, long companyId, String name, int scope, String primKey) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_U_C_N_S_P);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Permission_", PermissionImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(userId);
            qPos.add(companyId);
            qPos.add(name);
            qPos.add(scope);
            qPos.add(primKey);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getActionIds(String[] actionIds) {
        if (actionIds.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(actionIds.length * 2 - 1);
        int i2 = 0;
        while (i2 < actionIds.length) {
            sb.append("Permission_.actionId = ?");
            if (i2 + 1 < actionIds.length) {
                sb.append(" OR ");
            }
            ++i2;
        }
        return sb.toString();
    }

    protected String getGroupIds(List<Group> groups, String table) {
        if (groups.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(groups.size() * 3 - 1);
        int i2 = 0;
        while (i2 < groups.size()) {
            sb.append(table);
            sb.append(".groupId = ?");
            if (i2 + 1 < groups.size()) {
                sb.append(" OR ");
            }
            ++i2;
        }
        return sb.toString();
    }

    protected String getPermissionIds(List<Permission> permissions, String table) {
        if (permissions.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(permissions.size() * 3 - 1);
        int i2 = 0;
        while (i2 < permissions.size()) {
            sb.append(table);
            sb.append(".permissionId = ?");
            if (i2 + 1 < permissions.size()) {
                sb.append(" OR ");
            }
            ++i2;
        }
        return sb.toString();
    }

    protected String getResourceIds(long[] resourceIds) {
        if (resourceIds.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(resourceIds.length * 2 - 1);
        int i2 = 0;
        while (i2 < resourceIds.length) {
            sb.append("resourceId = ?");
            if (i2 + 1 < resourceIds.length) {
                sb.append(" OR ");
            }
            ++i2;
        }
        return sb.toString();
    }

    protected String getRoleIds(List<Role> roles, String table) {
        if (roles.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(roles.size() * 3 - 1);
        int i2 = 0;
        while (i2 < roles.size()) {
            sb.append(table);
            sb.append(".roleId = ?");
            if (i2 + 1 < roles.size()) {
                sb.append(" OR ");
            }
            ++i2;
        }
        return sb.toString();
    }

    protected String getScopes(int[] scopes) {
        if (scopes.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(scopes.length * 2 + 1);
        sb.append("(");
        int i2 = 0;
        while (i2 < scopes.length) {
            sb.append("ResourceCode.scope = ? ");
            if (i2 + 1 != scopes.length) {
                sb.append("OR ");
            }
            ++i2;
        }
        sb.append(")");
        return sb.toString();
    }

    protected void setGroupIds(QueryPos qPos, List<Group> groups) {
        for (Group group : groups) {
            qPos.add(group.getGroupId());
        }
    }

    protected void setPermissionIds(QueryPos qPos, List<Permission> permissions) {
        for (Permission permission : permissions) {
            qPos.add(permission.getPermissionId());
        }
    }

    protected void setResourceIds(QueryPos qPos, long[] resourceIds) {
        long[] lArray = resourceIds;
        int n = resourceIds.length;
        int n2 = 0;
        while (n2 < n) {
            long resourceId = lArray[n2];
            qPos.add(resourceId);
            ++n2;
        }
    }

    protected void setRoleIds(QueryPos qPos, List<Role> roles) {
        for (Role role : roles) {
            qPos.add(role.getRoleId());
        }
    }
}

