/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.impl.ResourceImpl;
import com.liferay.portal.service.persistence.ResourceFinder;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFinderImpl
extends BasePersistenceImpl<Resource>
implements ResourceFinder {
    public static final String FIND_BY_CONTAINER_RESOURCE = String.valueOf(ResourceFinder.class.getName()) + ".findByContainerResource";
    public static final String FIND_BY_NAME = String.valueOf(ResourceFinder.class.getName()) + ".findByName";
    public static final String FIND_BY_NO_ACTIONS = String.valueOf(ResourceFinder.class.getName()) + ".findByNoActions";
    public static final String FIND_BY_C_P = String.valueOf(ResourceFinder.class.getName()) + ".findByC_P";
    public static final String FIND_BY_N_S = String.valueOf(ResourceFinder.class.getName()) + ".findByN_S";

    public List<Resource> findByContainerResource(long codeId, long classNameId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_CONTAINER_RESOURCE);
            if (classNameId != 0L) {
                sql = sql.concat(" WHERE Group_.classNameId = " + classNameId);
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Resource_", ResourceImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(codeId);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Resource> findByName(String name) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NAME);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Resource_", ResourceImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(name);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Resource> findByNoActions(long codeId, String actionId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_ACTIONS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Resource_", ResourceImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(actionId);
            qPos.add(codeId);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Resource> findByC_P(long companyId, String primKey) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_P);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Resource_", ResourceImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(primKey);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Resource> findByN_S(String name, int scope) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_N_S);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Resource_", ResourceImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(name);
            qPos.add(scope);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }
}

