/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.impl.TeamImpl;
import com.liferay.portal.service.persistence.TeamFinder;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamFinderImpl
extends BasePersistenceImpl<Team>
implements TeamFinder {
    public static final String COUNT_BY_G_N_D = String.valueOf(TeamFinder.class.getName()) + ".countByG_N_D";
    public static final String FIND_BY_G_N_D = String.valueOf(TeamFinder.class.getName()) + ".findByG_N_D";
    public static final String JOIN_BY_USERS_TEAMS = String.valueOf(TeamFinder.class.getName()) + ".joinByUsersTeams";
    public static final String JOIN_BY_USERS_USER_GROUPS = String.valueOf(TeamFinder.class.getName()) + ".joinByUsersUserGroups";

    public int countByG_N_D(long groupId, String name, String description, LinkedHashMap<String, Object> params) throws SystemException {
        name = StringUtil.lowerCase((String)name);
        description = StringUtil.lowerCase((String)description);
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_N_D);
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params);
            qPos.add(groupId);
            qPos.add(name);
            qPos.add(name);
            qPos.add(description);
            qPos.add(description);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Team> findByG_N_D(long groupId, String name, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        name = StringUtil.lowerCase((String)name);
        description = StringUtil.lowerCase((String)description);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_N_D);
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
            sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Team", TeamImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params);
            qPos.add(groupId);
            qPos.add(name);
            qPos.add(name);
            qPos.add(description);
            qPos.add(description);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getJoin(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!Validator.isNotNull((Object)value)) continue;
            sb.append(this.getJoin(key));
        }
        return sb.toString();
    }

    protected String getJoin(String key) {
        int pos;
        String join = "";
        if (key.equals("usersUserGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_USER_GROUPS);
        } else if (key.equals("usersTeams")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_TEAMS);
        }
        if (Validator.isNotNull((String)join) && (pos = join.indexOf("WHERE")) != -1) {
            join = join.substring(0, pos);
        }
        return join;
    }

    protected String getWhere(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!Validator.isNotNull((Object)value)) continue;
            sb.append(this.getWhere(key));
        }
        return sb.toString();
    }

    protected String getWhere(String key) {
        String join = "";
        if (key.equals("usersUserGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_USER_GROUPS);
        } else if (key.equals("usersTeams")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_TEAMS);
        }
        if (Validator.isNotNull((String)join)) {
            int pos = join.indexOf("WHERE");
            join = pos != -1 ? join.substring(pos + 5, join.length()).concat(" AND ") : "";
        }
        return join;
    }

    protected void setJoin(QueryPos qPos, LinkedHashMap<String, Object> params) {
        if (params == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Long valueLong;
            Object value = entry.getValue();
            if (!(value instanceof Long) || !Validator.isNotNull((Long)(valueLong = (Long)value))) continue;
            qPos.add(valueLong);
        }
    }
}

