/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.atom.AtomProvider;
import com.liferay.portal.atom.AtomUtil;
import com.liferay.portal.kernel.atom.AtomCollectionAdapter;
import com.liferay.portal.kernel.atom.AtomCollectionAdapterRegistryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.servlet.UserResolver;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.abdera.protocol.server.Provider;
import org.apache.abdera.protocol.server.servlet.AbderaServlet;

public class AtomServlet
extends AbderaServlet {
    private static Log _log = LogFactoryUtil.getLog(AtomServlet.class);

    protected Provider createProvider() {
        AtomProvider atomProvider = new AtomProvider();
        atomProvider.init(this.getAbdera(), null);
        List atomCollectionAdapters = AtomCollectionAdapterRegistryUtil.getAtomCollectionAdapters();
        for (AtomCollectionAdapter atomCollectionAdapter : atomCollectionAdapters) {
            atomProvider.addCollection(atomCollectionAdapter);
        }
        return atomProvider;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            UserResolver userResolver = new UserResolver(request);
            CompanyThreadLocal.setCompanyId((Long)userResolver.getCompanyId());
            User user = userResolver.getUser();
            if (user != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("User " + user.getUserId()));
                }
                PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
                PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
                AtomUtil.saveUserInRequest(request, user);
            }
            super.service(request, response);
        }
        catch (Exception e2) {
            throw new ServletException((Throwable)e2);
        }
    }
}

