/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.servlet.BrowserSniffer;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class BrowserSnifferImpl
implements BrowserSniffer {
    private static final String[] _FIREFOX_ALIASES = new String[]{"firefox", "minefield", "granparadiso", "bonecho", "firebird", "phoenix", "camino"};
    private static final String[] _WEBKIT_ALIASES = new String[]{"khtml", "applewebkit"};
    private static final String[] _WINDOWS_ALIASES = new String[]{"windows", "win32", "16bit"};
    private static Pattern _majorVersionPattern = Pattern.compile("(\\d+[.]\\d+)");
    private static Pattern _revisionPattern = Pattern.compile("(?:rv|it|ra|ie)[\\/: ]([\\d.]+)");
    private static Pattern _versionChromePattern = Pattern.compile("(?:chrome)[\\/]([\\d.]+)");
    private static Pattern _versionFirefoxPattern = Pattern.compile("(?:firefox|minefield)[\\/]([\\d.]+)");
    private static Pattern _versionPattern = Pattern.compile("(?:version)[\\/]([\\d.]+)");

    public boolean acceptsGzip(HttpServletRequest request) {
        String acceptEncoding = request.getHeader("Accept-Encoding");
        return acceptEncoding != null && acceptEncoding.contains("gzip");
    }

    public String getBrowserId(HttpServletRequest request) {
        if (this.isIe(request)) {
            return "ie";
        }
        if (this.isFirefox(request)) {
            return "firefox";
        }
        return "other";
    }

    public float getMajorVersion(HttpServletRequest request) {
        float majorVersion = 0.0f;
        String version = this.getVersion(request);
        Matcher matcher = _majorVersionPattern.matcher(version);
        if (matcher.find()) {
            majorVersion = GetterUtil.getFloat((String)matcher.group(1));
        }
        return majorVersion;
    }

    public String getRevision(HttpServletRequest request) {
        String revision = "";
        String userAgent = this.getUserAgent(request);
        Matcher matcher = _revisionPattern.matcher(userAgent);
        if (matcher.find()) {
            revision = matcher.group(1);
        }
        return revision;
    }

    public String getVersion(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        String version = "";
        Matcher matcher = _versionPattern.matcher(userAgent);
        if (matcher.find()) {
            version = matcher.group(1);
        } else if (this.isFirefox(request)) {
            Matcher versionFirefoxMatcher = _versionFirefoxPattern.matcher(userAgent);
            if (versionFirefoxMatcher.find()) {
                version = versionFirefoxMatcher.group(1);
            }
        } else if (this.isChrome(request)) {
            Matcher versionChromeMatcher = _versionChromePattern.matcher(userAgent);
            if (versionChromeMatcher.find()) {
                version = versionChromeMatcher.group(1);
            }
        } else {
            version = this.getRevision(request);
        }
        return version;
    }

    public boolean isAir(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("adobeair");
    }

    public boolean isChrome(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("chrome");
    }

    public boolean isFirefox(HttpServletRequest request) {
        if (!this.isMozilla(request)) {
            return false;
        }
        String userAgent = this.getUserAgent(request);
        String[] stringArray = _FIREFOX_ALIASES;
        int n = _FIREFOX_ALIASES.length;
        int n2 = 0;
        while (n2 < n) {
            String firefoxAlias = stringArray[n2];
            if (userAgent.contains(firefoxAlias)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isGecko(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("gecko");
    }

    public boolean isIe(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("msie") && !userAgent.contains("opera");
    }

    public boolean isIphone(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("iphone");
    }

    public boolean isLinux(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("linux");
    }

    public boolean isMac(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("mac");
    }

    public boolean isMobile(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("mobile");
    }

    public boolean isMozilla(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("mozilla") && !userAgent.contains("compatible") && !userAgent.contains("webkit");
    }

    public boolean isOpera(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("opera");
    }

    public boolean isRtf(HttpServletRequest request) {
        float majorVersion = this.getMajorVersion(request);
        if (this.isIe(request) && (double)majorVersion >= 5.5) {
            return true;
        }
        if (this.isMozilla(request) && (double)majorVersion >= 1.3) {
            return true;
        }
        if (!this.isMobile(request)) {
            if (this.isOpera(request) && (double)majorVersion >= 10.0) {
                return true;
            }
            if (this.isSafari(request) && (double)majorVersion >= 3.0) {
                return true;
            }
        }
        return false;
    }

    public boolean isSafari(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return this.isWebKit(request) && userAgent.contains("safari");
    }

    public boolean isSun(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.contains("sunos");
    }

    public boolean isWap(HttpServletRequest request) {
        return this.isWapXhtml(request);
    }

    public boolean isWapXhtml(HttpServletRequest request) {
        String accept = this.getAccept(request);
        return accept.contains("wap.xhtml");
    }

    public boolean isWebKit(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        String[] stringArray = _WEBKIT_ALIASES;
        int n = _WEBKIT_ALIASES.length;
        int n2 = 0;
        while (n2 < n) {
            String webKitAlias = stringArray[n2];
            if (userAgent.contains(webKitAlias)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isWindows(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        String[] stringArray = _WINDOWS_ALIASES;
        int n = _WINDOWS_ALIASES.length;
        int n2 = 0;
        while (n2 < n) {
            String windowsAlias = stringArray[n2];
            if (userAgent.contains(windowsAlias)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isWml(HttpServletRequest request) {
        String accept = this.getAccept(request);
        return accept.contains("wap.wml");
    }

    protected String getAccept(HttpServletRequest request) {
        String accept = "";
        if (request != null && (accept = (String)request.getAttribute("ACCEPT")) == null) {
            String acceptHeader = request.getHeader("ACCEPT");
            accept = acceptHeader != null ? acceptHeader.toLowerCase() : "";
            request.setAttribute("ACCEPT", (Object)accept);
        }
        return accept;
    }

    protected String getUserAgent(HttpServletRequest request) {
        String userAgent = "";
        if (request != null && (userAgent = (String)request.getAttribute("User-Agent")) == null) {
            String userAgentHeader = request.getHeader("User-Agent");
            userAgent = userAgentHeader != null ? userAgentHeader.toLowerCase() : "";
            request.setAttribute("User-Agent", (Object)userAgent);
        }
        return userAgent;
    }
}

