/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.dynamiccss.DynamicCSSUtil;
import com.liferay.portal.util.MinifierUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ComboServlet
extends HttpServlet {
    private static final String _CSS_EXTENSION = "css";
    private static final String _CSS_MINIFIED_SUFFIX = "-min.css";
    private static final FileContentBag _EMPTY_FILE_CONTENT_BAG = new FileContentBag(new byte[0], 0L);
    private static final String _JAVASCRIPT_DIR = "html/js";
    private static final String _JAVASCRIPT_MINIFIED_SUFFIX = "-min.js";
    private static Log _log = LogFactoryUtil.getLog(ComboServlet.class);
    private PortalCache _bytesArrayPortalCache = SingleVMPoolUtil.getCache((String)ComboServlet.class.getName());
    private PortalCache _fileContentBagPortalCache = SingleVMPoolUtil.getCache((String)FileContentBag.class.getName());

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.doService(request, response);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            PortalUtil.sendError((int)500, (Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String contextPath = PortalUtil.getPathContext();
        Object[] modulePaths = request.getParameterValues("m");
        if (modulePaths == null || modulePaths.length == 0) {
            response.sendError(400);
            return;
        }
        HashSet<String> modulePathsSet = new HashSet<String>(modulePaths.length);
        Object[] objectArray = modulePaths;
        int n = modulePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = objectArray[n2];
            modulePathsSet.add(path);
            ++n2;
        }
        modulePaths = modulePathsSet.toArray(new String[modulePathsSet.size()]);
        Arrays.sort(modulePaths);
        String modulePathsString = null;
        Object bytesArray = null;
        if (!PropsValues.COMBO_CHECK_TIMESTAMP) {
            modulePathsString = Arrays.toString(modulePaths);
            bytesArray = (byte[][])this._bytesArrayPortalCache.get((Serializable)((Object)modulePathsString));
        }
        Object firstModulePath = modulePaths[0];
        String extension = FileUtil.getExtension((String)firstModulePath);
        if (bytesArray == null) {
            String p = ParamUtil.getString((HttpServletRequest)request, (String)"p");
            String minifierType = ParamUtil.getString((HttpServletRequest)request, (String)"minifierType");
            if (Validator.isNull((String)minifierType)) {
                minifierType = "js";
                if (extension.equalsIgnoreCase(_CSS_EXTENSION)) {
                    minifierType = _CSS_EXTENSION;
                }
            }
            if (!minifierType.equals(_CSS_EXTENSION) && !minifierType.equals("js")) {
                minifierType = "js";
            }
            int length = modulePaths.length;
            bytesArray = new byte[length][];
            Object[] objectArray2 = modulePaths;
            int n3 = modulePaths.length;
            int n4 = 0;
            while (n4 < n3) {
                Object modulePath = objectArray2[n4];
                if (!this.validateModuleExtension((String)modulePath)) {
                    response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                    response.setStatus(404);
                    return;
                }
                byte[] bytes = new byte[]{};
                if (Validator.isNotNull((String)modulePath)) {
                    if (this.getFile((String)(modulePath = StringUtil.replaceFirst((String)p.concat((String)modulePath), (String)contextPath, (String)""))) == null) {
                        response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                        response.setStatus(404);
                        return;
                    }
                    bytes = this.getFileContent(request, response, (String)modulePath, minifierType);
                }
                bytesArray[--length] = bytes;
                ++n4;
            }
            if (modulePathsString != null && !PropsValues.COMBO_CHECK_TIMESTAMP) {
                this._bytesArrayPortalCache.put((Serializable)((Object)modulePathsString), (Serializable)bytesArray);
            }
        }
        String contentType = "text/javascript";
        if (extension.equalsIgnoreCase(_CSS_EXTENSION)) {
            contentType = "text/css";
        }
        response.setContentType(contentType);
        ServletResponseUtil.write((HttpServletResponse)response, (byte[][])bytesArray);
    }

    protected File getFile(String path) throws IOException {
        ServletContext servletContext = this.getServletContext();
        String basePath = ServletContextUtil.getRealPath((ServletContext)servletContext, (String)_JAVASCRIPT_DIR);
        if (basePath == null) {
            return null;
        }
        File baseDir = new File(basePath = StringUtil.replace((String)basePath, (char)'\\', (char)'/'));
        if (!baseDir.exists()) {
            return null;
        }
        String filePath = ServletContextUtil.getRealPath((ServletContext)servletContext, (String)path);
        if (filePath == null) {
            return null;
        }
        File file = new File(filePath = StringUtil.replace((String)filePath, (char)'\\', (char)'/'));
        if (!file.exists()) {
            return null;
        }
        String baseCanonicalPath = baseDir.getCanonicalPath();
        String fileCanonicalPath = file.getCanonicalPath();
        if (fileCanonicalPath.indexOf(baseCanonicalPath) == 0) {
            return file;
        }
        return null;
    }

    protected byte[] getFileContent(HttpServletRequest request, HttpServletResponse response, String path, String minifierType) throws IOException {
        String fileContentKey = path.concat("?").concat(minifierType);
        FileContentBag fileContentBag = (FileContentBag)this._fileContentBagPortalCache.get((Serializable)((Object)fileContentKey));
        if (fileContentBag != null && !PropsValues.COMBO_CHECK_TIMESTAMP) {
            return fileContentBag._fileContent;
        }
        File file = this.getFile(path);
        if (fileContentBag != null && PropsValues.COMBO_CHECK_TIMESTAMP) {
            long elapsedTime = System.currentTimeMillis() - fileContentBag._lastModified;
            if (file != null && elapsedTime <= PropsValues.COMBO_CHECK_TIMESTAMP_INTERVAL && file.lastModified() == fileContentBag._lastModified) {
                return fileContentBag._fileContent;
            }
            this._fileContentBagPortalCache.remove((Serializable)((Object)fileContentKey));
        }
        if (file == null) {
            fileContentBag = _EMPTY_FILE_CONTENT_BAG;
        } else {
            String stringFileContent = FileUtil.read((File)file);
            if (!StringUtil.endsWith((String)path, (String)_CSS_MINIFIED_SUFFIX) && !StringUtil.endsWith((String)path, (String)_JAVASCRIPT_MINIFIED_SUFFIX)) {
                if (minifierType.equals(_CSS_EXTENSION)) {
                    String cssRealPath = file.getAbsolutePath();
                    try {
                        stringFileContent = DynamicCSSUtil.parseSass(request, cssRealPath, stringFileContent);
                    }
                    catch (Exception e2) {
                        _log.error((Object)("Unable to parse SASS on CSS " + cssRealPath), (Throwable)e2);
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)stringFileContent);
                        }
                        response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                    }
                    stringFileContent = MinifierUtil.minifyCss(stringFileContent);
                } else if (minifierType.equals("js")) {
                    stringFileContent = MinifierUtil.minifyJavaScript(stringFileContent);
                }
            }
            fileContentBag = new FileContentBag(stringFileContent.getBytes("UTF-8"), file.lastModified());
        }
        if (PropsValues.COMBO_CHECK_TIMESTAMP) {
            int timeToLive = (int)(PropsValues.COMBO_CHECK_TIMESTAMP_INTERVAL / 1000L);
            this._fileContentBagPortalCache.put((Serializable)((Object)fileContentKey), (Serializable)fileContentBag, timeToLive);
        }
        return fileContentBag._fileContent;
    }

    protected boolean validateModuleExtension(String moduleName) throws Exception {
        boolean validModuleExtension = false;
        String[] fileExtensions = PrefsPropsUtil.getStringArray("combo.allowed.file.extensions", ",");
        int i2 = 0;
        while (i2 < fileExtensions.length) {
            if ("*".equals(fileExtensions[i2]) || StringUtil.endsWith((String)moduleName, (String)fileExtensions[i2])) {
                validModuleExtension = true;
                break;
            }
            ++i2;
        }
        return validModuleExtension;
    }

    private static class FileContentBag
    implements Serializable {
        private byte[] _fileContent;
        private long _lastModified;

        public FileContentBag(byte[] fileContent, long lastModifiedTime) {
            this._fileContent = fileContent;
            this._lastModified = lastModifiedTime;
        }
    }
}

