/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.DirectRequestDispatcherFactory;
import com.liferay.portal.kernel.servlet.DirectServletRegistryUtil;
import com.liferay.portal.kernel.util.ContextPathUtil;
import com.liferay.portal.servlet.DirectRequestDispatcher;
import com.liferay.portal.servlet.DirectServletPathRegisterDispatcher;
import com.liferay.portal.servlet.PACLRequestDispatcherWrapper;
import com.liferay.portal.util.PropsValues;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;

public class DirectRequestDispatcherFactoryImpl
implements DirectRequestDispatcherFactory {
    private static Log _log = LogFactoryUtil.getLog(DirectRequestDispatcherFactoryImpl.class);

    public RequestDispatcher getRequestDispatcher(ServletContext servletContext, String path) {
        return new PACLRequestDispatcherWrapper(servletContext, this.doGetRequestDispatcher(servletContext, path));
    }

    public RequestDispatcher getRequestDispatcher(ServletRequest servletRequest, String path) {
        if (!PropsValues.DIRECT_SERVLET_CONTEXT_ENABLED) {
            return servletRequest.getRequestDispatcher(path);
        }
        ServletContext servletContext = (ServletContext)servletRequest.getAttribute("CTX");
        if (servletContext == null) {
            throw new IllegalStateException("Cannot find servlet context in request attributes");
        }
        return this.getRequestDispatcher(servletContext, path);
    }

    protected RequestDispatcher doGetRequestDispatcher(ServletContext servletContext, String path) {
        Servlet servlet;
        if (!PropsValues.DIRECT_SERVLET_CONTEXT_ENABLED) {
            return servletContext.getRequestDispatcher(path);
        }
        if (path == null || path.length() == 0) {
            return null;
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Path " + path + " is not relative to context root");
        }
        String contextPath = ContextPathUtil.getContextPath((ServletContext)servletContext);
        String fullPath = contextPath.concat(path);
        String queryString = null;
        int pos = fullPath.indexOf(63);
        if (pos != -1) {
            queryString = fullPath.substring(pos + 1);
            fullPath = fullPath.substring(0, pos);
        }
        if ((servlet = DirectServletRegistryUtil.getServlet((String)fullPath)) == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No servlet found for " + fullPath));
            }
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
            return new DirectServletPathRegisterDispatcher(path, requestDispatcher);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Servlet found for " + fullPath));
        }
        return new DirectRequestDispatcher(servlet, queryString);
    }
}

