/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PortalUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I18nServlet
extends HttpServlet {
    private static Log _log = LogFactoryUtil.getLog(I18nServlet.class);
    private static Set<String> _languageIds = new HashSet<String>();

    public static Set<String> getLanguageIds() {
        return _languageIds;
    }

    public static void setLanguageIds(Element root) {
        for (Element el : root.elements("servlet-mapping")) {
            String servletName = el.elementText("servlet-name");
            if (!servletName.equals("I18n Servlet")) continue;
            String urlPattern = el.elementText("url-pattern");
            String languageId = urlPattern.substring(0, urlPattern.lastIndexOf(47));
            _languageIds.add(languageId);
        }
        _languageIds = Collections.unmodifiableSet(_languageIds);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String[] i18nData = this.getI18nData(request);
            if (i18nData == null || !PortalUtil.isValidResourceId((String)i18nData[2])) {
                PortalUtil.sendError((int)404, (Exception)((Object)new NoSuchLayoutException()), (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                String i18nLanguageId = i18nData[0];
                String i18nPath = i18nData[1];
                String redirect = i18nData[2];
                request.setAttribute("I18N_LANGUAGE_ID", (Object)i18nLanguageId);
                request.setAttribute("I18N_PATH", (Object)i18nPath);
                ServletContext servletContext = this.getServletContext();
                RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(redirect);
                requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            PortalUtil.sendError((int)500, (Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected String[] getI18nData(HttpServletRequest request) {
        String path = request.getRequestURI();
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        if (Validator.isNull((String)(path = path.substring(contextPath.length() + servletPath.length())))) {
            return null;
        }
        String i18nLanguageId = servletPath;
        int pos = i18nLanguageId.lastIndexOf(47);
        i18nLanguageId = i18nLanguageId.substring(pos + 1);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Language ID " + i18nLanguageId));
        }
        if (Validator.isNull((String)i18nLanguageId)) {
            return null;
        }
        String i18nPath = "/" + i18nLanguageId;
        Locale locale = LocaleUtil.fromLanguageId((String)i18nLanguageId);
        if (Validator.isNull((String)locale.getCountry())) {
            locale = LanguageUtil.getLocale((String)locale.getLanguage());
            i18nLanguageId = LocaleUtil.toLanguageId((Locale)locale);
        }
        String redirect = path;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Redirect " + redirect));
        }
        return new String[]{i18nLanguageId, i18nPath, redirect};
    }
}

