/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.action.JSONServiceAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.struts.JSONAction;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSONServlet
extends HttpServlet {
    private static Log _log = LogFactoryUtil.getLog(JSONServlet.class);
    private JSONAction _jsonAction;
    private ClassLoader _pluginClassLoader;

    public void init(ServletConfig servletConfig) {
        ServletContext servletContext = servletConfig.getServletContext();
        this._pluginClassLoader = (ClassLoader)servletContext.getAttribute("PLUGIN_CLASS_LOADER");
        this._jsonAction = this.getJSONAction(servletContext);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block6: {
            try {
                this.resolveRemoteUser(request);
                if (this._pluginClassLoader == null) {
                    this._jsonAction.execute(null, null, request, response);
                    break block6;
                }
                ClassLoader contextClassLoader = PACLClassLoaderUtil.getContextClassLoader();
                try {
                    PACLClassLoaderUtil.setContextClassLoader(this._pluginClassLoader);
                    this._jsonAction.execute(null, null, request, response);
                }
                finally {
                    PACLClassLoaderUtil.setContextClassLoader(contextClassLoader);
                }
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
    }

    protected JSONAction getJSONAction(ServletContext servletContext) {
        JSONServiceAction jsonAction = new JSONServiceAction();
        jsonAction.setServletContext(servletContext);
        return jsonAction;
    }

    protected void resolveRemoteUser(HttpServletRequest request) throws Exception {
        String remoteUser = request.getRemoteUser();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Remote user " + remoteUser));
        }
        if (remoteUser != null) {
            PrincipalThreadLocal.setName((String)remoteUser);
            long userId = GetterUtil.getLong((String)remoteUser);
            User user = UserLocalServiceUtil.getUserById((long)userId);
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
    }
}

