/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.PACLPolicyManager;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class PACLRequestDispatcherWrapper
implements RequestDispatcher {
    private RequestDispatcher _requestDispatcher;
    private ServletContext _servletContext;

    public PACLRequestDispatcherWrapper(ServletContext servletContext, RequestDispatcher requestDispatcher) {
        this._servletContext = servletContext;
        this._requestDispatcher = requestDispatcher;
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        this.doDispatch(servletRequest, servletResponse, false);
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        this.doDispatch(servletRequest, servletResponse, true);
    }

    protected void doDispatch(ServletRequest servletRequest, ServletResponse servletResponse, boolean include) throws IOException, ServletException {
        ClassLoader contextClassLoader = PACLClassLoaderUtil.getContextClassLoader();
        ClassLoader pluginClassLoader = (ClassLoader)this._servletContext.getAttribute("PLUGIN_CLASS_LOADER");
        PACLPolicy paclPolicy = PortalSecurityManagerThreadLocal.getPACLPolicy();
        try {
            if (pluginClassLoader == null) {
                PortalSecurityManagerThreadLocal.setPACLPolicy(null);
                PACLClassLoaderUtil.setContextClassLoader(PACLClassLoaderUtil.getPortalClassLoader());
            } else {
                PACLPolicy pluginPACLPolicy = PACLPolicyManager.getPACLPolicy(pluginClassLoader);
                PortalSecurityManagerThreadLocal.setPACLPolicy(pluginPACLPolicy);
                PACLClassLoaderUtil.setContextClassLoader(pluginClassLoader);
            }
            if (include) {
                this._requestDispatcher.include(servletRequest, servletResponse);
            } else {
                this._requestDispatcher.forward(servletRequest, servletResponse);
            }
        }
        finally {
            PACLClassLoaderUtil.setContextClassLoader(contextClassLoader);
            PortalSecurityManagerThreadLocal.setPACLPolicy(paclPolicy);
        }
    }
}

