/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalInstances;
import javax.servlet.http.HttpServletRequest;

public class UserResolver {
    private long _companyId;
    private User _user;

    public UserResolver(HttpServletRequest request) throws PortalException, SystemException {
        this._companyId = ParamUtil.getLong((HttpServletRequest)request, (String)"companyId");
        String remoteUser = request.getRemoteUser();
        if (remoteUser != null) {
            PrincipalThreadLocal.setName((String)remoteUser);
            long userId = GetterUtil.getLong((String)remoteUser);
            this._user = UserLocalServiceUtil.getUserById((long)userId);
            if (this._companyId == 0L) {
                this._companyId = this._user.getCompanyId();
            }
        } else {
            if (this._companyId == 0L) {
                this._companyId = PortalInstances.getCompanyId(request);
            }
            if (this._companyId != 0L) {
                this._user = UserLocalServiceUtil.getDefaultUser((long)this._companyId);
            }
        }
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public User getUser() {
        return this._user;
    }
}

